/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.ChunkInformation;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messagetypes.FetchRequestAbstract;
import de.osci.osci12.messagetypes.ResponseToFetchAbstract;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.OsciH;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;

public class PartialFetchDelivery
extends FetchRequestAbstract {
    private ChunkInformation chunkInformation;

    PartialFetchDelivery() {
        this.messageType = 50;
        this.setBase64Encoding(false);
    }

    public PartialFetchDelivery(DialogHandler dh, ChunkInformation chunkInforamtion) throws NoSuchAlgorithmException {
        super(dh);
        this.messageType = 50;
        this.originator = (Originator)dh.getClient();
        this.setChunkInformation(chunkInforamtion);
        this.setBase64Encoding(false);
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.dialogHandler.getControlblock().setSequenceNumber(this.dialogHandler.getControlblock().getSequenceNumber() + 1);
    }

    public ChunkInformation getChunkInformation() {
        return this.chunkInformation;
    }

    public void setChunkInformation(ChunkInformation chunkInformation) {
        this.chunkInformation = chunkInformation;
    }

    public ResponseToFetchAbstract send() throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToFetchAbstract)this.transmit(null, null);
    }

    public ResponseToFetchAbstract send(OutputStream storeOutput, OutputStream storeInput) throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToFetchAbstract)this.transmit(storeOutput, storeInput);
    }

    @Override
    void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign();
        this.messageParts.set(5, this.nonIntermediaryCertificatesH);
        this.messageParts.set(3, null);
    }

    @Override
    protected void compose() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(3, null);
        if (this.dialogHandler.getControlblock().getChallenge() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Challenge");
        }
        if (this.dialogHandler.getControlblock().getResponse() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Response");
        }
        if (this.dialogHandler.getControlblock().getConversationID() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Conversation-Id");
        }
        if (this.dialogHandler.getControlblock().getSequenceNumber() == -1) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SequenceNumber");
        }
        StringBuilder selection = new StringBuilder(this.getSelectionRuleString());
        ByteArrayOutputStream chunkInformationXml = new ByteArrayOutputStream();
        MessagePartsFactory.writeXML(this.chunkInformation, chunkInformationXml);
        selection.append(chunkInformationXml);
        this.osciH = new OsciH(Constants.HeaderTags.partialFetchDelivery.getElementName(), selection.toString(), this.osci2017NSPrefix);
        this.messageParts.add(this.osciH);
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.body = new Body("");
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

