/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Canonizer;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messagetypes.AcceptDeliveryBuilder;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.ProcessDeliveryBuilder;
import de.osci.osci12.messagetypes.ResponseToExitDialogBuilder;
import de.osci.osci12.messagetypes.ResponseToFetchDeliveryBuilder;
import de.osci.osci12.messagetypes.ResponseToFetchProcessCardBuilder;
import de.osci.osci12.messagetypes.ResponseToForwardDeliveryBuilder;
import de.osci.osci12.messagetypes.ResponseToGetMessageIdBuilder;
import de.osci.osci12.messagetypes.ResponseToInitDialogBuilder;
import de.osci.osci12.messagetypes.ResponseToMediateDeliveryBuilder;
import de.osci.osci12.messagetypes.ResponseToPartialFetchDeliveryBuilder;
import de.osci.osci12.messagetypes.ResponseToPartialStoreDeliveryBuilder;
import de.osci.osci12.messagetypes.ResponseToStoreDeliveryBuilder;
import de.osci.osci12.messagetypes.SOAPFaultBuilder;
import de.osci.osci12.messagetypes.SOAPMessageEncryptedBuilder;
import de.osci.osci12.roles.OSCIRoleException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class OSCIEnvelopeBuilder
extends DefaultHandler {
    static final String XSD_ENC_SIG = "http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_INIT_DIALOG = "http://schemas.xmlsoap.org/soap/envelope/ soapInitDialog.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_INIT_DIALOG = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToInitDialog.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_EXIT_DIALOG = "http://schemas.xmlsoap.org/soap/envelope/ soapExitDialog.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_EXIT_DIALOG = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToExitDialog.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_GET_MSG_ID = "http://schemas.xmlsoap.org/soap/envelope/ soapGetMessageId.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_GET_MSG_ID = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToGetMessageId.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_STORE_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapStoreDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_STORE_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToStoreDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_FETCH_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapFetchDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_FETCH_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToFetchDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_FETCH_PROCESS_CARD = "http://schemas.xmlsoap.org/soap/envelope/ soapFetchProcessCard.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_FETCH_PROCESS_CARD = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToFetchProcessCard.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_FORWARD_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapForwardDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_FORWARD_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToForwardDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_ACCEPT_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapAcceptDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_ACCEPT_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToAcceptDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_MEDIATE_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapMediateDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_MEDIATE_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToMediateDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_PROCESS_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapProcessDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_PROCESS_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToProcessDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_MESSAGE_FAULT = "http://schemas.xmlsoap.org/soap/envelope/ soapMessageFault.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_ENCRYPTED_DATA = "http://schemas.xmlsoap.org/soap/envelope/ soapMessageEncrypted.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_PARTIAL_STORE_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapPartialStoreDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_PARTIAL_STORE_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToPartialStoreDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_PARTIAL_FETCH_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapPartialFetchDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    static final String XSD_RSP_PARTIAL_FETCH_DELIVERY = "http://schemas.xmlsoap.org/soap/envelope/ soapResponseToPartialFetchDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd";
    private static Log log = LogFactory.getLog(OSCIEnvelopeBuilder.class);
    protected OSCIMessage msg = null;
    XMLReader xmlReader = null;
    Canonizer hashNCanStream = null;
    protected DialogHandler dhHandler = null;
    String soapNSPrefix;
    String osciNSPrefix;
    String osci2017NSPrefix;
    String osci2019NSPrefix;
    String dsNSPrefix;
    String xencNSPrefix;
    StringBuffer ns;
    OSCIMessageBuilder childBuilder = null;

    public OSCIEnvelopeBuilder(XMLReader xmlReader, DialogHandler dh) {
        this.xmlReader = xmlReader;
        this.dhHandler = dh;
        this.ns = new StringBuffer();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (uri.equals(OSCIMessageBuilder.SOAP_XMLNS)) {
            this.soapNSPrefix = prefix;
        } else if (uri.equals(OSCIMessageBuilder.OSCI_XMLNS)) {
            this.osciNSPrefix = prefix;
        } else if (uri.equals(OSCIMessageBuilder.OSCI_2019_XMLNS)) {
            this.osci2019NSPrefix = prefix;
        } else if (uri.equals(Constants.Namespaces.OSCI2017.getUri())) {
            this.osci2017NSPrefix = prefix;
        } else if (uri.equals(OSCIMessageBuilder.DS_XMLNS)) {
            this.dsNSPrefix = prefix;
        } else if (uri.equals(OSCIMessageBuilder.XENC_XMLNS)) {
            this.xencNSPrefix = prefix;
        }
        this.ns.append(" xmlns:" + prefix + "=\"" + uri + "\"");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start-Element: " + localName + "\n" + uri + "\n" + qName + attributes.getLength()));
        }
        if (this.soapNSPrefix == null || !localName.equals("Envelope")) {
            throw new SAXException(DialogHandler.text.getString("msg_format_error") + ": " + localName);
        }
        String schemaLocation = attributes.getValue("xsi:schemaLocation");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Nachrichtentyp: " + schemaLocation));
        }
        try {
            if (schemaLocation == null) {
                this.childBuilder = new SOAPFaultBuilder(this);
            } else if (schemaLocation.equals(XSD_ENCRYPTED_DATA)) {
                try {
                    this.childBuilder = new SOAPMessageEncryptedBuilder(this);
                }
                catch (Exception ex) {
                    throw new SAXException(ex);
                }
            } else if (schemaLocation.equals(XSD_ACCEPT_DELIVERY)) {
                this.childBuilder = new AcceptDeliveryBuilder(this);
            } else if (schemaLocation.equals(XSD_RSP_FORWARD_DELIVERY)) {
                this.childBuilder = new ResponseToForwardDeliveryBuilder(this);
            } else if (schemaLocation.equals(XSD_RSP_INIT_DIALOG)) {
                this.childBuilder = new ResponseToInitDialogBuilder(this);
            } else if (schemaLocation.equals(XSD_PROCESS_DELIVERY)) {
                this.childBuilder = new ProcessDeliveryBuilder(this);
            } else if (schemaLocation.equals(XSD_RSP_MEDIATE_DELIVERY)) {
                this.childBuilder = new ResponseToMediateDeliveryBuilder(this);
            } else if (schemaLocation.equals(XSD_RSP_GET_MSG_ID)) {
                this.childBuilder = new ResponseToGetMessageIdBuilder(this);
            } else if (schemaLocation.equals(XSD_RSP_EXIT_DIALOG)) {
                this.childBuilder = new ResponseToExitDialogBuilder(this);
            } else if (schemaLocation.equals(XSD_RSP_STORE_DELIVERY)) {
                this.childBuilder = new ResponseToStoreDeliveryBuilder(this);
            } else if (schemaLocation.equals(XSD_RSP_FETCH_DELIVERY)) {
                this.childBuilder = new ResponseToFetchDeliveryBuilder(this);
            } else if (schemaLocation.equals(XSD_RSP_FETCH_PROCESS_CARD)) {
                this.childBuilder = new ResponseToFetchProcessCardBuilder(this);
            } else if (schemaLocation.equals(XSD_RSP_PARTIAL_STORE_DELIVERY)) {
                this.childBuilder = new ResponseToPartialStoreDeliveryBuilder(this);
            } else if (schemaLocation.equals(XSD_RSP_PARTIAL_FETCH_DELIVERY)) {
                this.childBuilder = new ResponseToPartialFetchDeliveryBuilder(this);
            } else {
                log.error((Object)("Falsche OSCI-Nachricht. Nachrichtentyp nicht bekannt! Nachrichtentypt ist:\n" + schemaLocation + "\nhttp://schemas.xmlsoap.org/soap/envelope/ soapResponseToFetchProcessCard.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd"));
                throw new SAXException(DialogHandler.text.getString("sax_exception_msgtype"));
            }
            this.xmlReader.setContentHandler(this.childBuilder);
            this.childBuilder.getOSCIMessage().soapNSPrefix = this.soapNSPrefix;
            this.childBuilder.getOSCIMessage().osciNSPrefix = this.osciNSPrefix;
            this.childBuilder.getOSCIMessage().osci2017NSPrefix = this.osci2017NSPrefix;
            this.childBuilder.getOSCIMessage().osci2019NSPrefix = this.osci2019NSPrefix;
            this.childBuilder.getOSCIMessage().dsNSPrefix = this.dsNSPrefix;
            this.childBuilder.getOSCIMessage().xencNSPrefix = this.xencNSPrefix;
            this.childBuilder.getOSCIMessage().ns = this.ns.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SAXException(ex);
        }
        catch (OSCIRoleException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void endDocument() {
        this.childBuilder.getOSCIMessage().hashableMsgPart = this.hashNCanStream.getDigestValues();
        this.childBuilder.getOSCIMessage().parsedMsgPartsIds = this.childBuilder.parsedMsgPartsIds;
        if (this.childBuilder.getOSCIMessage().signatureHeader != null) {
            this.childBuilder.getOSCIMessage().signatureHeader.signedInfo = this.hashNCanStream.getSignedInfos().remove(0);
        }
        this.childBuilder.getOSCIMessage().stateOfMsg |= 4;
    }

    public XMLReader getXmlReader() {
        return this.xmlReader;
    }
}

