/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64InputStream;
import de.osci.helper.Canonizer;
import de.osci.helper.MIMEParser;
import de.osci.helper.MIMEPartInputStream;
import de.osci.helper.ParserHelper;
import de.osci.helper.StoreInputStream;
import de.osci.helper.SymCipherInputStream;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCIErrorException;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.common.SoapClientException;
import de.osci.osci12.common.SoapServerException;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.encryption.EncryptedData;
import de.osci.osci12.encryption.OSCICipherException;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.OSCISignature;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.messagetypes.SOAPMessageEncrypted;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Role;
import de.osci.osci12.soapheader.FeatureDescriptionH;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

abstract class IncomingMSGParser {
    private static Log log = LogFactory.getLog(IncomingMSGParser.class);
    protected static Role[] defaultSupplier;
    protected int searchPointer;

    abstract OSCIEnvelopeBuilder getParser(XMLReader var1, DialogHandler var2);

    OSCIMessage parse(InputStream is, DialogHandler dh, StoreInputStream storeInStream) throws IOException, OSCIException, NoSuchAlgorithmException {
        XMLReader reader = null;
        OSCIEnvelopeBuilder builder = null;
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setValidating(false);
            SAXParser parser = saxFactory.newSAXParser();
            reader = parser.getXMLReader();
            ParserHelper.setFeatures(reader);
            builder = this.getParser(reader, dh);
            reader.setContentHandler(builder);
            reader.setErrorHandler(builder);
            builder.hashNCanStream = new Canonizer(is, storeInStream);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Aktivierung des SAXParsers. ");
            }
            reader.parse(new InputSource(builder.hashNCanStream));
            if (builder.hashNCanStream.getCanException() != null) {
                throw new IOException();
            }
        }
        catch (SAXException ex) {
            if (ex.getException() != null && ex.getException() instanceof IllegalStateException) {
                throw (IllegalStateException)ex.getException();
            }
            if (ex.getException() != null && ex.getException() instanceof OSCIException) {
                throw (OSCIException)ex.getException();
            }
            log.error((Object)"", (Throwable)ex);
            if (ex instanceof SAXParseException) {
                log.error((Object)("\nSPALTE: " + ((SAXParseException)ex).getColumnNumber() + "\nZEILE: " + ((SAXParseException)ex).getLineNumber()), (Throwable)ex);
            }
            throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.OSCIMsgStructureNotValid);
        }
        catch (FactoryConfigurationError | ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IOException ex) {
            Exception e = builder.hashNCanStream.getCanException();
            if (e != null) {
                if (e instanceof SAXException) {
                    if (((SAXException)e).getException() != null && ((SAXException)e).getException() instanceof OSCIException) {
                        throw (OSCIException)((SAXException)e).getException();
                    }
                    throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.OSCIMsgStructureNotValid);
                }
                throw (IOException)e;
            }
            throw ex;
        }
        finally {
            if (null != builder) {
                byte[] tmp = new byte[64];
                while (builder.hashNCanStream.read(tmp) > -1) {
                }
            }
        }
        return builder.childBuilder.msg;
    }

    OSCIMessage parseStream(InputStream in, DialogHandler dial, boolean request, OutputStream storeStream) throws IOException, OSCIException, NoSuchAlgorithmException {
        return this.parseStream(in, dial, request, false, storeStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OSCIMessage parseStream(InputStream in, DialogHandler dial, boolean request, boolean decryptedStream, OutputStream storeStream) throws IOException, OSCIException, NoSuchAlgorithmException {
        Role role;
        EncryptedData ed;
        MIMEPartInputStream mimeStream;
        MIMEParser incomingMsg;
        OSCIMessage msg;
        block39: {
            block38: {
                msg = null;
                incomingMsg = null;
                mimeStream = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Starte Parser: " + in.available()));
                }
                StoreInputStream sis = null;
                if (storeStream != null) {
                    sis = new StoreInputStream(in, storeStream);
                    incomingMsg = new MIMEParser(sis);
                } else {
                    incomingMsg = new MIMEParser(in);
                }
                mimeStream = incomingMsg.getNextStream();
                msg = this.parse(mimeStream, dial, sis);
                msg.boundaryString = incomingMsg.boundary;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fertig mit Parsen des Transport Objektes. Msgtype: " + msg.getClass().toString()));
                }
                if (msg.getMessageType() == 256) {
                    try {
                        ed = ((SOAPMessageEncrypted)msg).encData;
                        mimeStream = incomingMsg.getNextStream();
                        String s = null;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Mime ID:  " + mimeStream.getContentID() + " Encrypted ID: " + ed.getCipherData().getCipherReference().getURI()));
                        }
                        if (!(s = "cid:" + mimeStream.getContentID()).equals(ed.getCipherData().getCipherReference().getURI())) {
                            throw new IllegalArgumentException(DialogHandler.text.getString("msg_format_error") + s);
                        }
                        role = null;
                        X509Certificate cert = null;
                        if (dial == null) {
                            role = null;
                            break block38;
                        }
                        try {
                            cert = request ? dial.getSupplier().getCipherCertificate() : dial.getClient().getCipherCertificate();
                            if (!cert.equals(ed.getKeyInfo().getEncryptedKeys()[0].getKeyInfo().getX509Data().getX509Certificate())) break block39;
                            if (request) {
                                role = dial.getSupplier();
                                break block39;
                            }
                            role = dial.getClient();
                        }
                        catch (OSCIRoleException i) {
                            // empty catch block
                        }
                        break block39;
                    }
                    catch (SoapClientException ex) {
                        throw ex;
                    }
                    catch (SoapServerException ex) {
                        throw ex;
                    }
                    catch (IllegalStateException ex) {
                        throw ex;
                    }
                    catch (OSCIException ex) {
                        log.error((Object)"SOAP", (Throwable)ex);
                        throw ex;
                    }
                    catch (Exception ex) {
                        log.error((Object)"SOAP", (Throwable)ex);
                        throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.CouldNotDecryptRequestData);
                    }
                }
                if (!request && msg.dialogHandler.isEncryption() && !decryptedStream && msg.getMessageType() != 176) {
                    throw new OSCICipherException(DialogHandler.text.getString("unencrypted_msg"));
                }
                msg.dialogHandler.setEncryption(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Es handelte sich um eine nicht Verschl\u00fcsselte Nachricht");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"N\u00e4chster Schritt: Verarbeitung der Attachments");
                }
                this.readAttachment(msg, incomingMsg);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Die Signaturen werden \u00fcberpr\u00fcft.");
                }
                if (msg.dialogHandler.isCheckSignatures() && msg.signatureHeader != null) {
                    boolean sigErg = this.checkMsgHashes(msg);
                    if (!sigErg) {
                        log.error((Object)"Die Signaturen der XML-OSCI-Daten sind fehlerhaft.");
                        throw new OSCIErrorException((OSCIExceptionCodes.OSCIExceptionCodesI)OSCIExceptionCodes.OSCIErrorCodes.SignatureInvalid, msg);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Unsignierte-Nachricht");
                }
                if (!log.isDebugEnabled()) return msg;
                log.debug((Object)("Alles ist Fertig " + msg.getMessageType()));
                return msg;
            }
            for (int i = 0; i < defaultSupplier.length; ++i) {
                if (!defaultSupplier[i].getCipherCertificate().equals(ed.getKeyInfo().getEncryptedKeys()[0].getKeyInfo().getX509Data().getX509Certificate())) continue;
                role = defaultSupplier[i];
                break;
            }
            if (role == null) {
                throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.NoEncKeyPresentOnMessgeLevel);
            }
        }
        if (role == null) {
            throw new OSCIRoleException("no_private_key");
        }
        if (!ed.getKeyInfo().getEncryptedKeys()[0].getEncryptionMethodAlgorithm().equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") && !ed.getKeyInfo().getEncryptedKeys()[0].getEncryptionMethodAlgorithm().equals("http://www.w3.org/2009/xmlenc11#rsa-oaep")) {
            throw new NoSuchAlgorithmException(DialogHandler.text.getString("encryption_algorithm_not_supported") + ed.getKeyInfo().getEncryptedKeys()[0].getEncryptionMethodAlgorithm());
        }
        if (!Constants.JCA_JCE_MAP.containsKey(ed.getEncryptionMethodAlgorithm())) {
            throw new NoSuchAlgorithmException(DialogHandler.text.getString("encryption_algorithm_not_supported") + ed.getEncryptionMethodAlgorithm());
        }
        InputStream inKey = ed.getKeyInfo().getEncryptedKeys()[0].getCipherData().getCipherValue().getCipherValueStream();
        inKey.reset();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int anz = 0;
        byte[] bytes = new byte[256];
        while ((anz = inKey.read(bytes)) > -1) {
            bos.write(bytes, 0, anz);
        }
        inKey.close();
        byte[] decryptedKey = ed.getKeyInfo().getEncryptedKeys()[0].getEncryptionMethodAlgorithm().equals("http://www.w3.org/2009/xmlenc11#rsa-oaep") ? role.getDecrypter().decrypt(bos.toByteArray(), ed.getKeyInfo().getEncryptedKeys()[0].mgfAlgorithm, ed.getKeyInfo().getEncryptedKeys()[0].digestAlgorithm) : role.getDecrypter().decrypt(bos.toByteArray());
        boolean b64 = mimeStream.getEncoding().equalsIgnoreCase("base64") || mimeStream.getContentType().equalsIgnoreCase("text/base64");
        FilterInputStream input = b64 ? new Base64InputStream(mimeStream) : mimeStream;
        String symEncMethod = ed.getEncryptionMethodAlgorithm();
        if (!ed.isIvLengthParsed()) {
            ed.setIvLength(16);
        }
        SymCipherInputStream cin = new SymCipherInputStream(input, Crypto.createSymKey(decryptedKey, symEncMethod), symEncMethod, ed.getIvLength(), false);
        if (log.isDebugEnabled()) {
            log.debug((Object)"#################### Encrypted OSCI-Msg wurde komplett verarbeitet, nun wird der Transportumschlag ge\u00f6ffnet und die eigentliche OSCI-Nachricht betrachtet ####################");
        }
        msg = this.parseStream(cin, dial, request, true, storeStream);
        msg.setBase64Encoding(b64);
        msg.dialogHandler.setEncryption(true);
        FeatureDescriptionH featureDesc = msg.getFeatureDescription();
        if (symEncMethod.endsWith("-cbc") && featureDesc != null && featureDesc.getSupportedFeatures() != null && featureDesc.getSupportedFeatures().contains((Object)Constants.OSCIFeatures.GCMPaddingModus) && ParserHelper.isSwitchToGCM()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"GCM wird in aktueller OSCI-Kommunikation unterst\u00fctzt, benutze GCM f\u00fcr symmetrische Transportverschl\u00fcsselung");
            }
            msg.dialogHandler.setSymmetricCipherAlgorithm("http://www.w3.org/2009/xmlenc11#aes256-gcm");
        } else {
            msg.dialogHandler.setSymmetricCipherAlgorithm(symEncMethod);
        }
        msg.dialogHandler.setAsymmetricCipherAlgorithm(ed.getKeyInfo().getEncryptedKeys()[0].getEncryptionMethodAlgorithm());
        incomingMsg.getNextStream();
        return msg;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean checkMsgHashes(OSCIMessage msg) throws OSCIErrorException {
        try {
            void var4_10;
            OSCISignature sig = msg.signatureHeader;
            if (sig.getDigestMethods().containsValue("http://www.w3.org/2000/09/xmldsig#sha1")) {
                log.info((Object)"SHA-1 used as digest algorithm for message signature.");
            }
            if (sig.signatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                log.info((Object)"SHA-1 with RSA used as signature algorithm for message signature.");
            }
            for (String string : msg.parsedMsgPartsIds.keySet()) {
                if (msg.hashableMsgPart.containsKey(string)) continue;
                log.error((Object)("MessagePart with id:  " + string + " not hashed"));
                throw new OSCIErrorException((OSCIExceptionCodes.OSCIExceptionCodesI)OSCIExceptionCodes.OSCIErrorCodes.NotAllRelevantPartsSigned, msg);
            }
            Hashtable<String, byte[]> refsHash = sig.getDigests();
            if (refsHash.size() != msg.hashableMsgPart.size()) {
                log.error((Object)"The number of references and hashed parts are not equil");
                return false;
            }
            for (String key : refsHash.keySet()) {
                if (msg.hashableMsgPart.get(key) == null) {
                    log.error((Object)("Element zur Signatur-Referenz '" + key + "' nicht in Nachricht gefunden."));
                    return false;
                }
                if (!MessageDigest.isEqual(msg.hashableMsgPart.get(key), refsHash.get(key))) {
                    log.error((Object)("Hashwerte der Signatur-Referenz '" + key + "' stimmen nicht \u00fcberein."));
                    return false;
                }
                msg.hashableMsgPart.remove(key);
            }
            if (msg.hashableMsgPart.size() > 0) {
                log.error((Object)("Nachricht enth\u00e4lt " + msg.hashableMsgPart.size() + "unsignierte Elemente."));
                throw new OSCIErrorException((OSCIExceptionCodes.OSCIExceptionCodesI)OSCIExceptionCodes.OSCIErrorCodes.NotAllRelevantPartsSigned, msg);
            }
            if (DialogHandler.getSecurityProvider() == null) {
                Signature signature = Signature.getInstance(Constants.JCA_JCE_MAP.get(sig.signatureAlgorithm));
            } else {
                Signature signature = Signature.getInstance(Constants.JCA_JCE_MAP.get(sig.signatureAlgorithm), DialogHandler.getSecurityProvider());
            }
            X509Certificate c = msg instanceof OSCIRequest ? msg.dialogHandler.getClient().getSignatureCertificate() : msg.dialogHandler.getSupplier().getSignatureCertificate();
            msg.signerCert = c;
            if (c.getKeyUsage() != null && !c.getKeyUsage()[0] && !c.getKeyUsage()[1]) {
                log.error((Object)"Signature certificate has wrong key usage.");
                return false;
            }
            var4_10.initVerify(c.getPublicKey());
            var4_10.update(sig.getSignedInfoBytes());
            if (log.isDebugEnabled()) {
                log.debug((Object)("vor check signature" + new String(sig.getSignedInfoBytes())));
            }
            if (!var4_10.verify(sig.signatureValue)) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Nach check Signature");
            }
            return true;
        }
        catch (OSCIErrorException ex) {
            log.error((Object)"Es ist ein Fehler beim \u00fcberpr\u00fcfen der Hashwerte aufgetreten.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"Es ist ein Fehler beim \u00fcberpr\u00fcfen der Hashwerte aufgetreten.", (Throwable)ex);
            return false;
        }
    }

    private void readAttachment(OSCIMessage msg, MIMEParser incomingMsg) throws IOException, NoSuchAlgorithmException {
        MIMEPartInputStream mimeStream = null;
        Attachment[] atts = msg.getAttachments();
        HashSet<String> foundAtts = new HashSet<String>();
        while ((mimeStream = incomingMsg.getNextStream()) != null) {
            boolean b64;
            Attachment att = null;
            String refId = mimeStream.getContentID();
            if (foundAtts.contains(refId)) {
                throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + refId);
            }
            foundAtts.add(refId);
            boolean bl = b64 = mimeStream.getEncoding().equalsIgnoreCase("base64") || mimeStream.getContentType().equalsIgnoreCase("text/base64");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attachment RefId: " + refId));
            }
            for (int i = 0; i < atts.length; ++i) {
                if (!atts[i].getRefID().equals(refId)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Vorbereitetes Attachment gefunden. Der Stream wird nun hinzugef\u00fcgt.");
                }
                att = atts[i];
                att.setBase64Encoding(b64);
                att.setBoundary(incomingMsg.boundary);
                MessagePartsFactory.attachmentSetState(att, 1, false);
                break;
            }
            String digestMethod = null;
            if (msg.isSigned()) {
                digestMethod = msg.signatureHeader.getDigestMethods().get("cid:" + refId);
            }
            if (att == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Verschl\u00fcsseltes Attachment gefunden.");
                }
                att = b64 ? MessagePartsFactory.attachment(new Base64InputStream(mimeStream), refId, mimeStream.getLength(), digestMethod) : MessagePartsFactory.attachment(mimeStream, refId, mimeStream.getLength(), digestMethod);
                att.setBase64Encoding(b64);
                att.setBoundary(incomingMsg.boundary);
                msg.addAttachment(att);
                MessagePartsFactory.attachmentSetState(att, 2, true);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unverschl\u00fcsseltes Attachment gefunden.");
                }
                if (b64) {
                    MessagePartsFactory.attachmentSetStream(att, new Base64InputStream(mimeStream), false, mimeStream.getLength(), digestMethod);
                } else {
                    MessagePartsFactory.attachmentSetStream(att, mimeStream, false, mimeStream.getLength(), digestMethod);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Es wurde ein Attachment hinzugef\u00fcgt!RefID: " + att.getRefID()));
            }
            att.setContentType(mimeStream.getContentType());
            att.setMimeHeaders(mimeStream.mime_headers);
            if (!msg.isSigned()) continue;
            msg.hashableMsgPart.put("cid:" + att.getRefID(), att.getEncryptedDigestValue(digestMethod));
        }
    }
}

