/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.OSCIResponseTo;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class FeedbackBuilder
extends MessagePartParser {
    private static Log log = LogFactory.getLog(FeedbackBuilder.class);
    private Vector<String[]> feedbacks = new Vector();
    private String[] entry;
    private boolean isInsideFeedback = false;

    public FeedbackBuilder(OSCIMessageBuilder parent) {
        super(parent);
    }

    public FeedbackBuilder(OSCIMessageBuilder parent, boolean isInsideFeedback) {
        super(parent);
        this.isInsideFeedback = isInsideFeedback;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start Element in Feedback: " + localName));
        }
        if ("Entry".endsWith(localName) && uri.equals(OSCI_XMLNS)) {
            this.entry = new String[3];
            this.entry[0] = attributes.getValue("xml:lang");
        } else if ("Code".equals(localName) && uri.equals(OSCI_XMLNS)) {
            this.currentElement = new StringBuffer();
        } else if ("Text".equals(localName) && uri.equals(OSCI_XMLNS)) {
            this.currentElement = new StringBuffer();
        } else {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End Element in Feedback: " + localName));
        }
        if (this.isInsideFeedback && ParserHelper.isElement(Constants.CommonTags.InsideFeedback, localName, uri)) {
            this.parentHandler.endElement(uri, localName, qName);
            this.xmlReader.setContentHandler(this.parentHandler);
        } else if (ParserHelper.isElement(Constants.CommonTags.Feedback, localName, uri)) {
            ((OSCIResponseTo)this.msg).feedBack = this.feedbacks;
            this.xmlReader.setContentHandler(this.parentHandler);
        } else if (localName.equals("Entry") && uri.equals(OSCI_XMLNS)) {
            this.feedbacks.add(this.entry);
        } else if (localName.equals("Code") && uri.equals(OSCI_XMLNS)) {
            this.entry[1] = this.currentElement.toString();
        } else if (localName.equals("Text") && uri.equals(OSCI_XMLNS)) {
            this.entry[2] = this.currentElement.toString();
        } else {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
        this.currentElement = null;
    }

    public Vector<String[]> getFeedback() {
        return this.feedbacks;
    }
}

