/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.messagetypes.ResponseToExitDialog;
import de.osci.osci12.roles.Originator;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class ExitDialog
extends OSCIRequest {
    public ExitDialog(DialogHandler dh) throws NoSuchAlgorithmException {
        super(dh);
        this.messageType = 2;
        this.originator = (Originator)dh.getClient();
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.dialogHandler.getControlblock().setSequenceNumber(this.dialogHandler.getControlblock().getSequenceNumber() + 1);
    }

    ExitDialog() {
        this.messageType = 2;
    }

    public ResponseToExitDialog send() throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToExitDialog)this.transmit(null, null);
    }

    @Override
    protected void compose() throws OSCIException, NoSuchAlgorithmException, IOException {
        super.compose();
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        if (this.dialogHandler.getControlblock().getChallenge() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Challenge");
        }
        if (this.dialogHandler.getControlblock().getResponse() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Response");
        }
        if (this.dialogHandler.getControlblock().getConversationID() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Conversation-Id");
        }
        if (this.dialogHandler.getControlblock().getSequenceNumber() == -1) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SequenceNumber");
        }
        this.body = new Body("<" + this.osciNSPrefix + ":exitDialog></" + this.osciNSPrefix + ":exitDialog>");
        this.body.setNSPrefixes(this);
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

