/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Base64;
import de.osci.osci12.common.Constants;
import de.osci.osci12.messageparts.MessagePart;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class Timestamp
extends MessagePart
implements Serializable {
    private static final long serialVersionUID = 3258130267062415434L;
    static final String[] TIMESTAMP_NAMES = new String[]{"Creation", "Forwarding", "Reception", "Timestamp"};
    public static final int PROCESS_CARD_CREATION = 0;
    public static final int PROCESS_CARD_FORWARDING = 1;
    public static final int PROCESS_CARD_RECEPTION = 2;
    public static final int PROCESS_CARD_TIMESTAMP = 3;
    private String algorithm;
    private int nameID;
    private String timeStamp;

    Timestamp() {
    }

    public Timestamp(int nameID, String algorithm, String timeStamp) {
        this.nameID = nameID;
        this.algorithm = algorithm;
        this.timeStamp = timeStamp;
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException {
        out.write(("<" + this.osciNSPrefix + ":" + TIMESTAMP_NAMES[this.nameID] + ">").getBytes(Constants.CHARSET_ENCODING));
        if (this.algorithm == null || this.algorithm.length() == 0) {
            out.write(("<" + this.osciNSPrefix + ":Plain>" + this.timeStamp + "</" + this.osciNSPrefix + ":Plain>").getBytes(Constants.CHARSET_ENCODING));
        } else {
            out.write(("<" + this.osciNSPrefix + ":Cryptographic Algorithm=\"" + this.algorithm + "\">" + Base64.encode(this.timeStamp.getBytes(Constants.CHARSET_ENCODING)) + "</" + this.osciNSPrefix + ":Cryptographic>").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("</" + this.osciNSPrefix + ":" + TIMESTAMP_NAMES[this.nameID] + ">").getBytes(Constants.CHARSET_ENCODING));
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getName() {
        return TIMESTAMP_NAMES[this.nameID];
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getNameID() {
        return this.nameID;
    }

    void setNameID(int nameID) {
        this.nameID = nameID;
    }
}

