/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Base64;
import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Inspection;
import de.osci.osci12.messageparts.InspectionBuilder;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.TimestampBuilder;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ProcessCardBundleBuilder
extends MessagePartParser {
    private static Log log = LogFactory.getLog(ProcessCardBundleBuilder.class);
    ProcessCardBundle processCard = null;
    TimestampBuilder timeBuilder = null;
    private InspectionBuilder inspectionBuilder = null;
    private int[] check;
    private Vector<Inspection> inspections = new Vector();

    public ProcessCardBundleBuilder(Constants.CommonTags name, XMLReader xmlReader, DefaultHandler parentHandler, int[] check) {
        super(xmlReader, parentHandler);
        this.processCard = new ProcessCardBundle(name.getElementName());
        this.check = check;
        OSCIMessage msg = ((OSCIMessageBuilder)parentHandler).getOSCIMessage();
        this.processCard.setNSPrefixes(msg);
    }

    ProcessCardBundleBuilder(XMLReader xmlReader, ProcessCardBundle proBundle, int[] check) {
        super(xmlReader, null);
        this.processCard = proBundle;
        this.check = check;
    }

    public ProcessCardBundleBuilder(String name, XMLReader xmlReader, DefaultHandler parentHandler, int[] check) {
        super(xmlReader, parentHandler);
        this.processCard = new ProcessCardBundle(name);
        this.check = check;
        OSCIMessage msg = ((OSCIMessageBuilder)parentHandler).getOSCIMessage();
        this.processCard.setNSPrefixes(msg);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start Element: " + localName));
        }
        if (ParserHelper.isElement(Constants.CommonTags.MessageId, localName, uri)) {
            this.currentElement = new StringBuffer();
        } else if (!ParserHelper.isElement(Constants.CommonTags.ProcessCardBundle, localName, uri)) {
            if (localName.equals("ProcessCard") && uri.equals(OSCI_XMLNS)) {
                this.processCard.setRecentModification(attributes.getValue("RecentModification"));
            } else if (localName.equals("Creation") && uri.equals(OSCI_XMLNS) || localName.equals("Forwarding") && uri.equals(OSCI_XMLNS) || localName.equals("Reception") && uri.equals(OSCI_XMLNS)) {
                this.timeBuilder = new TimestampBuilder(this.xmlReader, this);
                this.xmlReader.setContentHandler(this.timeBuilder);
            } else if (localName.equals("Subject") && uri.equals(OSCI_XMLNS)) {
                this.currentElement = new StringBuffer();
            } else if (!localName.equals("InspectionReport") || !uri.equals(OSCI_XMLNS)) {
                if (localName.equals("Inspection") && uri.equals(OSCI_XMLNS)) {
                    this.inspectionBuilder = new InspectionBuilder(this.xmlReader, this);
                    this.xmlReader.setContentHandler(this.inspectionBuilder);
                } else {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + " " + localName);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("End-Element: " + localName));
            }
            if (localName.equals(this.processCard.name) && uri.equals(OSCI_XMLNS)) {
                if (this.processCard.getMessageId() == null) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": " + localName);
                }
                if (this.inspections.toArray().length > 0) {
                    this.processCard.setInspections(this.inspections.toArray(new Inspection[0]));
                }
                if (this.parentHandler != null) {
                    this.xmlReader.setContentHandler(this.parentHandler);
                }
            } else if (ParserHelper.isElement(Constants.CommonTags.MessageId, localName, uri)) {
                this.processCard.setMessageId(new String(Base64.decode(this.currentElement.toString()), Constants.CHARSET_ENCODING));
            } else if (localName.equals("Creation") && uri.equals(OSCI_XMLNS)) {
                if (this.check[0] == 0) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                this.processCard.setCreation(this.timeBuilder.getTimestampObject());
                this.check[0] = this.check[0] - 1;
            } else if (localName.equals("Forwarding") && uri.equals(OSCI_XMLNS)) {
                if (this.check[1] == 0) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                this.processCard.setForwarding(this.timeBuilder.getTimestampObject());
                this.check[1] = this.check[1] - 1;
            } else if (localName.equals("Reception") && uri.equals(OSCI_XMLNS)) {
                if (this.check[2] == 0) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                this.processCard.setReception(this.timeBuilder.getTimestampObject());
                this.check[2] = this.check[2] - 1;
            } else if (localName.equals("Subject") && uri.equals(OSCI_XMLNS)) {
                if (this.check[3] == 0) throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                this.processCard.setSubject(this.currentElement.toString());
                this.check[3] = this.check[3] - 1;
            } else if (!localName.equals("InspectionReport") || !uri.equals(OSCI_XMLNS)) {
                if (localName.equals("Inspection") && uri.equals(OSCI_XMLNS)) {
                    this.inspections.add(this.inspectionBuilder.getInspectionObject());
                } else if (!localName.equals("ProcessCard") || !uri.equals(OSCI_XMLNS)) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                }
            }
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception ex) {
            log.error((Object)("Fehler Start-Element: " + localName), (Throwable)ex);
            throw new SAXException(ex);
        }
        this.currentElement = null;
    }

    public ProcessCardBundle getProcessCardBundleObject() {
        return this.processCard;
    }
}

