/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Base64;
import de.osci.osci12.common.Constants;
import de.osci.osci12.messageparts.Inspection;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messageparts.Timestamp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessCardBundle
extends MessagePart {
    private static Log log = LogFactory.getLog(ProcessCardBundle.class);
    public String name;
    private String recentModification;
    private String subject;
    private String messageId;
    Timestamp creation;
    Timestamp forwarding;
    Timestamp reception;
    private Inspection[] inspections;

    ProcessCardBundle(String name) {
        this.name = name;
    }

    ProcessCardBundle(String name, String messageId, String recentModification, Timestamp creation, Timestamp forwarding, Timestamp reception, String subject, Inspection[] inspections) {
        this.name = name;
        this.messageId = messageId;
        this.recentModification = recentModification;
        this.creation = creation;
        this.forwarding = forwarding;
        this.reception = reception;
        this.subject = subject;
        this.inspections = inspections;
    }

    public Timestamp getCreation() {
        return this.creation;
    }

    public Timestamp getForwarding() {
        return this.forwarding;
    }

    public Timestamp getReception() {
        return this.reception;
    }

    public Inspection[] getInspections() {
        return this.inspections;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getRecentModification() {
        return this.recentModification;
    }

    public String getSubject() {
        return this.subject;
    }

    public String writeToString() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeXML(out);
        out.close();
        return out.toString(Constants.CHAR_ENCODING);
    }

    void setCreation(Timestamp creation) {
        this.creation = creation;
    }

    void setForwarding(Timestamp forwarding) {
        this.forwarding = forwarding;
    }

    void setInspections(Inspection[] inspections) {
        this.inspections = inspections;
    }

    void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    void setName(String name) {
        this.name = name;
    }

    void setReception(Timestamp reception) {
        this.reception = reception;
    }

    void setSubject(String subject) {
        this.subject = subject;
    }

    void setRecentModification(String recentModification) {
        this.recentModification = recentModification;
    }

    static String encode(String text) {
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        return text.replaceAll("\r", "&#xD;");
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException {
        this.writeXML(out, false);
    }

    protected void writeXML(OutputStream out, boolean writeObj) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Name: " + this.name));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("MessageID: " + this.messageId));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("recentModi: " + this.recentModification));
        }
        out.write(("<" + this.osciNSPrefix + ":" + this.name).getBytes(Constants.CHARSET_ENCODING));
        if (writeObj) {
            out.write((" xmlns:" + this.osciNSPrefix + "=\"http://www.osci.de/2002/04/osci\"").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("><" + this.osciNSPrefix + ":MessageId>" + Base64.encode(this.messageId.getBytes(Constants.CHARSET_ENCODING)) + "</" + this.osciNSPrefix + ":MessageId><" + this.osciNSPrefix + ":ProcessCard RecentModification=\"" + this.recentModification + "\">").getBytes(Constants.CHARSET_ENCODING));
        if (this.creation != null) {
            this.creation.writeXML(out);
        }
        if (this.forwarding != null) {
            this.forwarding.writeXML(out);
        }
        if (this.reception != null) {
            this.reception.writeXML(out);
        }
        if (this.subject != null) {
            out.write(("<" + this.osciNSPrefix + ":Subject>" + this.subject + "</" + this.osciNSPrefix + ":Subject>").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("</" + this.osciNSPrefix + ":ProcessCard><" + this.osciNSPrefix + ":InspectionReport>").getBytes(Constants.CHARSET_ENCODING));
        if (this.inspections != null) {
            for (int i = 0; i < this.inspections.length; ++i) {
                this.inspections[i].writeXML(out);
            }
        }
        out.write(("</" + this.osciNSPrefix + ":InspectionReport></" + this.osciNSPrefix + ":" + this.name + ">").getBytes(Constants.CHARSET_ENCODING));
    }
}

