/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Base64;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCICancelledException;
import de.osci.osci12.common.OSCIErrorException;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messageparts.OSCISignatureReference;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Role;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OSCISignature
extends MessagePart {
    private static Log log = LogFactory.getLog(OSCISignature.class);
    private Map<String, OSCISignatureReference> refs = new HashMap<String, OSCISignatureReference>();
    public byte[] signatureValue;
    public byte[] signedInfo;
    String enclosingElement;
    public String signerId;
    String signingTime;
    String signingPropsId;
    String signingProperties;
    public String signatureAlgorithm = DialogHandler.getSignatureAlgorithm();
    Role signer = null;
    Hashtable<String, String> refsDigestMethods;
    Hashtable<String, byte[]> refsHash;

    OSCISignature() {
    }

    OSCISignature(String enclosingElement) {
        this.enclosingElement = enclosingElement;
    }

    void addSignatureTime(String time, String id, String digAlgo) throws IOException, NoSuchAlgorithmException, OSCIErrorException {
        if (this.signingPropsId != null && this.refs.containsKey(id)) {
            this.refs.remove(id + this.signingPropsId);
        }
        this.signingPropsId = id;
        this.signingTime = time;
        String nsHead = "xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:osci=\"http://www.osci.de/2002/04/osci\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        this.signingProperties = "<xades:SignedProperties " + nsHead + " Id=\"" + this.signingPropsId + "\"><xades:SignedSignatureProperties><xades:SigningTime>" + this.signingTime + "</xades:SigningTime></xades:SignedSignatureProperties></xades:SignedProperties>";
        OSCISignatureReference osr = new OSCISignatureReference();
        MessageDigest mdg = DialogHandler.getSecurityProvider() == null ? MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(digAlgo)) : MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(digAlgo), DialogHandler.getSecurityProvider());
        osr.digestValue = mdg.digest(this.signingProperties.getBytes(Constants.CHARSET_ENCODING));
        osr.digestMethodAlgorithm = digAlgo;
        osr.setNSPrefixes(this.soapNSPrefix, this.osciNSPrefix, this.dsNSPrefix, this.xencNSPrefix, this.xsiNSPrefix);
        osr.id = "#" + id;
        this.addSignatureReference(osr);
    }

    public Map<String, OSCISignatureReference> getReferences() {
        return this.refs;
    }

    public void setReferences(Map<String, OSCISignatureReference> refList) {
        this.refs = refList;
    }

    public void addSignatureReference(OSCISignatureReference sigReference) throws OSCIErrorException {
        if (this.refs.containsKey(sigReference.getRefID())) {
            log.error((Object)("Duplicated refId of signed parts!: " + sigReference.getRefID()));
            throw new OSCIErrorException(OSCIExceptionCodes.OSCIErrorCodes.NotAllRelevantPartsSigned);
        }
        log.debug((Object)("Add reference with id:" + sigReference.getRefID()));
        this.refs.put(sigReference.getRefID(), sigReference);
    }

    public Role getSigner() {
        return this.signer;
    }

    public String getSigningTime() {
        return this.signingTime;
    }

    public Hashtable<String, byte[]> getDigests() {
        if (this.refsHash == null) {
            this.refsHash = new Hashtable();
            for (Map.Entry<String, OSCISignatureReference> sigRefs : this.refs.entrySet()) {
                this.refsHash.put(sigRefs.getKey(), sigRefs.getValue().getDigestValue());
            }
        }
        return this.refsHash;
    }

    public Hashtable<String, String> getDigestMethods() {
        if (this.refsDigestMethods == null) {
            this.refsDigestMethods = new Hashtable();
            for (Map.Entry<String, OSCISignatureReference> sigRefs : this.refs.entrySet()) {
                this.refsDigestMethods.put(sigRefs.getKey(), sigRefs.getValue().digestMethodAlgorithm);
            }
        }
        return this.refsDigestMethods;
    }

    public void sign(Role signer) throws OSCIRoleException, SignatureException, OSCICancelledException, IOException {
        this.signer = signer;
        this.signatureAlgorithm = signer.getSignatureAlgorithm();
        if (this.signedInfo == null) {
            this.createSignedInfo();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Algo: " + this.signatureAlgorithm));
        }
        this.signatureValue = signer.getSigner().sign(this.signedInfo, this.signatureAlgorithm);
        this.signerId = "#" + signer.getSignatureCertificateId();
    }

    public byte[] getSignedInfoBytes() {
        return this.signedInfo;
    }

    private void createSignedInfo() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(("<" + this.dsNSPrefix + ":SignedInfo xmlns:" + this.dsNSPrefix + "=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:" + this.osciNSPrefix + "=\"http://www.osci.de/2002/04/osci\" xmlns:" + this.soapNSPrefix + "=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:" + this.xencNSPrefix + "=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:" + this.xsiNSPrefix + "=\"http://www.w3.org/2001/XMLSchema-instance\">\n").getBytes(Constants.CHARSET_ENCODING));
        out.write(("<" + this.dsNSPrefix + ":CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></" + this.dsNSPrefix + ":CanonicalizationMethod>\n<" + this.dsNSPrefix + ":SignatureMethod Algorithm=\"" + this.signatureAlgorithm + "\"></" + this.dsNSPrefix + ":SignatureMethod>\n").getBytes(Constants.CHARSET_ENCODING));
        for (Map.Entry<String, OSCISignatureReference> sigRefs : this.refs.entrySet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("################ Referenz: " + sigRefs.getKey()));
            }
            sigRefs.getValue().writeXML(out);
        }
        out.write(("</" + this.dsNSPrefix + ":SignedInfo>").getBytes(Constants.CHARSET_ENCODING));
        this.signedInfo = out.toByteArray();
    }

    @Override
    public void writeXML(OutputStream out) throws IOException {
        int stop;
        if (this.enclosingElement != null) {
            out.write(this.enclosingElement.getBytes(Constants.CHARSET_ENCODING));
        }
        Object prf = this.dsNSPrefix + ":";
        int start = 0;
        for (start = 0; start < this.signedInfo.length && this.signedInfo[start] != 60; ++start) {
        }
        byte[] prfBytes = ((String)prf).getBytes(Constants.CHARSET_ENCODING);
        int j = 0;
        int i = start + 1;
        while (i < ((String)prf).length()) {
            if (prfBytes[j] != this.signedInfo[i]) {
                prf = "";
                break;
            }
            ++i;
            ++j;
        }
        if (((String)prf).length() == 0) {
            out.write(("<Signature xmlns=\"" + MessagePartParser.DS_XMLNS + "\">").getBytes(Constants.CHARSET_ENCODING));
        } else {
            out.write(("<" + (String)prf + "Signature>").getBytes(Constants.CHARSET_ENCODING));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("+######################## signed info" + new String(this.signedInfo, Constants.CHARSET_ENCODING)));
        }
        for (start = 0; start < this.signedInfo.length && this.signedInfo[start] != 32; ++start) {
        }
        for (stop = start; stop < this.signedInfo.length && this.signedInfo[stop] != 62; ++stop) {
        }
        out.write(this.signedInfo, 0, start);
        out.write(this.signedInfo, stop, this.signedInfo.length - stop);
        out.write(("<" + (String)prf + "SignatureValue>").getBytes(Constants.CHARSET_ENCODING));
        out.write(Base64.encode(this.signatureValue).getBytes(Constants.CHARSET_ENCODING));
        out.write(("</" + (String)prf + "SignatureValue><" + (String)prf + "KeyInfo><" + (String)prf + "RetrievalMethod URI=\"").getBytes(Constants.CHARSET_ENCODING));
        out.write(this.signerId.getBytes(Constants.CHARSET_ENCODING));
        out.write(("\"></" + (String)prf + "RetrievalMethod></" + (String)prf + "KeyInfo>").getBytes(Constants.CHARSET_ENCODING));
        if (this.signingProperties != null) {
            out.write(("<" + this.dsNSPrefix + ":Object><xades:QualifyingProperties xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\">").getBytes(Constants.CHARSET_ENCODING));
            int nsStart = this.signingProperties.indexOf("<xades:SignedProperties");
            nsStart = this.signingProperties.indexOf(32, nsStart);
            out.write(this.signingProperties.substring(0, nsStart).getBytes(Constants.CHARSET_ENCODING));
            out.write(this.signingProperties.substring(this.signingProperties.indexOf(" Id=", nsStart)).getBytes(Constants.CHARSET_ENCODING));
            out.write(("</xades:QualifyingProperties></" + this.dsNSPrefix + ":Object>").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("</" + (String)prf + "Signature>").getBytes(Constants.CHARSET_ENCODING));
        if (this.enclosingElement != null) {
            out.write(("</" + this.enclosingElement.substring(1, this.enclosingElement.indexOf(32)) + ">").getBytes(Constants.CHARSET_ENCODING));
        }
    }
}

