/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.osci12.OSCIException;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.ChunkInformation;
import de.osci.osci12.messageparts.ContentPackageBuilder;
import de.osci.osci12.messageparts.FeedbackObject;
import de.osci.osci12.messageparts.Inspection;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messageparts.OSCISignature;
import de.osci.osci12.messageparts.OSCISignatureBuilder;
import de.osci.osci12.messageparts.OSCISignatureReference;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.Timestamp;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MessagePartsFactory {
    public static ContentPackageBuilder createContentPackageBuilder(OSCIMessageBuilder omb) {
        return new ContentPackageBuilder(omb);
    }

    public static ChunkInformation creatChunkInformation(ChunkInformation.CheckInstance chunkInstance) {
        return new ChunkInformation(chunkInstance);
    }

    public static OSCISignatureBuilder createOsciSignatureBuilder(XMLReader xmlReader, DefaultHandler parentHandler, Attributes atts) throws SAXException {
        return new OSCISignatureBuilder(xmlReader, parentHandler, atts, false);
    }

    public static ProcessCardBundle createProcessCardBundle(String name, String messageId, String recentModification, Timestamp creation, Timestamp forwarding, Timestamp reception, String subject, Inspection[] inspections) {
        return new ProcessCardBundle(name, messageId, recentModification, creation, forwarding, reception, subject, inspections);
    }

    public static OSCISignature createOSCISignature(String enclosingElement) {
        return new OSCISignature(enclosingElement);
    }

    public static OSCISignatureReference createOSCISignatureReference(MessagePart mp, String digestAlgorithm) throws IOException, NoSuchAlgorithmException, OSCIException {
        return new OSCISignatureReference(mp, digestAlgorithm);
    }

    public static FeedbackObject createFeedbackObject(String[] feedback) {
        return new FeedbackObject(feedback);
    }

    public static Attachment attachment(InputStream ins, String refId, long length, String transportDigestAlgorithm) throws IOException, NoSuchAlgorithmException {
        return new Attachment(ins, refId, length, transportDigestAlgorithm);
    }

    public static void attachmentSetStream(Attachment attachment, InputStream ins, boolean encrypt, long length, String transportDigestAlgorithm) throws IOException, NoSuchAlgorithmException {
        attachment.setInputStream(ins, encrypt, length, transportDigestAlgorithm);
    }

    public static void attachmentSetState(Attachment att, int newState, boolean encrypted) {
        att.stateOfAttachment = newState;
        att.encrypt = encrypted;
    }

    public static boolean attachmentIsBase64(Attachment att) {
        return att.base64;
    }

    public static void setDigestValue(MessagePart c, byte[] digest, String digestAlgorithm) {
        c.digestValues.put(digestAlgorithm, digest);
    }

    public static byte[] getDigestValue(MessagePart c, String digestAlgorithm) throws NoSuchAlgorithmException, IOException, OSCIException {
        return c.getDigestValue(digestAlgorithm);
    }

    public static void writeXML(MessagePart mp, OutputStream out) throws IOException, OSCIException {
        mp.writeXML(out);
    }
}

