/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.NullOutputStream;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.messagetypes.OSCIMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MessagePart {
    private static Log log = LogFactory.getLog(MessagePart.class);
    protected Hashtable<String, String> xmlns = new Hashtable();
    protected String id = "";
    protected String typ;
    protected Hashtable<String, byte[]> digestValues = new Hashtable();
    protected long length = -1L;
    protected Vector<String> transformers = new Vector();
    protected static final String b64 = "<ds:Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#base64\"></ds:Transform>";
    protected static final String can = "<ds:Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></ds:Transform>";
    public byte[] ns;
    public byte[] ns2017;
    protected MessageDigest md;
    protected String soapNSPrefix = Constants.Namespaces.SOAP.getPrefix();
    protected String osciNSPrefix = Constants.Namespaces.OSCI.getPrefix();
    protected String osci2017NSPrefix = Constants.Namespaces.OSCI2017.getPrefix();
    protected String osci2019NSPrefix = Constants.Namespaces.OSCI128.getPrefix();
    protected String dsNSPrefix = Constants.Namespaces.XML_SIG.getPrefix();
    protected String xencNSPrefix = Constants.Namespaces.XML_ENC.getPrefix();
    protected String xsiNSPrefix = Constants.Namespaces.XML_SCHEMA.getPrefix();

    protected MessagePart() {
        this.typ = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1).toLowerCase();
        this.ns = " xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:osci=\"http://www.osci.de/2002/04/osci\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"".getBytes(Constants.CHARSET_ENCODING);
        this.ns2017 = (" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:osci=\"http://www.osci.de/2002/04/osci\" xmlns:osci2017=\"" + Constants.Namespaces.OSCI2017.getUri() + "\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").getBytes(Constants.CHARSET_ENCODING);
    }

    public void setNSPrefixes(OSCIMessage msg) {
        this.soapNSPrefix = msg.soapNSPrefix;
        this.osciNSPrefix = msg.osciNSPrefix;
        this.osci2017NSPrefix = msg.osci2017NSPrefix;
        this.osci2019NSPrefix = msg.osci2019NSPrefix;
        this.dsNSPrefix = msg.dsNSPrefix;
        this.xencNSPrefix = msg.xencNSPrefix;
        this.xsiNSPrefix = msg.xsiNSPrefix;
        this.ns = msg.ns.getBytes(Constants.CHARSET_ENCODING);
    }

    public void setNSPrefixes(String soap, String osci, String ds, String xenc, String xsi) {
        this.soapNSPrefix = soap;
        this.osciNSPrefix = osci;
        this.dsNSPrefix = ds;
        this.xencNSPrefix = xenc;
        this.xsiNSPrefix = xsi;
    }

    public void setRefID(String id) {
        this.id = id;
    }

    public String getRefID() {
        return this.id;
    }

    protected byte[] getDigestValue(String digestAlgorithm) throws NoSuchAlgorithmException, IOException, OSCIException {
        if (this.digestValues.get(digestAlgorithm) != null) {
            return this.digestValues.get(digestAlgorithm);
        }
        this.md = DialogHandler.getSecurityProvider() == null ? MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(digestAlgorithm)) : MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(digestAlgorithm), DialogHandler.getSecurityProvider());
        NullOutputStream nos = new NullOutputStream();
        DigestOutputStream digestOut = new DigestOutputStream(nos, this.md);
        this.writeXML(digestOut);
        digestOut.close();
        this.digestValues.put(digestAlgorithm, this.md.digest());
        if (log.isDebugEnabled()) {
            log.debug((Object)("enter getDigestValue" + Crypto.toHex(this.digestValues.get(digestAlgorithm))));
        }
        this.length = nos.getLength();
        return this.digestValues.get(digestAlgorithm);
    }

    public long getLength() throws IOException, OSCIException {
        if (this.length > -1L) {
            return this.length;
        }
        NullOutputStream out = new NullOutputStream();
        this.writeXML(out);
        out.close();
        this.length = out.getLength();
        return this.length;
    }

    protected abstract void writeXML(OutputStream var1) throws IOException, OSCIException;
}

