/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Inspection;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.ProcessCardBundleBuilder;
import de.osci.osci12.messageparts.TimestampBuilder;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class InspectionBuilder
extends MessagePartParser {
    private static Log log = LogFactory.getLog(InspectionBuilder.class);
    Inspection inspection = null;
    private TimestampBuilder timestampBuilder = null;
    private boolean isInsideOnlineResult = false;
    private Vector<String> onlineChecks = new Vector();
    private Vector<String> onlineCheckNames = new Vector();

    public InspectionBuilder(XMLReader xmlReader, DefaultHandler parentHandler) {
        super(xmlReader, parentHandler);
        this.inspection = new Inspection();
        ProcessCardBundle pcb = ((ProcessCardBundleBuilder)parentHandler).processCard;
        this.inspection.setNSPrefixes(pcb.soapNSPrefix, pcb.osciNSPrefix, pcb.dsNSPrefix, pcb.xencNSPrefix, pcb.xsiNSPrefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start-Element: " + localName));
        }
        if (localName.equals("Timestamp") && uri.equals(OSCI_XMLNS)) {
            this.timestampBuilder = new TimestampBuilder(this.xmlReader, this);
            this.xmlReader.setContentHandler(this.timestampBuilder);
        } else if (localName.equals("X509IssuerName") && uri.equals(OSCI_XMLNS)) {
            this.currentElement = new StringBuffer();
        } else if (localName.equals("X509SerialNumber") && uri.equals(OSCI_XMLNS)) {
            this.currentElement = new StringBuffer();
        } else if (localName.equals("X509SubjectName") && uri.equals(OSCI_XMLNS)) {
            this.currentElement = new StringBuffer();
        } else if (localName.equals("CertType") && uri.equals(OSCI_XMLNS)) {
            this.inspection.setCertType(attributes.getValue("Type"));
        } else if (localName.equals("MathResult") && uri.equals(OSCI_XMLNS)) {
            this.inspection.setMathResult(attributes.getValue("Result"));
        } else if (localName.equals("OfflineResult") && uri.equals(OSCI_XMLNS)) {
            this.inspection.setOfflineResult(attributes.getValue("Result"));
        } else if (localName.equals("OnlineResult") && uri.equals(OSCI_XMLNS)) {
            this.isInsideOnlineResult = true;
            this.inspection.setOnlineResult(attributes.getValue("Result").equals("ok"));
        } else if (this.isInsideOnlineResult) {
            if (localName.equals("OCSP") && uri.equals(OSCI_XMLNS)) {
                this.currentElement = new StringBuffer();
                this.onlineCheckNames.add("OCSP");
            } else if (localName.equals("CRL") && uri.equals(OSCI_XMLNS)) {
                this.currentElement = new StringBuffer();
                this.onlineCheckNames.add("CRL");
            } else if (localName.equals("LDAP") && uri.equals(OSCI_XMLNS)) {
                this.currentElement = new StringBuffer();
                this.onlineCheckNames.add("LDAP");
            }
        } else {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
    }

    public Inspection getInspectionObject() {
        return this.inspection;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End-Element: " + localName));
        }
        if (localName.equals("Inspection") && uri.equals(OSCI_XMLNS)) {
            if (this.inspection.getMathResult() == null || this.inspection.getOfflineResult() == null) {
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ".");
            }
            this.inspection.setOnlineCheckNames(this.onlineCheckNames.toArray(new String[0]));
            this.inspection.setOnlineChecks(this.onlineChecks.toArray(new String[0]));
            this.parentHandler.endElement(uri, localName, qName);
            this.xmlReader.setContentHandler(this.parentHandler);
        } else if (localName.equals("Timestamp") && uri.equals(OSCI_XMLNS)) {
            this.inspection.setTimeStamp(this.timestampBuilder.getTimestampObject());
        } else if (localName.equals("X509IssuerName") && uri.equals(OSCI_XMLNS)) {
            this.inspection.setX509IssuerName(this.currentElement.toString());
        } else if (localName.equals("X509SerialNumber") && uri.equals(OSCI_XMLNS)) {
            this.inspection.setX509SerialNumber(this.currentElement.toString());
        } else if (localName.equals("X509SubjectName") && uri.equals(OSCI_XMLNS)) {
            this.inspection.setX509SubjectNameNumber(this.currentElement.toString());
        } else if (!(localName.equals("CertType") && uri.equals(OSCI_XMLNS) || localName.equals("MathResult") && uri.equals(OSCI_XMLNS) || localName.equals("OfflineResult") && uri.equals(OSCI_XMLNS))) {
            if (localName.equals("OnlineResult") && uri.equals(OSCI_XMLNS)) {
                this.isInsideOnlineResult = false;
            } else if (this.isInsideOnlineResult && (localName.equals("OCSP") && uri.equals(OSCI_XMLNS) || localName.equals("CRL") && uri.equals(OSCI_XMLNS) || localName.equals("LDAP") && uri.equals(OSCI_XMLNS))) {
                this.onlineChecks.add(this.currentElement.toString());
            } else {
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
        }
        this.currentElement = null;
    }
}

