/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.osci12.common.Constants;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.Timestamp;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;

public class Inspection
extends MessagePart
implements Serializable {
    private static final long serialVersionUID = 3258130267062415451L;
    public static final String CERT_TYPE_ADVANCED = "advanced";
    public static final String CERT_TYPE_QUALIFIED = "qualified";
    public static final String CERT_TYPE_ACCREDITED = "accredited";
    public static final String CERT_TYPE_UNKNOWN = "unknown";
    private Timestamp timeStamp;
    private String mathResult;
    private String offlineResult;
    private boolean onlineResult;
    protected boolean isOnlineChecked = false;
    private String certType;
    private String[] onlineCheckName;
    private String[] onlineCheck;
    private String x509IssuerName = null;
    private String x509SerialNumber = null;
    private String x509SubjectName = null;

    Inspection() {
    }

    Inspection(X509Certificate cert, String certType, Timestamp timeStamp, String mathResult, String offlineResult) {
        this.x509IssuerName = cert.getIssuerX500Principal().getName("RFC2253");
        this.x509SerialNumber = cert.getSerialNumber().toString();
        this.x509SubjectName = cert.getSubjectX500Principal().getName("RFC2253");
        this.timeStamp = timeStamp;
        this.mathResult = mathResult;
        this.offlineResult = offlineResult;
        this.isOnlineChecked = false;
        this.certType = certType;
    }

    Inspection(X509Certificate cert, String certType, Timestamp timeStamp, String mathResult, String offlineResult, boolean onlineResult, String[] onlineCheckName, String[] onlineCheck) {
        this.x509IssuerName = cert.getIssuerX500Principal().getName("RFC2253");
        this.x509SerialNumber = cert.getSerialNumber().toString();
        this.x509SubjectName = cert.getSubjectX500Principal().getName("RFC2253");
        this.timeStamp = timeStamp;
        this.mathResult = mathResult;
        this.offlineResult = offlineResult;
        this.onlineResult = onlineResult;
        this.certType = certType;
        this.onlineCheckName = onlineCheckName;
        this.onlineCheck = onlineCheck;
        this.isOnlineChecked = true;
    }

    void setTimeStamp(Timestamp timeStamp) {
        this.timeStamp = timeStamp;
    }

    void setOnlineResult(boolean onlineResult) {
        this.isOnlineChecked = true;
        this.onlineResult = onlineResult;
    }

    void setOnlineCheckNames(String[] onlineCheckName) {
        this.onlineCheckName = onlineCheckName;
    }

    void setOfflineResult(String offlineResult) {
        if (!(offlineResult.equals("valid") || offlineResult.equals("invalid") || offlineResult.equals("indeterminate"))) {
            throw new IllegalArgumentException();
        }
        this.offlineResult = offlineResult.toLowerCase();
    }

    void setOnlineChecks(String[] onlineCheck) {
        if (onlineCheck.length > 0) {
            this.isOnlineChecked = true;
        }
        this.onlineCheck = onlineCheck;
    }

    void setMathResult(String mathResult) {
        if (!(mathResult.equals("ok") || mathResult.equals("corrupted") || mathResult.equals("indeterminate"))) {
            throw new IllegalArgumentException();
        }
        this.mathResult = mathResult.toLowerCase();
    }

    void setCertType(String certType) {
        if (!(certType.equals(CERT_TYPE_ACCREDITED) || certType.equals(CERT_TYPE_QUALIFIED) || certType.equals(CERT_TYPE_ADVANCED) || certType.equals(CERT_TYPE_UNKNOWN))) {
            throw new IllegalArgumentException();
        }
        this.certType = certType;
    }

    void setX509IssuerName(String x509IssuerName) {
        this.x509IssuerName = x509IssuerName;
    }

    void setX509SerialNumber(String x509SerialNumber) {
        this.x509SerialNumber = x509SerialNumber;
    }

    void setX509SubjectNameNumber(String x509SubjectName) {
        this.x509SubjectName = x509SubjectName;
    }

    public String getX509SerialNumber() {
        return this.x509SerialNumber;
    }

    public String getX509IssuerName() {
        return this.x509IssuerName;
    }

    public String getX509SubjectName() {
        return this.x509SubjectName;
    }

    public Timestamp getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isOnlineChecked() {
        return this.isOnlineChecked;
    }

    public String[] getOnlineCheckNames() {
        return this.onlineCheckName;
    }

    public boolean getOnlineResult() {
        return this.onlineResult;
    }

    public String[] getOnlineChecks() {
        return this.onlineCheck;
    }

    public String getMathResult() {
        return this.mathResult;
    }

    public String getOfflineResult() {
        return this.offlineResult;
    }

    public String getCertType() {
        return this.certType;
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException {
        out.write(("<" + this.osciNSPrefix + ":Inspection>").getBytes(Constants.CHARSET_ENCODING));
        this.timeStamp.writeXML(out);
        out.write(("<" + this.osciNSPrefix + ":X509SubjectName>" + ProcessCardBundle.encode(this.x509SubjectName) + "</" + this.osciNSPrefix + ":X509SubjectName><" + this.osciNSPrefix + ":X509IssuerName>" + ProcessCardBundle.encode(this.x509IssuerName) + "</" + this.osciNSPrefix + ":X509IssuerName><" + this.osciNSPrefix + ":X509SerialNumber>" + this.x509SerialNumber + "</" + this.osciNSPrefix + ":X509SerialNumber><" + this.osciNSPrefix + ":CertType Type=\"" + this.certType + "\"></" + this.osciNSPrefix + ":CertType><" + this.osciNSPrefix + ":MathResult Result=\"" + this.mathResult.toLowerCase() + "\"></" + this.osciNSPrefix + ":MathResult><" + this.osciNSPrefix + ":OfflineResult Result=\"" + this.offlineResult.toLowerCase() + "\"></" + this.osciNSPrefix + ":OfflineResult>").getBytes(Constants.CHARSET_ENCODING));
        if (this.isOnlineChecked) {
            String res = "revoked";
            if (this.onlineResult) {
                res = "ok";
            }
            out.write(("<" + this.osciNSPrefix + ":OnlineResult Result=\"" + res + "\">").getBytes(Constants.CHARSET_ENCODING));
            for (int i = 0; i < this.onlineCheckName.length; ++i) {
                out.write(("<" + this.osciNSPrefix + ":" + this.onlineCheckName[i] + ">" + this.onlineCheck[i] + "</" + this.osciNSPrefix + ":" + this.onlineCheckName[i] + ">").getBytes(Constants.CHARSET_ENCODING));
            }
            out.write(("</" + this.osciNSPrefix + ":OnlineResult>").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("</" + this.osciNSPrefix + ":Inspection>").getBytes(Constants.CHARSET_ENCODING));
    }
}

