/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Base64InputStream;
import de.osci.helper.Base64OutputStream;
import de.osci.helper.NullOutputStream;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.extinterfaces.OSCIDataSource;
import de.osci.osci12.extinterfaces.OSCIDataSourceExt123;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.MessagePart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Content
extends MessagePart {
    private static Log log = LogFactory.getLog(Content.class);
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private Attachment attachment = null;
    protected OSCIDataSource swapBuffer;
    private ContentContainer coco;
    private int contentType;
    private InputStream transformedDataStream;
    public static final int ATTACHMENT_REFERENCE = 0;
    public static final int CONTENT_CONTAINER = 1;
    public static final int DATA = 2;
    String coNS;

    public Content(InputStream ins) throws IOException {
        if (ins == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " ins");
        }
        this.setRefID("content" + NEXT_ID.getAndIncrement());
        this.contentType = 2;
        this.load(ins);
        this.transformers.add("<ds:Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#base64\"></ds:Transform>");
    }

    public Content(InputStream ins, String[] transformer, InputStream transformedData) throws IOException, OSCIException, NoSuchAlgorithmException {
        this(ins);
        if (transformer != null && transformer.length > 0) {
            this.transformedDataStream = transformedData;
            for (int i = 0; i < transformer.length; ++i) {
                this.transformers.add(transformer[i]);
            }
        }
    }

    Content(OSCIDataSource dataSource) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Konstruktor");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " dataSource");
        }
        this.setRefID("content" + NEXT_ID.getAndIncrement());
        this.swapBuffer = dataSource;
        this.contentType = 2;
    }

    public Content(String data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " data");
        }
        this.setRefID("content" + NEXT_ID.getAndIncrement());
        this.load(new ByteArrayInputStream(data.getBytes(Constants.CHARSET_ENCODING)));
        this.contentType = 2;
        this.transformers.add("<ds:Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#base64\"></ds:Transform>");
    }

    public Content(String data, String[] transformer, String transformedData) throws IOException, OSCIException, NoSuchAlgorithmException {
        this(data);
        if (transformer != null && transformer.length > 0) {
            this.transformedDataStream = new ByteArrayInputStream(transformedData.getBytes(Constants.CHARSET_ENCODING));
            this.transformers.addAll(Arrays.asList(transformer));
        }
    }

    public Content(Attachment attachment) {
        this.transformers.add("<ds:Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></ds:Transform>");
        if (attachment == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " attachment");
        }
        this.attachment = attachment;
        this.setRefID("content" + NEXT_ID.getAndIncrement());
        this.contentType = 0;
    }

    public Content(ContentContainer contentContainer) {
        this.transformers.add("<ds:Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></ds:Transform>");
        if (contentContainer == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " contentContainer");
        }
        this.coco = contentContainer;
        this.setRefID("content" + NEXT_ID.getAndIncrement());
        this.contentType = 1;
    }

    private void load(InputStream input) throws IOException {
        if (this.swapBuffer == null) {
            this.swapBuffer = DialogHandler.getNewDataBuffer();
            if (this.swapBuffer instanceof OSCIDataSourceExt123) {
                ((OSCIDataSourceExt123)this.swapBuffer).setConfidential(true);
            }
            Base64OutputStream b64out = new Base64OutputStream(this.swapBuffer.getOutputStream(), false);
            byte[] bytes = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
            int anz = 0;
            while ((anz = input.read(bytes)) > -1) {
                b64out.write(bytes, 0, anz);
            }
            b64out.close();
            input.close();
        }
    }

    public void setTransformedData(InputStream transformedData) {
        if (this.getTransformerForSignature() == null) {
            throw new IllegalStateException(DialogHandler.text.getString("no_transformer_state"));
        }
        if (this.transformedDataStream != null) {
            throw new IllegalStateException(DialogHandler.text.getString("illegal_change_of_transformed_data"));
        }
        this.transformedDataStream = transformedData;
    }

    public void setTransformedData(String transformedData) {
        this.setTransformedData(new ByteArrayInputStream(transformedData.getBytes(Constants.CHARSET_ENCODING)));
    }

    public String[] getTransformerForSignature() {
        if (this.transformers.size() < 2) {
            return null;
        }
        String[] ret = new String[this.transformers.size() - 1];
        for (int i = 1; i < this.transformers.size(); ++i) {
            ret[i - 1] = (String)this.transformers.get(i);
        }
        return ret;
    }

    @Override
    protected byte[] getDigestValue(String digestAlgorithm) throws NoSuchAlgorithmException, IOException, OSCIException {
        if (this.digestValues.get(digestAlgorithm) != null) {
            return (byte[])this.digestValues.get(digestAlgorithm);
        }
        MessageDigest md = DialogHandler.getSecurityProvider() == null ? MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(digestAlgorithm)) : MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(digestAlgorithm), DialogHandler.getSecurityProvider());
        NullOutputStream nos = new NullOutputStream();
        DigestOutputStream digestOut = new DigestOutputStream(nos, md);
        if (this.contentType == 2) {
            int i;
            if (this.transformedDataStream == null) {
                if (this.transformers.isEmpty()) {
                    this.transformers.add("<ds:Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#base64\"></ds:Transform>");
                }
                if (this.transformers.size() > 1) {
                    digestOut.close();
                    throw new IllegalStateException(DialogHandler.text.getString("no_transformed_data"));
                }
                this.swapBuffer.getInputStream().reset();
                this.transformedDataStream = new Base64InputStream(this.swapBuffer.getInputStream());
            }
            if (log.isDebugEnabled() && this.transformers != null) {
                for (int i2 = 0; i2 < this.transformers.size(); ++i2) {
                    log.debug((Object)("Transfromer " + this.getRefID() + " - " + (String)this.transformers.get(i2)));
                }
            }
            byte[] tmp = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
            while ((i = this.transformedDataStream.read(tmp)) > -1) {
                digestOut.write(tmp, 0, i);
            }
            this.transformedDataStream.close();
            digestOut.close();
            this.digestValues.put(digestAlgorithm, md.digest());
        } else {
            this.writeXML(digestOut, false);
            digestOut.close();
            this.digestValues.put(digestAlgorithm, md.digest());
            if (log.isDebugEnabled()) {
                log.debug((Object)("enter getDigestValue" + Crypto.toHex((byte[])this.digestValues.get(digestAlgorithm))));
            }
            this.length = nos.getLength();
        }
        return (byte[])this.digestValues.get(digestAlgorithm);
    }

    public InputStream getContentStream() throws IOException {
        if (this.swapBuffer != null) {
            this.swapBuffer.getInputStream().reset();
            return new Base64InputStream(this.swapBuffer.getInputStream());
        }
        return null;
    }

    public String getContentData() throws IOException {
        if (this.swapBuffer != null) {
            int anz;
            this.swapBuffer.getInputStream().reset();
            Base64InputStream in = new Base64InputStream(this.swapBuffer.getInputStream());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] bytes = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
            while ((anz = ((InputStream)in).read(bytes)) > -1) {
                bos.write(bytes, 0, anz);
            }
            ((InputStream)in).close();
            bos.close();
            return bos.toString(Constants.CHARSET_ENCODING);
        }
        return null;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public ContentContainer getContentContainer() {
        return this.coco;
    }

    public int getContentType() {
        return this.contentType;
    }

    public String toString() {
        ByteArrayOutputStream out;
        block2: {
            out = new ByteArrayOutputStream();
            try {
                this.writeXML(out);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Fehler beim writeXML", (Throwable)ex);
            }
        }
        return out.toString(Constants.CHARSET_ENCODING);
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException, OSCIException {
        this.writeXML(out, false);
    }

    public void writeXML(OutputStream out, boolean inner) throws IOException, OSCIException {
        out.write(("<" + this.osciNSPrefix + ":Content").getBytes(Constants.CHARSET_ENCODING));
        if (this.attachment != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SCHREIBE Attachment." + this.getRefID()));
            }
            if (!inner) {
                if (this.coNS == null) {
                    out.write(this.ns);
                } else {
                    out.write(this.coNS.getBytes(Constants.CHARSET_ENCODING));
                }
            }
            out.write((" Id=\"" + this.getRefID() + "\" href=\"cid:" + this.attachment.getRefID() + "\"></" + this.osciNSPrefix + ":Content>").getBytes(Constants.CHARSET_ENCODING));
        } else if (this.coco != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Schreibe ContentContainer." + this.getRefID()));
            }
            if (!inner) {
                out.write(this.ns);
            }
            out.write((" Id=\"" + this.getRefID() + "\">").getBytes(Constants.CHARSET_ENCODING));
            this.coco.writeXML(out, true);
            out.write(("</" + this.osciNSPrefix + ":Content>").getBytes(Constants.CHARSET_ENCODING));
        } else {
            int count;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Schreibe Daten.");
            }
            out.write(("><" + this.osciNSPrefix + ":Base64Content").getBytes(Constants.CHARSET_ENCODING));
            if (!inner) {
                out.write(this.ns);
            }
            out.write((" Id=\"" + this.getRefID() + "\">").getBytes(Constants.CHARSET_ENCODING));
            byte[] inBytes = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
            InputStream in = this.swapBuffer.getInputStream();
            in.reset();
            while ((count = in.read(inBytes)) > -1) {
                out.write(inBytes, 0, count);
            }
            in.close();
            out.flush();
            out.write(("</" + this.osciNSPrefix + ":Base64Content></" + this.osciNSPrefix + ":Content>").getBytes(Constants.CHARSET_ENCODING));
        }
    }
}

