/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.ChunkInformation;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ChunkInformationBuilder
extends MessagePartParser {
    private static Log log = LogFactory.getLog(ChunkInformationBuilder.class);
    private ChunkInformation chunkInformation = null;

    public ChunkInformationBuilder(XMLReader xmlReader, DefaultHandler parentHandler, ChunkInformation.CheckInstance checkInstance) {
        super(xmlReader, parentHandler);
        this.chunkInformation = new ChunkInformation(checkInstance);
        OSCIMessage msg = ((OSCIMessageBuilder)parentHandler).getOSCIMessage();
        this.chunkInformation.setNSPrefixes(msg);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Start-Element: " + localName));
            }
            try {
                if (ParserHelper.isElement(Constants.CommonTags.ChunkInformation, localName, uri)) {
                    if (attributes.getValue("ChunkNumber") != null) {
                        this.chunkInformation.setChunkNumber(Integer.parseInt(attributes.getValue("ChunkNumber")));
                    }
                    if (attributes.getValue("TotalChunkNumbers") != null) {
                        this.chunkInformation.setTotalChunkNumbers(Integer.parseInt(attributes.getValue("TotalChunkNumbers")));
                    }
                    if (attributes.getValue("TotalMessageSize") != null) {
                        this.chunkInformation.setTotalMessageSize(Long.parseLong(attributes.getValue("TotalMessageSize")));
                    }
                    if (attributes.getValue("ChunkSize") != null) {
                        this.chunkInformation.setChunkSize(Long.parseLong(attributes.getValue("ChunkSize")));
                    }
                    if (attributes.getValue("ReceivedChunks") != null) {
                        this.chunkInformation.setReceivedChunks(this.parseReceivedChunks(attributes.getValue("ReceivedChunks")));
                    }
                    break block10;
                }
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception ex) {
                log.error((Object)"Fehler im Start-Element", (Throwable)ex);
                throw new SAXException(ex);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End-Element: " + localName));
        }
        try {
            if (!ParserHelper.isElement(Constants.CommonTags.ChunkInformation, localName, uri)) {
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            this.parentHandler.endElement(uri, localName, qName);
            this.xmlReader.setContentHandler(this.parentHandler);
        }
        catch (SAXException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"Fehler im End-Element!", (Throwable)ex);
            throw new SAXException(ex);
        }
        this.currentElement = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement == null) {
            for (int i = 0; i < length; ++i) {
                if (ch[start + i] <= ' ') continue;
                throw new SAXException(DialogHandler.text.getString("unexpected_char"));
            }
        } else {
            this.currentElement.append(ch, start, length);
        }
    }

    private ArrayList<Integer> parseReceivedChunks(String receivedChunks) {
        if (receivedChunks == null) {
            return null;
        }
        ArrayList<Integer> arrayChunks = new ArrayList<Integer>();
        StringTokenizer strToken = new StringTokenizer(receivedChunks, " ");
        while (strToken.hasMoreTokens()) {
            arrayChunks.add(Integer.parseInt(strToken.nextToken()));
        }
        return arrayChunks;
    }

    public ChunkInformation getChunkInformationObject() {
        return this.chunkInformation;
    }
}

