/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.soapheader.HeaderEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Body
extends HeaderEntry {
    private static Log log = LogFactory.getLog(Body.class);
    String data;
    private ContentContainer[] cc;
    private EncryptedDataOSCI[] encData;

    public Body(String data) {
        this.data = data;
        this.id = "body";
    }

    public Body(ContentContainer[] cc, EncryptedDataOSCI[] encData) {
        int i;
        this.cc = cc;
        Hashtable<String, String> nsp = new Hashtable<String, String>();
        nsp.put(this.osciNSPrefix, MessagePartParser.OSCI_XMLNS);
        nsp.put(this.soapNSPrefix, MessagePartParser.SOAP_XMLNS);
        nsp.put(this.dsNSPrefix, MessagePartParser.DS_XMLNS);
        nsp.put(this.xencNSPrefix, MessagePartParser.XENC_XMLNS);
        nsp.put(this.xsiNSPrefix, MessagePartParser.XSI_XMLNS);
        for (i = 0; i < cc.length; ++i) {
            nsp.put(cc[i].osciNSPrefix, MessagePartParser.OSCI_XMLNS);
            nsp.put(cc[i].soapNSPrefix, MessagePartParser.SOAP_XMLNS);
            nsp.put(cc[i].dsNSPrefix, MessagePartParser.DS_XMLNS);
            nsp.put(cc[i].xencNSPrefix, MessagePartParser.XENC_XMLNS);
            nsp.put(cc[i].xsiNSPrefix, MessagePartParser.XSI_XMLNS);
        }
        for (i = 0; i < encData.length; ++i) {
            nsp.put(encData[i].osciNSPrefix, MessagePartParser.OSCI_XMLNS);
            nsp.put(encData[i].soapNSPrefix, MessagePartParser.SOAP_XMLNS);
            nsp.put(encData[i].dsNSPrefix, MessagePartParser.DS_XMLNS);
            nsp.put(encData[i].xencNSPrefix, MessagePartParser.XENC_XMLNS);
            nsp.put(encData[i].xsiNSPrefix, MessagePartParser.XSI_XMLNS);
        }
        Vector keySet = new Vector(nsp.keySet());
        Collections.sort(keySet);
        StringBuilder sb = new StringBuilder();
        for (String s : keySet) {
            sb.append(" xmlns:");
            sb.append(s);
            sb.append("=\"");
            sb.append((String)nsp.get(s));
            sb.append("\"");
        }
        this.ns = sb.toString().getBytes(Constants.CHARSET_ENCODING);
        log.debug((Object)("NS: " + new String(this.ns)));
        this.encData = encData;
        this.id = "body";
    }

    @Override
    protected byte[] getDigestValue(String digestAlgorithm) throws NoSuchAlgorithmException, IOException, OSCIException {
        byte[] ret = super.getDigestValue(digestAlgorithm);
        this.length = -1L;
        return ret;
    }

    @Override
    public void writeXML(OutputStream out) throws IOException, OSCIException {
        out.write(60);
        out.write(this.soapNSPrefix.getBytes(Constants.CHARSET_ENCODING));
        out.write(":Body".getBytes(Constants.CHARSET_ENCODING));
        out.write(this.ns);
        out.write((" Id=\"" + this.id + "\">").getBytes(Constants.CHARSET_ENCODING));
        if (this.data != null) {
            out.write(this.data.getBytes(Constants.CHARSET_ENCODING));
        } else {
            int i;
            out.write(60);
            out.write(this.osciNSPrefix.getBytes(Constants.CHARSET_ENCODING));
            out.write(":ContentPackage>".getBytes(Constants.CHARSET_ENCODING));
            for (i = 0; i < this.encData.length; ++i) {
                this.encData[i].writeXML(out, false);
            }
            for (i = 0; i < this.cc.length; ++i) {
                this.cc[i].writeXML(out, false);
            }
            out.write("</".getBytes(Constants.CHARSET_ENCODING));
            out.write(this.osciNSPrefix.getBytes(Constants.CHARSET_ENCODING));
            out.write(":ContentPackage>".getBytes(Constants.CHARSET_ENCODING));
        }
        out.write("</".getBytes(Constants.CHARSET_ENCODING));
        out.write(this.soapNSPrefix.getBytes(Constants.CHARSET_ENCODING));
        out.write(":Body>".getBytes(Constants.CHARSET_ENCODING));
    }
}

