/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Base64;
import de.osci.helper.Base64OutputStream;
import de.osci.helper.NullOutputStream;
import de.osci.helper.SymCipherInputStream;
import de.osci.helper.SymCipherOutputStream;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.encryption.OSCICipherException;
import de.osci.osci12.extinterfaces.OSCIDataSource;
import de.osci.osci12.messageparts.MessagePart;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Attachment
extends MessagePart {
    private static Log log = LogFactory.getLog(Attachment.class);
    private static final int STATE_OF_ATTACHMENT_CLIENT = 0;
    public static final int STATE_OF_ATTACHMENT_PARSING = 1;
    public static final int STATE_OF_ATTACHMENT_ENCRYPTED = 2;
    SecretKey secretKey;
    String symmetricCipherAlgorithm = "http://www.w3.org/2009/xmlenc11#aes256-gcm";
    int ivLength = 12;
    OSCIDataSource swapBuffer;
    boolean encrypt;
    private String contentType = "application/octet-stream";
    private Hashtable<String, byte[]> encryptedDigestValues = new Hashtable();
    int stateOfAttachment = 0;
    private String boundaryString = DialogHandler.boundary;
    protected boolean base64 = false;
    Hashtable<String, String> mimeHeaders;

    Attachment(InputStream ins, String refId, long length, String transportDigestAlgorithm) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry Attachment(java.io.InputStream ins, String refId, long length, String transportDigestAlgorithm) with ID " + refId));
        }
        this.setRefID(refId);
        this.length = length;
        if (ins != null) {
            this.setInputStream(ins, false, length, transportDigestAlgorithm);
        }
    }

    public Attachment(InputStream ins, String refId, String symmetricCipherAlgorithm) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        this(ins, refId, Crypto.createSymKey(symmetricCipherAlgorithm), symmetricCipherAlgorithm, 12);
    }

    public Attachment(InputStream ins, String refId, String symmetricCipherAlgorithm, int ivLength) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        this(ins, refId, Crypto.createSymKey(symmetricCipherAlgorithm), symmetricCipherAlgorithm, ivLength);
    }

    @Deprecated(since="1.8")
    public Attachment(InputStream ins, String refId, SecretKey secretKey) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        this(ins, refId, secretKey, Crypto.getCipherAlgoID(secretKey), 12);
    }

    public Attachment(InputStream ins, String refId, SecretKey secretKey, String symmetricCipherAlgorithm) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        this(ins, refId, secretKey, symmetricCipherAlgorithm, 12);
    }

    public Attachment(InputStream ins, String refId, SecretKey secretKey, String symmetricCipherAlgorithm, int ivLength) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry Attachment(java.io.InputStream ins, String refId, SecretKey secretKey, String symmetricCipherAlgorithm, int ivLength) with ID " + refId));
        }
        if (ins == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " ins");
        }
        if (refId == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " refId");
        }
        if (symmetricCipherAlgorithm == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString("invalid_fourthargument") + " symmetricCipherAlgorithm");
        }
        this.ivLength = ivLength;
        this.symmetricCipherAlgorithm = symmetricCipherAlgorithm;
        if (secretKey == null) {
            this.secretKey = Crypto.createSymKey(symmetricCipherAlgorithm);
        } else {
            if (!secretKey.getAlgorithm().equals("DESede") && !secretKey.getAlgorithm().equals("AES")) {
                throw new IllegalArgumentException(DialogHandler.text.getString("encryption_algorithm_not_supported"));
            }
            this.secretKey = secretKey;
        }
        this.encrypt = true;
        this.setRefID(refId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RefId Name: " + refId));
        }
        this.makeTempFile(ins);
    }

    public Attachment(InputStream ins, String refId) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry Attachment(java.io.InputStream ins, String refId) with ID " + refId));
        }
        if (ins == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " null");
        }
        if (refId == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_secondargument.name()) + " null");
        }
        this.encrypt = false;
        this.setRefID(refId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RefId Name: " + refId));
        }
        this.makeTempFile(ins);
    }

    @Override
    public void setRefID(String id) {
        super.setRefID(id);
    }

    @Override
    public String getRefID() {
        return super.getRefID();
    }

    @Override
    public long getLength() {
        if (this.base64) {
            return Base64.calcB64Length(this.length);
        }
        return this.length;
    }

    public InputStream getStream() throws OSCICipherException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("entry getStream for attachment " + this.getRefID()));
        }
        if (this.swapBuffer == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Swapbuffer is null, return null for attachment " + this.getRefID()));
            }
            return null;
        }
        InputStream is = null;
        is = this.swapBuffer.getInputStream();
        is.reset();
        if (this.encrypt || this.stateOfAttachment == 2) {
            if (this.secretKey == null && this.stateOfAttachment != 1) {
                throw new OSCICipherException("no_secret_key");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attachment ist Base64 codiert.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attachment ist verschl\u00fcsselt codiert.");
            }
            return new SymCipherInputStream(is, this.secretKey, this.symmetricCipherAlgorithm, this.ivLength, false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Daten sind nicht verschl\u00fcsselt");
        }
        return is;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    void setInputStream(InputStream ins, boolean encrypted, long length, String transportDigestAlgorithm) throws IOException, NoSuchAlgorithmException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("entry SetStream for attachment " + this.getRefID()));
        }
        this.length = length;
        this.encrypt = encrypted;
        if (ins != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("InputStream found for attachment " + this.getRefID()));
            }
            this.swapBuffer = DialogHandler.getNewDataBuffer();
            OutputStream out = this.swapBuffer.getOutputStream();
            MessageDigest encMsgDigest = null;
            if (transportDigestAlgorithm != null) {
                encMsgDigest = DialogHandler.getSecurityProvider() == null ? MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(transportDigestAlgorithm)) : MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(transportDigestAlgorithm), DialogHandler.getSecurityProvider());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Create signed output stream for attachment " + this.getRefID()));
                }
                out = new DigestOutputStream(out, encMsgDigest);
            }
            BufferedInputStream bufferdIn = new BufferedInputStream(ins, Constants.DEFAULT_BUFFER_BLOCKSIZE);
            int count = 0;
            byte[] bytesIn = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
            while ((count = bufferdIn.read(bytesIn)) > -1) {
                out.write(bytesIn, 0, count);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Written " + count + " bytes into stream for attachment " + this.getRefID()));
            }
            ins.close();
            out.close();
            bufferdIn.close();
            if (transportDigestAlgorithm != null) {
                this.encryptedDigestValues.put(transportDigestAlgorithm, encMsgDigest.digest());
            }
        } else {
            log.error((Object)("No Attachment InputStream found for attachment " + this.getRefID()));
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " null");
        }
        this.length = this.swapBuffer.getLength();
    }

    private void makeTempFile(InputStream ins) throws IOException, NoSuchAlgorithmException {
        if (this.swapBuffer != null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"MakeTempFile wurde aufgerufen.");
        }
        this.swapBuffer = DialogHandler.getNewDataBuffer();
        OutputStream out = this.swapBuffer.getOutputStream();
        MessageDigest encMsgDigest = null;
        MessageDigest msgDigest = null;
        msgDigest = DialogHandler.getSecurityProvider() == null ? MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(DialogHandler.getDigestAlgorithm())) : MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(DialogHandler.getDigestAlgorithm()), DialogHandler.getSecurityProvider());
        if (this.encrypt) {
            encMsgDigest = DialogHandler.getSecurityProvider() == null ? MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(DialogHandler.getDigestAlgorithm())) : MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(DialogHandler.getDigestAlgorithm()), DialogHandler.getSecurityProvider());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Verschl\u00fcsseltes Attachment wird erstellt");
            }
            out = new DigestOutputStream(out, encMsgDigest);
            out = new SymCipherOutputStream(out, this.secretKey, this.symmetricCipherAlgorithm, this.ivLength, true);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Unverschl\u00fcsseltes Attachment wird erstellt");
        }
        out = new DigestOutputStream(out, msgDigest);
        BufferedInputStream bufferdIn = new BufferedInputStream(ins, Constants.DEFAULT_BUFFER_BLOCKSIZE);
        int count = 0;
        byte[] bytesIn = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
        this.length = 0L;
        while ((count = bufferdIn.read(bytesIn)) > -1) {
            out.write(bytesIn, 0, count);
        }
        out.flush();
        this.swapBuffer.getOutputStream().flush();
        out.close();
        bufferdIn.close();
        this.digestValues.put(DialogHandler.getDigestAlgorithm(), msgDigest.digest());
        if (this.encrypt) {
            this.encryptedDigestValues.put(DialogHandler.getDigestAlgorithm(), encMsgDigest.digest());
        } else {
            this.encryptedDigestValues.put(DialogHandler.getDigestAlgorithm(), (byte[])this.digestValues.get(DialogHandler.getDigestAlgorithm()));
        }
        this.length = this.swapBuffer.getLength();
    }

    public boolean hasDigestValue(String digestAlgorithm) {
        return this.digestValues.get(digestAlgorithm) != null;
    }

    @Override
    public byte[] getDigestValue(String digestAlgorithm) throws IOException, NoSuchAlgorithmException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digest vorhanden? " + this.digestValues.get(digestAlgorithm) + " stateOfObjekt:" + this.stateOfAttachment));
        }
        if (this.digestValues.get(digestAlgorithm) == null) {
            this.digestValues.put(digestAlgorithm, this.createDigest(digestAlgorithm, this.encrypt));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Der Digest Value des Attachment ist: " + new String((byte[])this.digestValues.get(digestAlgorithm))));
        }
        return (byte[])this.digestValues.get(digestAlgorithm);
    }

    private byte[] createDigest(String digestAlgorithm, boolean enc) throws IOException, NoSuchAlgorithmException {
        int count;
        if (this.swapBuffer == null) {
            log.error((Object)"SwapBuffer ist null!");
            throw new IOException(DialogHandler.text.getString("io_exception"));
        }
        InputStream in = null;
        in = this.swapBuffer.getInputStream();
        if (in == null) {
            throw new IOException(DialogHandler.text.getString("io_exception"));
        }
        in.reset();
        MessageDigest msgDigest = DialogHandler.getSecurityProvider() == null ? MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(digestAlgorithm)) : MessageDigest.getInstance(Constants.JCA_JCE_MAP.get(digestAlgorithm), DialogHandler.getSecurityProvider());
        if (log.isDebugEnabled()) {
            log.debug((Object)("State of Attachment: " + this.stateOfAttachment + " Verschl\u00fcsselt: " + this.encrypt));
        }
        InputStream inStream = in;
        if (this.stateOfAttachment != 1 && enc) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Das Attachment ist verschl\u00fcsselt.");
            }
            inStream = new SymCipherInputStream(in, this.secretKey, this.symmetricCipherAlgorithm, this.ivLength, false);
        }
        DigestOutputStream out = new DigestOutputStream(new NullOutputStream(), msgDigest);
        byte[] bytes = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
        while ((count = inStream.read(bytes)) > -1) {
            out.write(bytes, 0, count);
        }
        inStream.close();
        out.close();
        return msgDigest.digest();
    }

    public void setBoundary(String boundary) {
        this.boundaryString = boundary;
    }

    public void setBase64Encoding(boolean b64) {
        this.base64 = b64;
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException {
        out.write(("\r\n--" + this.boundaryString + "\r\nContent-Type: " + this.contentType + "\r\nContent-Transfer-Encoding: ").getBytes(Constants.CHARSET_ENCODING));
        out.write((this.base64 ? "base64" : "8-bit").getBytes(Constants.CHARSET_ENCODING));
        out.write(("\r\nContent-ID: <" + this.getRefID() + ">\r\nContent-Length: " + this.getLength() + "\r\n").getBytes(Constants.CHARSET_ENCODING));
        if (this.mimeHeaders != null) {
            Hashtable mh = (Hashtable)this.mimeHeaders.clone();
            this.removeHeaders(mh);
            Enumeration e = mh.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                out.write((key.trim() + ": " + ((String)mh.get(key)).trim() + "\r\n").getBytes(Constants.CHARSET_ENCODING));
            }
        }
        out.write("\r\n".getBytes(Constants.CHARSET_ENCODING));
        if (log.isDebugEnabled()) {
            log.debug((Object)("######### SwapBuffero#### " + this.swapBuffer));
        }
        InputStream in = this.swapBuffer.getInputStream();
        in.reset();
        if (this.base64) {
            out = new Base64OutputStream(out, true);
        }
        int count = 0;
        byte[] bytesIn = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
        while ((count = in.read(bytesIn)) > -1) {
            out.write(bytesIn, 0, count);
        }
        in.close();
        if (this.base64) {
            out.flush();
        }
    }

    public boolean isEncrypted() {
        return this.encrypt;
    }

    public String getSymmetricCipherAlgorithm() {
        return this.symmetricCipherAlgorithm;
    }

    public void setSymmetricCipherAlgorithm(String symmetricCipherAlgorithm) {
        this.symmetricCipherAlgorithm = symmetricCipherAlgorithm;
    }

    public byte[] getEncryptedDigestValue(String digestAlgorithm) throws IOException, NoSuchAlgorithmException {
        if (this.encryptedDigestValues.get(digestAlgorithm) == null) {
            this.encryptedDigestValues.put(digestAlgorithm, this.createDigest(digestAlgorithm, false));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)new String(this.encryptedDigestValues.get(digestAlgorithm)));
        }
        return this.encryptedDigestValues.get(digestAlgorithm);
    }

    public Hashtable<String, String> getMimeHeaders() {
        return this.mimeHeaders;
    }

    public void setMimeHeaders(Hashtable<String, String> headers) {
        this.removeHeaders(headers);
        this.mimeHeaders = headers;
    }

    private void removeHeaders(Hashtable<String, String> ht) {
        String[] hd = new String[]{"Content-Transfer-Encoding", "Content-ID", "Content-Length", "Content-Type"};
        Enumeration<String> e = ht.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            for (int i = 0; i < hd.length; ++i) {
                if (!key.equalsIgnoreCase(hd[i])) continue;
                ht.remove(key);
            }
        }
    }

    public int getIvLength() {
        return this.ivLength;
    }

    public void setIvLength(int ivLength) {
        this.ivLength = ivLength;
    }
}

