/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.encryption;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.CipherData;
import de.osci.osci12.encryption.CipherReference;
import de.osci.osci12.encryption.CipherValue;
import de.osci.osci12.encryption.EncryptedKey;
import de.osci.osci12.signature.KeyInfoBuilder;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EncryptedKeyBuilder
extends DefaultHandler {
    private static Log log = LogFactory.getLog(EncryptedKeyBuilder.class);
    EncryptedKey encKey = null;
    private Vector<String> transformer = new Vector();
    private CipherReference cipherRef = null;
    private CipherValue cipherValue = null;
    private CipherData cipherData = null;
    private StringBuffer currentElement = null;
    private KeyInfoBuilder parentHandler = null;
    private XMLReader xmlReader = null;
    protected static final String DS_XMLNS = "http://www.w3.org/2000/09/xmldsig#";
    protected static final String XENC_XMLNS = "http://www.w3.org/2001/04/xmlenc#";
    protected static final String XENC11_XMLNS = "http://www.w3.org/2009/xmlenc11#";

    public EncryptedKeyBuilder(XMLReader xmlReader, DefaultHandler parentHandler, Attributes attributes) throws SAXException {
        if (!(parentHandler instanceof KeyInfoBuilder)) {
            throw new SAXException(DialogHandler.text.getString("sax_exception"));
        }
        this.parentHandler = (KeyInfoBuilder)parentHandler;
        this.xmlReader = xmlReader;
        this.encKey = new EncryptedKey();
        if (attributes != null) {
            if (attributes.getValue("Recipient") != null) {
                this.encKey.setRecipient(attributes.getValue("Recipient"));
            }
            if (attributes.getValue("Id") != null) {
                this.encKey.setId(attributes.getValue("Id"));
            }
            if (attributes.getValue("MimeType") != null) {
                this.encKey.setMimeType(attributes.getValue("MimeType"));
            }
            if (attributes.getValue("Encoding") != null) {
                this.encKey.setEncoding(attributes.getValue("Encoding"));
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (uri.equals(XENC11_XMLNS)) {
            this.encKey.xenc11NSPrefix = prefix;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start-Element: " + localName));
        }
        if (!localName.equals("EncryptedKey") || !uri.equals(XENC_XMLNS)) {
            if (localName.equals("KeyInfo") && uri.equals(DS_XMLNS)) {
                this.xmlReader.setContentHandler(new KeyInfoBuilder(this.xmlReader, this, attributes));
            } else if (localName.equals("EncryptionMethod") && uri.equals(XENC_XMLNS)) {
                this.encKey.setEncryptionMethodAlgorithm(attributes.getValue("Algorithm"));
            } else if (localName.equals("MGF") && uri.equals(XENC11_XMLNS)) {
                this.encKey.mgfAlgorithm = attributes.getValue("Algorithm");
            } else if (localName.equals("DigestMethod") && uri.equals(DS_XMLNS)) {
                this.encKey.digestAlgorithm = attributes.getValue("Algorithm");
            } else if (!localName.equals("CipherData") || !uri.equals(XENC_XMLNS)) {
                if (localName.equals("CipherValue") && uri.equals(XENC_XMLNS)) {
                    this.currentElement = new StringBuffer();
                } else if (localName.equals("CipherReference") && uri.equals(XENC_XMLNS)) {
                    try {
                        String cp = attributes.getValue("URI");
                        this.cipherRef = new CipherReference(cp);
                    }
                    catch (IOException ex) {
                        throw new SAXException(ex);
                    }
                } else if (!localName.equals("Transforms") || !uri.equals(XENC_XMLNS)) {
                    if (localName.equals("Transform") && uri.equals(DS_XMLNS)) {
                        if (attributes.getValue("Algorithm") == null) {
                            throw new SAXException(DialogHandler.text.getString("sax_exception"));
                        }
                        this.transformer.add(attributes.getValue("Algorithm"));
                    } else {
                        if (localName.equals("EncryptionProperties") && uri.equals(XENC_XMLNS)) {
                            throw new SAXException(DialogHandler.text.getString("sax_exception"));
                        }
                        if (localName.equals("RefernceList") && uri.equals(XENC_XMLNS)) {
                            throw new SAXException(DialogHandler.text.getString("sax_exception"));
                        }
                        if (localName.equals("CarriedKeyName") && uri.equals(XENC_XMLNS)) {
                            this.currentElement = new StringBuffer();
                        } else {
                            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("End-Element: " + localName));
            }
            try {
                if (localName.equals("EncryptedKey") && uri.equals(XENC_XMLNS)) {
                    this.parentHandler.getKeyInfo().addEncryptedKey(this.encKey);
                    this.xmlReader.setContentHandler(this.parentHandler);
                    break block10;
                }
                if (localName.equals("KeyInfo") && uri.equals(DS_XMLNS)) break block10;
                if (localName.equals("CipherData") && uri.equals(XENC_XMLNS)) {
                    this.cipherData = this.cipherRef != null ? new CipherData(this.cipherRef) : new CipherData(this.cipherValue);
                    this.encKey.setCipherData(this.cipherData);
                    break block10;
                }
                if (localName.equals("CipherReference") && uri.equals(XENC_XMLNS)) {
                    Enumeration<String> transformers = this.transformer.elements();
                    while (transformers.hasMoreElements()) {
                        this.cipherRef.addTransform(transformers.nextElement());
                    }
                    this.transformer.clear();
                    break block10;
                }
                if (localName.equals("Transforms") && uri.equals(XENC_XMLNS) || localName.equals("Transform") && uri.equals(DS_XMLNS)) break block10;
                if (localName.equals("CipherValue") && uri.equals(XENC_XMLNS)) {
                    this.cipherValue = new CipherValue(this.currentElement.toString());
                    break block10;
                }
                if (localName.equals("EncryptionMethod") && uri.equals(XENC_XMLNS) || localName.equals("MGF") && uri.equals(XENC11_XMLNS) || localName.equals("DigestMethod") && uri.equals(DS_XMLNS) || localName.equals("EncryptionProperties") && uri.equals(XENC_XMLNS) || localName.equals("RefernceList") && uri.equals(XENC_XMLNS)) break block10;
                if (localName.equals("CarriedKeyName") && uri.equals(XENC_XMLNS)) {
                    this.encKey.setCarriedKeyName(this.currentElement.toString());
                    break block10;
                }
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            catch (SAXException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.error((Object)"Fehler im Encrypted-Key Builder.", (Throwable)ex);
                throw new SAXException(ex);
            }
        }
        this.currentElement = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Character: " + new String(ch, start, length)));
        }
        if (this.currentElement == null) {
            for (int i = 0; i < length; ++i) {
                if (ch[start + i] <= ' ') continue;
                throw new SAXException(DialogHandler.text.getString("unexpected_char"));
            }
        } else {
            this.currentElement.append(ch, start, length);
        }
    }

    public EncryptedKey getEncKey() {
        return this.encKey;
    }
}

