/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.encryption;

import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.CipherData;
import de.osci.osci12.encryption.CipherValue;
import de.osci.osci12.encryption.EncryptedType;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedKey
extends EncryptedType {
    private String recipient;
    private String carriedKeyName;
    private String referenceList;
    public String mgfAlgorithm;
    public String digestAlgorithm;
    private static final String XENC11 = "http://www.w3.org/2009/xmlenc11#";
    String xenc11NSPrefix = "xenc11";

    EncryptedKey() {
    }

    public EncryptedKey(String encryptionMethodAlgorithm, CipherValue cipherValue) {
        this.setEncryptionMethodAlgorithm(encryptionMethodAlgorithm);
        if (encryptionMethodAlgorithm.equals("http://www.w3.org/2009/xmlenc11#rsa-oaep")) {
            if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(DialogHandler.getDigestAlgorithm()) || "http://www.w3.org/2007/05/xmldsig-more#sha3-384".equals(DialogHandler.getDigestAlgorithm()) || "http://www.w3.org/2007/05/xmldsig-more#sha3-512".equals(DialogHandler.getDigestAlgorithm())) {
                this.mgfAlgorithm = "http://www.w3.org/2009/xmlenc11#mgf1sha512";
                this.digestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha512";
            } else if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(DialogHandler.getDigestAlgorithm()) || "http://www.w3.org/2007/05/xmldsig-more#sha3-256".equals(DialogHandler.getDigestAlgorithm())) {
                this.mgfAlgorithm = "http://www.w3.org/2009/xmlenc11#mgf1sha256";
                this.digestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha256";
            } else {
                this.mgfAlgorithm = "http://www.w3.org/2009/xmlenc11#mgf1sha256";
                this.digestAlgorithm = "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        CipherData cipherData = new CipherData(cipherValue);
        this.setCipherData(cipherData);
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setCarriedKeyName(String carriedKeyName) {
        this.carriedKeyName = carriedKeyName;
    }

    public String getCarriedKeyName() {
        return this.carriedKeyName;
    }

    public void setReferenceList(String referenceList) {
        this.referenceList = referenceList;
    }

    public String getReferenceList() {
        return this.referenceList;
    }

    public void addDataReference(String uRI) {
    }

    public void addKeyReference(String uRI) {
    }

    public void writeXML(OutputStream out, String ds, String xenc) throws IOException, OSCIException {
        out.write(("<" + xenc + ":EncryptedKey>").getBytes(Constants.CHARSET_ENCODING));
        out.write(("<" + xenc + ":EncryptionMethod Algorithm=\"" + this.getEncryptionMethodAlgorithm() + "\">").getBytes(Constants.CHARSET_ENCODING));
        if (this.getEncryptionMethodAlgorithm().equals("http://www.w3.org/2009/xmlenc11#rsa-oaep")) {
            out.write(("<" + this.xenc11NSPrefix + ":MGF xmlns:" + this.xenc11NSPrefix + "=\"http://www.w3.org/2009/xmlenc11#\" Algorithm=\"" + this.mgfAlgorithm + "\"></" + this.xenc11NSPrefix + ":MGF>").getBytes(Constants.CHARSET_ENCODING));
            out.write(("<" + ds + ":DigestMethod Algorithm=\"" + this.digestAlgorithm + "\"></" + ds + ":DigestMethod>").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("</" + xenc + ":EncryptionMethod>").getBytes(Constants.CHARSET_ENCODING));
        this.getKeyInfo().writeXML(out, ds, xenc);
        this.getCipherData().writeXML(out, ds, xenc);
        out.write(("</" + xenc + ":EncryptedKey>").getBytes(Constants.CHARSET_ENCODING));
    }
}

