/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.encryption;

import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.CipherData;
import de.osci.osci12.encryption.CipherReference;
import de.osci.osci12.encryption.CipherValue;
import de.osci.osci12.encryption.EncryptedKey;
import de.osci.osci12.encryption.EncryptedType;
import de.osci.osci12.messageparts.ContentContainer;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncryptedData
extends EncryptedType {
    private static Log log = LogFactory.getLog(EncryptedData.class);
    private static byte[] ns = " xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:osci=\"http://www.osci.de/2002/04/osci\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"".getBytes(Constants.CHARSET_ENCODING);
    public String encNS;
    public String soapNSPrefix = Constants.Namespaces.SOAP.getPrefix();
    public String osciNSPrefix = Constants.Namespaces.OSCI.getPrefix();
    public String dsNSPrefix = Constants.Namespaces.XML_SIG.getPrefix();
    public String xencNSPrefix = Constants.Namespaces.XML_ENC.getPrefix();
    public String xsiNSPrefix = Constants.Namespaces.XML_SCHEMA.getPrefix();

    public EncryptedData(ContentContainer coco, String encryptionMethodAlgorithm, String iD, SecretKey key) {
        this(coco, encryptionMethodAlgorithm, 12, iD, key);
    }

    public EncryptedData(ContentContainer coco, String encryptionMethodAlgorithm, int ivLength, String iD, SecretKey key) {
        if (coco == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " null");
        }
        if (key == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " null");
        }
        CipherValue cipherValue = new CipherValue(coco, key, encryptionMethodAlgorithm, ivLength);
        CipherData cipherData = new CipherData(cipherValue);
        this.setEncryptionMethodAlgorithm(encryptionMethodAlgorithm);
        this.setIvLength(ivLength);
        this.setMimeType("text/xml");
        this.setId(iD);
        this.setCipherData(cipherData);
    }

    public EncryptedData(CipherReference cipherReference, String encryptionMethodAlgorithm, String iD) {
        this(cipherReference, encryptionMethodAlgorithm, 12, iD);
    }

    public EncryptedData(CipherReference cipherReference, String encryptionMethodAlgorithm, int ivLength, String iD) {
        CipherData cipherData = new CipherData(cipherReference);
        this.setEncryptionMethodAlgorithm(encryptionMethodAlgorithm);
        this.setIvLength(ivLength);
        this.setMimeType("text/xml");
        this.setId(iD);
        this.setCipherData(cipherData);
    }

    EncryptedData(String iD) {
        this.setMimeType("text/xml");
        this.setId(iD);
    }

    public EncryptedKey findEncrypedKey(String refId) {
        EncryptedKey[] keys = this.getKeyInfo().getEncryptedKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("KeyInfo Eintrag:" + keys[i].getKeyInfo().getRetrievalMethod().getURI()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Vergleiche refID:\n" + refId + "\nmit:\n" + keys[i].getKeyInfo().getRetrievalMethod().getURI() + "\n" + keys[i].getKeyInfo().getRetrievalMethod().getURI().endsWith(refId)));
            }
            if (!keys[i].getKeyInfo().getRetrievalMethod().getURI().endsWith(refId)) continue;
            return keys[i];
        }
        return null;
    }

    public void writeXML(OutputStream out) throws IOException, OSCIException {
        this.writeXML(out, true);
    }

    public void writeXML(OutputStream out, boolean inner) throws IOException, OSCIException {
        out.write(("<" + this.xencNSPrefix + ":EncryptedData").getBytes(Constants.CHARSET_ENCODING));
        if (!(out instanceof DigestOutputStream) && !inner) {
            if (this.encNS == null) {
                out.write(ns);
            } else {
                out.write(this.encNS.getBytes(Constants.CHARSET_ENCODING));
            }
        }
        if (this.getId() != null && !this.getId().equals("")) {
            out.write((" Id=\"" + this.getId() + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write((" MimeType=\"" + this.getMimeType() + "\"><" + this.xencNSPrefix + ":EncryptionMethod Algorithm=\"" + this.getEncryptionMethodAlgorithm() + "\">").getBytes(Constants.CHARSET_ENCODING));
        if (this.getIvLength() != 16) {
            out.write(("<" + Constants.Namespaces.OSCI128.getPrefix() + ":IvLength xmlns:" + Constants.Namespaces.OSCI128.getPrefix() + "=\"" + Constants.Namespaces.OSCI128.getUri() + "\" Value=\"" + this.getIvLength() + "\"></" + Constants.Namespaces.OSCI128.getPrefix() + ":IvLength>").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("</" + this.xencNSPrefix + ":EncryptionMethod>").getBytes(Constants.CHARSET_ENCODING));
        this.getKeyInfo().writeXML(out, this.dsNSPrefix, this.xencNSPrefix);
        this.getCipherData().writeXML(out, this.dsNSPrefix, this.xencNSPrefix);
        out.write(("</" + this.xencNSPrefix + ":EncryptedData>").getBytes(Constants.CHARSET_ENCODING));
    }
}

