/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.encryption;

import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.encryption.CipherReference;
import de.osci.osci12.encryption.CipherValue;
import java.io.IOException;
import java.io.OutputStream;

public class CipherData {
    private CipherReference cipherReference = null;
    private CipherValue cipherValue = null;
    private boolean referencedData = false;

    public CipherData() {
    }

    public CipherData(CipherValue cipherValue) {
        this.referencedData = false;
        this.cipherValue = cipherValue;
    }

    public CipherData(CipherReference cipherRef) {
        this.referencedData = true;
        this.cipherReference = cipherRef;
    }

    public CipherReference getCipherReference() {
        return this.cipherReference;
    }

    public CipherValue getCipherValue() {
        return this.cipherValue;
    }

    public boolean isReferencedData() {
        return this.referencedData;
    }

    public void writeXML(OutputStream out, String ds, String xenc) throws IOException, OSCIException {
        out.write(("<" + xenc + ":CipherData>").getBytes(Constants.CHARSET_ENCODING));
        if (this.referencedData) {
            this.cipherReference.writeXML(out, ds, xenc);
        } else {
            this.cipherValue.writeXML(out, xenc);
        }
        out.write(("</" + xenc + ":CipherData>").getBytes(Constants.CHARSET_ENCODING));
    }
}

