/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.common;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;

public class Constants {
    public static final Hashtable<String, String> JCA_JCE_MAP;
    public static final Charset CHARSET_ENCODING;
    public static final String CHAR_ENCODING;
    public static final String SECURE_RANDOM_ALGORITHM_SHA1 = "SHA1PRNG";
    public static final String SIGNATURE_ALGORITHM_RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private static final String SIGNATURE_ALGORITHM_RSA_SHA1_JCA_JCE = "SHA1withRSA";
    public static final Hashtable<String, Date> OUT_DATES;
    public static final Date OUT_DATE_KEYSIZE_1024;
    public static final Date ACTUAL_DATE;
    public static final int DEFAULT_GCM_IV_LENGTH = 12;
    public static final String SIGNATURE_ALGORITHM_RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private static final String SIGNATURE_ALGORITHM_RSA_SHA256_JCA_JCE = "SHA256withRSA";
    public static final String SIGNATURE_ALGORITHM_RSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    private static final String SIGNATURE_ALGORITHM_RSA_SHA512_JCA_JCE = "SHA512withRSA";
    public static final String SIGNATURE_ALGORITHM_RSA_SHA256_PSS = "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1";
    private static final String SIGNATURE_ALGORITHM_RSA_SHA256_PSS_JCA_JCE = "SHA256withRSAandMGF1";
    public static final String SIGNATURE_ALGORITHM_RSA_SHA512_PSS = "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1";
    private static final String SIGNATURE_ALGORITHM_RSA_SHA512_PSS_JCA_JCE = "SHA512withRSAandMGF1";
    public static final String SIGNATURE_ALGORITHM_RSA_RIPEMD160_RFC4051 = "http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160";
    public static final String SIGNATURE_ALGORITHM_RSA_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
    private static final String SIGNATURE_ALGORITHM_RSA_RIPEMD160_JCA_JCE = "RIPEMD160withRSA";
    public static final String SIGNATURE_ALGORITHM_ECDSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
    private static final String SIGNATURE_ALGORITHM_ECDSA_SHA256_JCA_JCE = "SHA256withCVC-ECDSA";
    public static final String SIGNATURE_ALGORITHM_ECDSA_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
    private static final String SIGNATURE_ALGORITHM_ECDSA_SHA512_JCA_JCE = "SHA512withCVC-ECDSA";
    public static final String SIGNATURE_ALGORITHM_RSA_SHA3_256 = "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1";
    private static final String SIGNATURE_ALGORITHM_RSA_SHA3_256_JCA_JCE = "SHA3-256withRSAandMGF1";
    public static final String SIGNATURE_ALGORITHM_RSA_SHA3_384 = "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1";
    private static final String SIGNATURE_ALGORITHM_RSA_SHA3_384_JCA_JCE = "SHA3-384withRSAandMGF1";
    public static final String SIGNATURE_ALGORITHM_RSA_SHA3_512 = "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1";
    private static final String SIGNATURE_ALGORITHM_RSA_SHA3_512_JCA_JCE = "SHA3-512withRSAandMGF1";
    public static final String DIGEST_ALGORITHM_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    private static final String DIGEST_ALGORITHM_SHA1_JCA_JCE = "SHA-1";
    public static final String DIGEST_ALGORITHM_SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    private static final String DIGEST_ALGORITHM_SHA256_JCA_JCE = "SHA-256";
    public static final String DIGEST_ALGORITHM_SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    private static final String DIGEST_ALGORITHM_SHA512_JCA_JCE = "SHA-512";
    public static final String DIGEST_ALGORITHM_RIPEMD160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    private static final String DIGEST_ALGORITHM_RIPEMD160_JCA_JCE = "RIPEMD160";
    public static final String DIGEST_ALGORITHM_SHA3_256 = "http://www.w3.org/2007/05/xmldsig-more#sha3-256";
    private static final String DIGEST_ALGORITHM_SHA3_256_JCA_JCE = "SHA3-256";
    public static final String DIGEST_ALGORITHM_SHA3_384 = "http://www.w3.org/2007/05/xmldsig-more#sha3-384";
    private static final String DIGEST_ALGORITHM_SHA3_384_JCA_JCE = "SHA3-384";
    public static final String DIGEST_ALGORITHM_SHA3_512 = "http://www.w3.org/2007/05/xmldsig-more#sha3-512";
    private static final String DIGEST_ALGORITHM_SHA3_512_JCA_JCE = "SHA3-512";
    @Deprecated(since="1.8")
    public static final String SYMMETRIC_CIPHER_ALGORITHM_TDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    @Deprecated(since="1.8")
    private static final String SYMMETRIC_CIPHER_ALGORITHM_TDES_CBC_JCA_JCE = "DESede/CBC/PKCS5Padding";
    @Deprecated(since="1.8")
    public static final String SYMMETRIC_CIPHER_ALGORITHM_AES128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    @Deprecated(since="1.8")
    private static final String SYMMETRIC_CIPHER_ALGORITHM_AES_CBC_JCA_JCE = "AES/CBC/PKCS5Padding";
    @Deprecated(since="1.8")
    public static final String SYMMETRIC_CIPHER_ALGORITHM_AES192 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    @Deprecated(since="1.8")
    public static final String SYMMETRIC_CIPHER_ALGORITHM_AES256 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String SYMMETRIC_CIPHER_ALGORITHM_AES128_GCM = "http://www.w3.org/2009/xmlenc11#aes128-gcm";
    public static final String DEFAULT_SYMMETRIC_CIPHER_ALGORITHM = "http://www.w3.org/2009/xmlenc11#aes256-gcm";
    private static final String SYMMETRIC_CIPHER_ALGORITHM_AES_GCM_JCA_JCE = "AES/GCM/NoPadding";
    public static final String SYMMETRIC_CIPHER_ALGORITHM_AES192_GCM = "http://www.w3.org/2009/xmlenc11#aes192-gcm";
    public static final String SYMMETRIC_CIPHER_ALGORITHM_AES256_GCM = "http://www.w3.org/2009/xmlenc11#aes256-gcm";
    @Deprecated(since="2.3.0")
    public static final String ASYMMETRIC_CIPHER_ALGORITHM_RSA_1_5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String ASYMMETRIC_CIPHER_ALGORITHM_RSA_OAEP = "http://www.w3.org/2009/xmlenc11#rsa-oaep";
    public static final String DEFAULT_ASYMMETRIC_CIPHER_ALGORITHM = "http://www.w3.org/2009/xmlenc11#rsa-oaep";
    public static final String MASK_GENERATION_FUNCTION_1_SHA256 = "http://www.w3.org/2009/xmlenc11#mgf1sha256";
    public static final String MASK_GENERATION_FUNCTION_1_SHA384 = "http://www.w3.org/2009/xmlenc11#mgf1sha384";
    public static final String MASK_GENERATION_FUNCTION_1_SHA512 = "http://www.w3.org/2009/xmlenc11#mgf1sha512";
    @Deprecated(since="2.3.0")
    private static final String ASYMMETRIC_CIPHER_ALGORITHM_RSA_1_5_JCA_JCE = "RSA/ECB/PKCS1Padding";
    private static final String ASYMMETRIC_CIPHER_ALGORITHM_RSA_OAEP_JCA_JCE = "RSA/ECB/OAEPPadding";
    public static final int EVENT_CONNECT = 0;
    public static final int EVENT_SIGN_MSG = 1;
    public static final int EVENT_SEND_MSG = 2;
    public static final int EVENT_RECEIVE_MSG = 3;
    public static final int EVENT_ACTION_COMPLETE = 4;
    public static final int DEFAULT_BUFFER_BLOCKSIZE;
    public static final String TRANSFORM_XSLT = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    public static final String TRANSFORM_CANONICALIZATION = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String TRANSFORM_BASE64 = "http://www.w3.org/2000/09/xmldsig#base64";

    static {
        CHARSET_ENCODING = StandardCharsets.UTF_8;
        CHAR_ENCODING = CHARSET_ENCODING.toString();
        DEFAULT_BUFFER_BLOCKSIZE = Integer.parseInt(System.getProperty("osci.default.blocksize", "32768"));
        Hashtable<String, String> tmpJcaJce = new Hashtable<String, String>();
        tmpJcaJce.put(ASYMMETRIC_CIPHER_ALGORITHM_RSA_1_5, ASYMMETRIC_CIPHER_ALGORITHM_RSA_1_5_JCA_JCE);
        tmpJcaJce.put("http://www.w3.org/2009/xmlenc11#rsa-oaep", ASYMMETRIC_CIPHER_ALGORITHM_RSA_OAEP_JCA_JCE);
        tmpJcaJce.put(DIGEST_ALGORITHM_SHA1, DIGEST_ALGORITHM_SHA1_JCA_JCE);
        tmpJcaJce.put(DIGEST_ALGORITHM_SHA256, DIGEST_ALGORITHM_SHA256_JCA_JCE);
        tmpJcaJce.put(DIGEST_ALGORITHM_SHA512, DIGEST_ALGORITHM_SHA512_JCA_JCE);
        tmpJcaJce.put(DIGEST_ALGORITHM_RIPEMD160, DIGEST_ALGORITHM_RIPEMD160_JCA_JCE);
        tmpJcaJce.put(DIGEST_ALGORITHM_SHA3_256, DIGEST_ALGORITHM_SHA3_256_JCA_JCE);
        tmpJcaJce.put(DIGEST_ALGORITHM_SHA3_384, DIGEST_ALGORITHM_SHA3_384_JCA_JCE);
        tmpJcaJce.put(DIGEST_ALGORITHM_SHA3_512, DIGEST_ALGORITHM_SHA3_512_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_RSA_SHA1, SIGNATURE_ALGORITHM_RSA_SHA1_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_RSA_SHA256, SIGNATURE_ALGORITHM_RSA_SHA256_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_RSA_SHA512, SIGNATURE_ALGORITHM_RSA_SHA512_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_RSA_SHA256_PSS, SIGNATURE_ALGORITHM_RSA_SHA256_PSS_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_RSA_SHA512_PSS, SIGNATURE_ALGORITHM_RSA_SHA512_PSS_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_RSA_RIPEMD160, SIGNATURE_ALGORITHM_RSA_RIPEMD160_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_RSA_RIPEMD160_RFC4051, SIGNATURE_ALGORITHM_RSA_RIPEMD160_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_ECDSA_SHA256, SIGNATURE_ALGORITHM_ECDSA_SHA256_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_ECDSA_SHA512, SIGNATURE_ALGORITHM_ECDSA_SHA512_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_RSA_SHA3_256, SIGNATURE_ALGORITHM_RSA_SHA3_256_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_RSA_SHA3_384, SIGNATURE_ALGORITHM_RSA_SHA3_384_JCA_JCE);
        tmpJcaJce.put(SIGNATURE_ALGORITHM_RSA_SHA3_512, SIGNATURE_ALGORITHM_RSA_SHA3_512_JCA_JCE);
        tmpJcaJce.put(SYMMETRIC_CIPHER_ALGORITHM_TDES_CBC, SYMMETRIC_CIPHER_ALGORITHM_TDES_CBC_JCA_JCE);
        tmpJcaJce.put(SYMMETRIC_CIPHER_ALGORITHM_AES128, SYMMETRIC_CIPHER_ALGORITHM_AES_CBC_JCA_JCE);
        tmpJcaJce.put(SYMMETRIC_CIPHER_ALGORITHM_AES192, SYMMETRIC_CIPHER_ALGORITHM_AES_CBC_JCA_JCE);
        tmpJcaJce.put(SYMMETRIC_CIPHER_ALGORITHM_AES256, SYMMETRIC_CIPHER_ALGORITHM_AES_CBC_JCA_JCE);
        tmpJcaJce.put(SYMMETRIC_CIPHER_ALGORITHM_AES128_GCM, SYMMETRIC_CIPHER_ALGORITHM_AES_GCM_JCA_JCE);
        tmpJcaJce.put(SYMMETRIC_CIPHER_ALGORITHM_AES192_GCM, SYMMETRIC_CIPHER_ALGORITHM_AES_GCM_JCA_JCE);
        tmpJcaJce.put("http://www.w3.org/2009/xmlenc11#aes256-gcm", SYMMETRIC_CIPHER_ALGORITHM_AES_GCM_JCA_JCE);
        JCA_JCE_MAP = new UnmodifiableHashtable<String, String>(tmpJcaJce);
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("Europe/Berlin"));
        c.clear();
        c.set(2014, 2, 1);
        ACTUAL_DATE = new UnmodifiableDate(c.getTime());
        c.clear();
        c.set(2008, 3, 1);
        OUT_DATE_KEYSIZE_1024 = new UnmodifiableDate(c.getTime());
        Hashtable<String, UnmodifiableDate> tmpOutDates = new Hashtable<String, UnmodifiableDate>();
        c.clear();
        c.set(2008, 6, 1);
        tmpOutDates.put(DIGEST_ALGORITHM_SHA1, new UnmodifiableDate(c.getTime()));
        tmpOutDates.put(SIGNATURE_ALGORITHM_RSA_SHA1, new UnmodifiableDate(c.getTime()));
        c.clear();
        c.set(2011, 0, 1);
        tmpOutDates.put(DIGEST_ALGORITHM_RIPEMD160, new UnmodifiableDate(c.getTime()));
        tmpOutDates.put(SIGNATURE_ALGORITHM_RSA_RIPEMD160, new UnmodifiableDate(c.getTime()));
        tmpOutDates.put(SIGNATURE_ALGORITHM_RSA_RIPEMD160_RFC4051, new UnmodifiableDate(c.getTime()));
        OUT_DATES = new UnmodifiableHashtable<String, Date>(tmpOutDates);
    }

    private static class UnmodifiableHashtable<K, V>
    extends Hashtable<K, V> {
        private static final long serialVersionUID = 1L;
        private final boolean initialized;

        public UnmodifiableHashtable(Map<? extends K, ? extends V> m) {
            super(m);
            this.initialized = true;
        }

        @Override
        public synchronized V put(K key, V value) {
            if (this.initialized) {
                throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
            }
            return super.put(key, value);
        }

        @Override
        public synchronized void putAll(Map<? extends K, ? extends V> t) {
            if (this.initialized) {
                throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
            }
            super.putAll(t);
        }

        @Override
        public synchronized V remove(Object key) {
            if (this.initialized) {
                throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
            }
            return super.remove(key);
        }

        @Override
        public synchronized void clear() {
            if (this.initialized) {
                throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
            }
            super.clear();
        }
    }

    private static class UnmodifiableDate
    extends Date {
        private UnmodifiableDate(Date origin) {
            super(origin.getTime());
        }

        @Override
        public final void setYear(int year) {
            throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
        }

        @Override
        public final void setMonth(int month) {
            throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
        }

        @Override
        public final void setDate(int date) {
            throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
        }

        @Override
        public final void setHours(int hours) {
            throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
        }

        @Override
        public final void setMinutes(int minutes) {
            throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
        }

        @Override
        public final void setSeconds(int seconds) {
            throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
        }

        @Override
        public final void setTime(long time) {
            throw new UnsupportedOperationException(LanguageTextEntries.modification_not_supported.name());
        }
    }

    public static enum LanguageTextEntries {
        missing_entry,
        invalid_firstargument,
        invalid_secondargument,
        invalid_thirdargument,
        invalid_fourthargument,
        warning_iv_length,
        unexpected_entry,
        modification_not_supported;

    }

    public static enum Namespaces {
        SOAP("http://schemas.xmlsoap.org/soap/envelope/", "soap"),
        OSCI("http://www.osci.de/2002/04/osci", "osci"),
        OSCI2017("http://xoev.de/transport/osci12/7", "osci2017"),
        OSCI128("http://xoev.de/transport/osci12/8", "osci128"),
        XML_SIG("http://www.w3.org/2000/09/xmldsig#", "ds"),
        XML_ENC("http://www.w3.org/2001/04/xmlenc#", "xenc"),
        XML_SCHEMA("http://www.w3.org/2001/XMLSchema-instance", "xsi");

        private String uri;
        private String prefix;

        private Namespaces(String uri, String prefix) {
            this.uri = uri;
            this.prefix = prefix;
        }

        public String getUri() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static enum HeaderTags {
        ControlBlock("ControlBlock", Namespaces.OSCI),
        ClientSignature("ClientSignature", Namespaces.OSCI),
        SupplierSignature("SupplierSignature", Namespaces.OSCI),
        DesiredLanguages("DesiredLanguages", Namespaces.OSCI),
        IntermediaryCertificates("IntermediaryCertificates", Namespaces.OSCI),
        QualityOfTimestamp("QualityOfTimestamp", Namespaces.OSCI),
        NonIntermediaryCertificates("NonIntermediaryCertificates", Namespaces.OSCI),
        acceptDelivery("acceptDelivery", Namespaces.OSCI),
        fetchDelivery("fetchDelivery", Namespaces.OSCI),
        processDelivery("processDelivery", Namespaces.OSCI),
        responseToExitDialog("responseToExitDialog", Namespaces.OSCI),
        responseToFetchDelivery("responseToFetchDelivery", Namespaces.OSCI),
        mediateDelivery("mediateDelivery", Namespaces.OSCI),
        responseToMediateDelivery("responseToMediateDelivery", Namespaces.OSCI),
        storeDelivery("storeDelivery", Namespaces.OSCI),
        responseToStoreDelivery("responseToStoreDelivery", Namespaces.OSCI),
        fetchProcessCard("fetchProcessCard", Namespaces.OSCI),
        responseToFetchProcessCard("responseToFetchProcessCard", Namespaces.OSCI),
        forwardDelivery("forwardDelivery", Namespaces.OSCI),
        responseToForwardDelivery("responseToForwardDelivery", Namespaces.OSCI),
        responseToAcceptDelivery("responseToAcceptDelivery", Namespaces.OSCI),
        responseToProcessDelivery("responseToProcessDelivery", Namespaces.OSCI),
        FeatureDescription("FeatureDescription", Namespaces.OSCI2017),
        partialStoreDelivery("partialStoreDelivery", Namespaces.OSCI2017),
        responseToPartialStoreDelivery("responseToPartialStoreDelivery", Namespaces.OSCI2017),
        partialFetchDelivery("partialFetchDelivery", Namespaces.OSCI2017),
        responseToPartialFetchDelivery("responseToPartialFetchDelivery", Namespaces.OSCI2017);

        private String elementName;
        private Namespaces namespace;

        private HeaderTags(String elementName, Namespaces namespace) {
            this.elementName = elementName;
            this.namespace = namespace;
        }

        public String getElementName() {
            return this.elementName;
        }

        public Namespaces getNamespace() {
            return this.namespace;
        }
    }

    public static enum CommonTags {
        ContentPackage("ContentPackage", Namespaces.OSCI),
        ProcessCardBundle("ProcessCardBundle", Namespaces.OSCI),
        ReplyProcessCardBundle("ReplyProcessCardBundle", Namespaces.OSCI),
        RequestProcessCardBundle("RequestProcessCardBundle", Namespaces.OSCI),
        Feedback("Feedback", Namespaces.OSCI),
        MessageId("MessageId", Namespaces.OSCI),
        ChunkInformation("ChunkInformation", Namespaces.OSCI2017),
        InsideFeedback("InsideFeedback", Namespaces.OSCI2017);

        private String elementName;
        private Namespaces namespace;

        private CommonTags(String elementName, Namespaces namespace) {
            this.elementName = elementName;
            this.namespace = namespace;
        }

        public String getElementName() {
            return this.elementName;
        }

        public Namespaces getNamespace() {
            return this.namespace;
        }
    }

    public static enum OSCIFeatures {
        DisableBase64("1.2.0"),
        OAEPEncryption("1.6.0"),
        SHA3HashAlgo("1.6.3"),
        GCMPaddingModus("1.7.0"),
        PartialMessageTransmission("1.8.0"),
        Support96Bit12ByteIV("1.9.0");

        private String version;

        private OSCIFeatures(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static enum TextProperties {
        UnexpectedEntry(LanguageTextEntries.unexpected_entry.name());

        private String textProperty;

        private TextProperties(String textProp) {
            this.textProperty = textProp;
        }

        public String getTextProperty() {
            return this.textProperty;
        }
    }

    public static enum SystemProperties {
        GCMAlgorithmOnly("de.osci.GCMAlgorithmOnly"),
        SecureContentDataCheck("de.osci.SecureContentDataCheck"),
        SecureTransportDataCheck("de.osci.SecureTransportDataCheck"),
        SwitchToGCM("de.osci.SwitchToGCM");

        private String property;

        private SystemProperties(String property) {
            this.property = property;
        }

        public String getPropertyValue() {
            return this.property;
        }
    }
}

