/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.helper.Base64;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Tools {
    private static Log log = LogFactory.getLog(Tools.class);
    private static SecureRandom random;
    private static CertificateFactory factory;
    private static final String TYPE = "X.509";

    public static boolean compareByteArrays(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static X509Certificate createCertificate(InputStream certificate) throws CertificateException {
        try {
            X509Certificate ret;
            if (certificate == null && log.isDebugEnabled()) {
                log.debug((Object)"Kein Input Stream");
            }
            if (factory == null) {
                factory = DialogHandler.getSecurityProvider() == null ? CertificateFactory.getInstance(TYPE) : CertificateFactory.getInstance(TYPE, DialogHandler.getSecurityProvider());
            }
            if ((ret = (X509Certificate)factory.generateCertificate(certificate)) == null) {
                throw new CertificateException(DialogHandler.text.getString("cert_gen_error"));
            }
            return ret;
        }
        catch (CertificateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)"Fehler: ", (Throwable)ex);
            throw new CertificateException(DialogHandler.text.getString("cert_gen_error"));
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] bytes = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
            int count = 0;
            while ((count = in.read(bytes)) > -1) {
                bos.write(bytes, 0, count);
            }
            in.close();
            return bos.toByteArray();
        }
        catch (IOException ex) {
            log.error((Object)"Fehler beim einlesen des Streams.");
            throw ex;
        }
    }

    public static X509Certificate createCertificate(byte[] certificate) throws CertificateException {
        try {
            if (factory == null) {
                factory = DialogHandler.getSecurityProvider() == null ? CertificateFactory.getInstance(TYPE) : CertificateFactory.getInstance(TYPE, DialogHandler.getSecurityProvider());
            }
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certificate));
        }
        catch (CertificateException ex) {
            log.error((Object)("Fehler Certifikate konnte nicht erstellt werden. Bytes: " + new String(certificate)));
            throw ex;
        }
        catch (Exception ex) {
            throw new CertificateException(DialogHandler.text.getString("cert_gen_error"));
        }
    }

    public static String createRandom(int length) throws NoSuchAlgorithmException {
        try {
            return Base64.encode(Tools.createRawRandom(length));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] createRawRandom(int length) throws NoSuchAlgorithmException {
        if (random == null) {
            try {
                random = SecureRandom.getInstance(DialogHandler.getSecureRandomAlgorithm(), DialogHandler.getSecurityProvider());
            }
            catch (NoSuchAlgorithmException nsae) {
                random = SecureRandom.getInstance(DialogHandler.getSecureRandomAlgorithm());
            }
        }
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }
}

