/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.helper.ParserHelper;
import de.osci.helper.Tools;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.Crypto;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SymCipherOutputStream
extends FilterOutputStream {
    private static Log log = LogFactory.getLog(SymCipherOutputStream.class);
    private Cipher cipher;
    private int index = 0;
    private byte[] iv;
    private SecretKey symKey;
    private boolean encrypt;
    private byte[] tmp;

    @Deprecated(since="1.8")
    public SymCipherOutputStream(OutputStream outStream, SecretKey symKey, boolean encrypt) throws IOException {
        this(outStream, symKey, Crypto.getCipherAlgoID(symKey), encrypt, 12, null);
    }

    public SymCipherOutputStream(OutputStream outStream, SecretKey symKey, String symAlgorithm, int ivLength, byte[] iv) throws IOException {
        this(outStream, symKey, symAlgorithm, true, ivLength, iv);
    }

    @Deprecated(since="1.8")
    public SymCipherOutputStream(OutputStream outStream, boolean encrypt) throws IOException, NoSuchAlgorithmException {
        this(outStream, DialogHandler.getTempSymKey(), "http://www.w3.org/2009/xmlenc11#aes256-gcm", encrypt, 12, null);
    }

    public SymCipherOutputStream(OutputStream outStream, SecretKey symKey, String symAlgorithm, boolean encrypt) throws IOException {
        this(outStream, symKey, symAlgorithm, encrypt, 12, null);
    }

    public SymCipherOutputStream(OutputStream outStream, SecretKey symKey, String symAlgorithm, int ivLength, boolean encrypt) throws IOException {
        this(outStream, symKey, symAlgorithm, encrypt, ivLength, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SymCipherOutputStream(OutputStream outStream, SecretKey symKey, String symAlgorithm, boolean encrypt, int ivLength, byte[] iv) throws IOException {
        super(outStream);
        this.symKey = symKey;
        this.encrypt = encrypt;
        if (symAlgorithm.endsWith("-cbc")) {
            if (ParserHelper.isGCMAlgorithmOnly()) {
                throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_thirdargument.name()) + " Wrong algorithm! only GCM supported! Given: " + symAlgorithm);
            }
            log.warn((Object)"CBC will not be supported in the future and is not allowed for transport encryption any longer!");
        }
        try {
            this.cipher = DialogHandler.getSecurityProvider() == null ? Cipher.getInstance(Constants.JCA_JCE_MAP.get(symAlgorithm)) : Cipher.getInstance(Constants.JCA_JCE_MAP.get(symAlgorithm), DialogHandler.getSecurityProvider());
            if (symAlgorithm.endsWith("tripledes-cbc")) {
                this.iv = new byte[8];
            } else if (symAlgorithm.endsWith("-gcm")) {
                if (ivLength != 16 && ivLength != 12) throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_thirdargument.name()) + " Wrong IV length " + ivLength + " given for algorithm " + symAlgorithm);
                log.debug((Object)("Use IV length for outgoing AES-GCM: " + ivLength));
                this.iv = new byte[ivLength];
                if (ivLength == 16) {
                    log.warn((Object)DialogHandler.text.getString(Constants.LanguageTextEntries.warning_iv_length.name()));
                }
            } else {
                this.iv = new byte[16];
            }
            if (!encrypt) return;
            if (iv == null) {
                this.iv = Tools.createRawRandom(this.iv.length);
            } else {
                System.arraycopy(iv, 0, this.iv, 0, this.iv.length);
            }
            IvParameterSpec algoParamSpec = new IvParameterSpec(this.iv);
            this.cipher.init(1, (Key)symKey, algoParamSpec);
            outStream.write(this.iv);
            return;
        }
        catch (GeneralSecurityException ex) {
            if (encrypt) {
                log.warn((Object)"Exception at encryption", (Throwable)ex);
                throw new IOException(DialogHandler.text.getString("encryption_error"));
            }
            log.warn((Object)"Exception at decryption", (Throwable)ex);
            throw new IOException(DialogHandler.text.getString("decryption_error"));
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.encrypt && this.index < this.iv.length) {
            if (len < this.iv.length - this.index) {
                for (int i = 0; i < len; ++i) {
                    this.iv[this.index++] = b[off + i];
                }
                return;
            } else {
                int i;
                for (i = 0; i < this.iv.length - this.index; ++i) {
                    this.iv[i + this.index] = b[off + i];
                }
                this.index += i;
                try {
                    IvParameterSpec algoParamSpec = new IvParameterSpec(this.iv);
                    this.cipher.init(2, (Key)this.symKey, algoParamSpec);
                    this.tmp = this.cipher.update(b, off + i, len - i);
                    if (this.tmp == null) return;
                    this.out.write(this.tmp);
                    return;
                }
                catch (Exception ex) {
                    throw new IOException(DialogHandler.text.getString("decryption_error"));
                }
            }
        } else {
            if (b.length <= 0) return;
            this.tmp = this.cipher.update(b, off, len);
            if (this.tmp == null) return;
            this.out.write(this.tmp);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.write(this.cipher.doFinal());
        }
        catch (Exception ex) {
            if (this.encrypt) {
                throw new IOException(DialogHandler.text.getString("encryption_error"));
            }
            throw new IOException(DialogHandler.text.getString("decryption_error"));
        }
        this.out.flush();
    }

    public byte[] getIv() {
        return this.iv;
    }
}

