/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.helper.MIMEPartInputStream;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MIMEParser {
    private static Log log = LogFactory.getLog(MIMEParser.class);
    public static final int MAX_LINE_SIZE = 0x100000;
    InputStream in;
    private MIMEPartInputStream currentStream;
    public String boundary;
    byte[] buffer;
    int bufferPointer;
    private static final String CONTENT_TYPE = "content-type";

    public MIMEParser(InputStream in) throws IOException {
        this.in = in;
        Hashtable<String, String> header = this.readHeaders();
        if (header == null || header.get("mime-version") != null && !header.get("mime-version").equals("1.0")) {
            throw new IOException(DialogHandler.text.getString("msg_format_error"));
        }
        Hashtable<String, String> contentType = this.parseHeader(CONTENT_TYPE, header.get(CONTENT_TYPE));
        this.boundary = contentType.get("boundary");
        if (this.boundary == null) {
            throw new IOException(DialogHandler.text.getString("msg_format_error"));
        }
    }

    public MIMEPartInputStream getNextStream() throws IOException {
        String contentLength;
        String charset;
        String bound;
        long length = -1L;
        while ((bound = this.readLine()) != null && bound.trim().equals("")) {
        }
        if (("--" + this.boundary + "--").equals(bound)) {
            byte[] tmp = new byte[Constants.DEFAULT_BUFFER_BLOCKSIZE];
            while (this.in.read(tmp) > -1) {
            }
            this.in.close();
            return null;
        }
        if (!("--" + this.boundary).equals(bound)) {
            throw new IOException(DialogHandler.text.getString("msg_format_error"));
        }
        Hashtable<String, String> header = this.readHeaders();
        if (header == null) {
            this.in.close();
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("header: " + header));
        }
        if (header.get(CONTENT_TYPE) == null) {
            throw new IOException(DialogHandler.text.getString("msg_format_error"));
        }
        Hashtable<String, String> cntTyp = this.parseHeader(CONTENT_TYPE, header.get(CONTENT_TYPE));
        String contentType = cntTyp.get(CONTENT_TYPE);
        if (cntTyp.get("charset") != null && !(charset = cntTyp.get("charset")).equalsIgnoreCase(Constants.CHAR_ENCODING)) {
            throw new IllegalArgumentException(DialogHandler.text.getString("invalid_charset") + charset);
        }
        String encoding = header.get("content-transfer-encoding");
        String contentID = header.get("content-id");
        if (contentID.startsWith("<")) {
            contentID = contentID.substring(1, contentID.length() - 1);
        }
        if ((contentLength = header.get("content-length")) != null) {
            length = Long.parseLong(contentLength);
        }
        this.currentStream = new MIMEPartInputStream(this, contentType, encoding, contentID, length);
        this.currentStream.mime_headers = header;
        return this.currentStream;
    }

    private Hashtable<String, String> readHeaders() throws IOException {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        String nextHeader = null;
        try {
            Object header;
            while (((String)(header = this.readLine().trim())).equals("")) {
            }
            while (!((String)header).equals("")) {
                try {
                    nextHeader = this.readLine();
                    while (!nextHeader.isEmpty() && Character.isWhitespace(nextHeader.charAt(0))) {
                        header = (String)header + nextHeader;
                        nextHeader = this.readLine();
                    }
                    headers.put(((String)header).substring(0, ((String)header).indexOf(58)).toLowerCase().trim(), ((String)header).substring(((String)header).indexOf(58) + 1).trim());
                    header = nextHeader.trim();
                }
                catch (StringIndexOutOfBoundsException ex) {
                    log.warn((Object)"unexpected mime structure!");
                    if (nextHeader == null) continue;
                    header = nextHeader.trim();
                }
            }
        }
        catch (NullPointerException ex) {
            log.warn((Object)"unexpected mime structure!");
            return null;
        }
        if (headers.isEmpty()) {
            log.debug((Object)"\n\nKEIN HEADER !!");
            return null;
        }
        return headers;
    }

    private Hashtable<String, String> parseHeader(String fieldName, String header) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        StringTokenizer ct = new StringTokenizer(header, "; ");
        params.put(fieldName, ct.nextToken().trim());
        while (ct.hasMoreTokens()) {
            String[] tmp = ct.nextToken().split("=", 2);
            if (tmp.length <= 1) continue;
            if (tmp[1].startsWith("\"") && tmp[1].endsWith("\"")) {
                tmp[1] = tmp[1].substring(1, tmp[1].length() - 1);
            }
            params.put(tmp[0].trim(), tmp[1].trim());
        }
        return params;
    }

    private String readLine() throws IOException {
        int b = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean end = false;
        long counter = 0L;
        while (!end) {
            b = this.readFromInput();
            if (b == -1) {
                return null;
            }
            if (b == 13) {
                b = this.readFromInput();
                if (b == 10) {
                    end = true;
                } else if (Character.isWhitespace((char)b)) continue;
            }
            if (!end) {
                baos.write(b);
            }
            if (++counter < 0x100000L) continue;
            log.warn((Object)"Zeile hat Laenge von 1048576 erreicht, Lesen der Zeile abbrechen");
            throw new IOException(DialogHandler.text.getString("msg_format_error"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ZEILE mit Laenge " + counter + ": " + baos.toString(Constants.CHARSET_ENCODING)));
        }
        return baos.toString(Constants.CHARSET_ENCODING);
    }

    private int readFromInput() throws IOException {
        int j = 0;
        if (this.buffer != null && this.bufferPointer < this.buffer.length) {
            j = this.buffer[this.bufferPointer++];
            if (this.bufferPointer >= this.buffer.length) {
                this.buffer = null;
                this.bufferPointer = 0;
            }
        } else {
            j = this.in.read();
        }
        return j;
    }
}

