/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ISO8601DateTimeFormat
extends DateFormat {
    public ISO8601DateTimeFormat() {
        this.setCalendar(Calendar.getInstance());
    }

    public ISO8601DateTimeFormat(TimeZone tz) {
        this.setCalendar(Calendar.getInstance(tz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date parse(String text, ParsePosition pos) {
        int i = pos.getIndex();
        try {
            int year = Integer.valueOf(text.substring(i, i + 4));
            if (text.charAt(i += 4) != '-') {
                throw new NumberFormatException();
            }
            int month = Integer.valueOf(text.substring(++i, i + 2)) - 1;
            if (text.charAt(i += 2) != '-') {
                throw new NumberFormatException();
            }
            int day = Integer.valueOf(text.substring(++i, i + 2));
            if (text.charAt(i += 2) != 'T') {
                throw new NumberFormatException();
            }
            int hour = Integer.valueOf(text.substring(++i, i + 2));
            if (text.charAt(i += 2) != ':') {
                throw new NumberFormatException();
            }
            int mins = Integer.valueOf(text.substring(++i, i + 2));
            int secs = 0;
            if ((i += 2) < text.length() && text.charAt(i) == ':') {
                secs = Integer.valueOf(text.substring(++i, i + 2));
                i += 2;
            }
            this.calendar.set(year, month, day, hour, mins, secs);
            int ms = 0;
            if (text.charAt(i) == '.') {
                int start = ++i;
                while (i < text.length() && Character.isDigit(text.charAt(i))) {
                    ++i;
                }
                ms = Integer.parseInt(text.substring(start, i));
                if (i - start == 1) {
                    ms *= 100;
                } else if (i - start == 2) {
                    ms *= 10;
                } else if (i - start > 3) {
                    throw new NumberFormatException("Too many milliseconds.");
                }
            }
            this.calendar.set(14, ms);
            i = this.parseTZ(i, text);
        }
        catch (NumberFormatException ex) {
            pos.setErrorIndex(i);
            Date date = null;
            return date;
        }
        catch (IndexOutOfBoundsException ex) {
            pos.setErrorIndex(i);
            Date date = null;
            return date;
        }
        finally {
            pos.setIndex(i);
        }
        return this.calendar.getTime();
    }

    protected int parseTZ(int i, String text) throws NumberFormatException {
        if (i < text.length()) {
            int offset = 0;
            if (text.charAt(i) == 'Z') {
                offset = 0;
                ++i;
            } else {
                int sign = 1;
                if (text.charAt(i) == '-') {
                    sign = -1;
                } else if (text.charAt(i) != '+') {
                    throw new NumberFormatException();
                }
                int offset_h = Integer.valueOf(text.substring(++i, i + 2));
                if (text.charAt(i += 2) != ':') {
                    throw new NumberFormatException();
                }
                int offset_min = Integer.valueOf(text.substring(++i, i + 2));
                i += 2;
                offset = (offset_h * 60 + offset_min) * 60000 * sign;
            }
            int offset_cal = this.calendar.get(15) + this.calendar.get(16);
            this.calendar.add(14, offset_cal - offset);
        }
        return i;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer sbuf, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        this.writeCCYYMM(sbuf);
        sbuf.append('T');
        this.writehhmmss(sbuf);
        this.writeTZ(sbuf);
        return sbuf;
    }

    protected void writeTZ(StringBuffer sbuf) {
        int offset = this.calendar.get(15) + this.calendar.get(16);
        if (offset == 0) {
            sbuf.append('Z');
        } else {
            int offset_h = offset / 3600000;
            int offset_min = offset % 3600000 / 60000;
            if (offset >= 0) {
                sbuf.append('+');
            } else {
                sbuf.append('-');
                offset_h = 0 - offset_h;
                offset_min = 0 - offset_min;
            }
            this.appendInt(sbuf, offset_h, 2);
            sbuf.append(':');
            this.appendInt(sbuf, offset_min, 2);
        }
    }

    protected void writehhmmss(StringBuffer sbuf) {
        int hour = this.calendar.get(11);
        this.appendInt(sbuf, hour, 2);
        sbuf.append(':');
        int mins = this.calendar.get(12);
        this.appendInt(sbuf, mins, 2);
        sbuf.append(':');
        int secs = this.calendar.get(13);
        this.appendInt(sbuf, secs, 2);
    }

    protected void writeCCYYMM(StringBuffer sbuf) {
        String month;
        int year = this.calendar.get(1);
        this.appendInt(sbuf, year, 4);
        switch (this.calendar.get(2)) {
            case 0: {
                month = "-01-";
                break;
            }
            case 1: {
                month = "-02-";
                break;
            }
            case 2: {
                month = "-03-";
                break;
            }
            case 3: {
                month = "-04-";
                break;
            }
            case 4: {
                month = "-05-";
                break;
            }
            case 5: {
                month = "-06-";
                break;
            }
            case 6: {
                month = "-07-";
                break;
            }
            case 7: {
                month = "-08-";
                break;
            }
            case 8: {
                month = "-09-";
                break;
            }
            case 9: {
                month = "-10-";
                break;
            }
            case 10: {
                month = "-11-";
                break;
            }
            case 11: {
                month = "-12-";
                break;
            }
            default: {
                month = "-NA-";
            }
        }
        sbuf.append(month);
        int day = this.calendar.get(5);
        this.appendInt(sbuf, day, 2);
    }

    protected void appendInt(StringBuffer buf, int value, int length) {
        int len2;
        int len1 = buf.length();
        buf.append(value);
        for (int i = len2 = buf.length(); i < len1 + length; ++i) {
            buf.insert(len1, '0');
        }
    }
}

