/*
 * Decompiled with CFR 0.152.
 */
package de.osci.helper;

import de.osci.helper.Canonizer;
import de.osci.helper.Tools;
import eu.osci.ws._2014._10.transport.MessageMetaData;
import eu.osci.ws._2014._10.transport.ObjectFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class CustomHeaderHelper {
    private static Log log = LogFactory.getLog(CustomHeaderHelper.class);
    private static JAXBContext jaxbContext;
    private static final XMLInputFactory XML_INPUT_FACTORY;
    public static final String MESSAGE_META_DATA_ID = "MetaData";
    private static final String OSCI_NAMESPACE = " xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:osci=\"http://www.osci.de/2002/04/osci\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";

    private CustomHeaderHelper() {
    }

    public static String addIdToCustomHeader(String customHeaderXml, String id) {
        customHeaderXml = customHeaderXml.substring(customHeaderXml.indexOf(">") + 1);
        int start = customHeaderXml.indexOf(">");
        return customHeaderXml.substring(0, start).concat(" Id=\"" + id + "\"").concat(customHeaderXml.substring(start));
    }

    public static String makeOSCICustomHeader(String customHeaderXml) {
        int startAfterTag = customHeaderXml.indexOf(">");
        String osciCustomHeaderXml = customHeaderXml.substring(0, startAfterTag).concat(OSCI_NAMESPACE).concat(customHeaderXml.substring(startAfterTag));
        Canonizer can = null;
        try {
            can = new Canonizer(new ByteArrayInputStream(osciCustomHeaderXml.getBytes(StandardCharsets.UTF_8)), null);
            return new String(Tools.readBytes(can), StandardCharsets.UTF_8);
        }
        catch (IOException | NoSuchAlgorithmException | ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException("Error when canonizing custom header: " + e.getMessage());
        }
    }

    public static String makeOSCICustomHeaderWithId(String customHeaderXml, String id) {
        return CustomHeaderHelper.makeOSCICustomHeader(CustomHeaderHelper.addIdToCustomHeader(customHeaderXml, id));
    }

    public static String getMessageMetaDataAsCustomHeader(MessageMetaData mmd) {
        String mmdOsciString = "";
        String mmdStringWithId = CustomHeaderHelper.addIdToCustomHeader(CustomHeaderHelper.getMessageMetaDataAsString(mmd), MESSAGE_META_DATA_ID);
        mmdOsciString = CustomHeaderHelper.makeOSCICustomHeader(mmdStringWithId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("get MessageMetaData: " + mmdOsciString));
        }
        return mmdOsciString;
    }

    public static String getMessageMetaDataStringAsCustomHeader(String mmd) {
        String mmdOsciString = "";
        String mmdStringWithId = CustomHeaderHelper.addIdToCustomHeader(mmd, MESSAGE_META_DATA_ID);
        mmdOsciString = CustomHeaderHelper.makeOSCICustomHeader(mmdStringWithId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("get MessageMetaData: " + mmdOsciString));
        }
        return mmdOsciString;
    }

    public static String getMessageMetaDataAsString(MessageMetaData mmd) {
        String mmdString = "";
        try {
            ByteArrayOutputStream streamMMD = new ByteArrayOutputStream();
            jaxbContext.createMarshaller().marshal((Object)mmd, (OutputStream)streamMMD);
            mmdString = new String(streamMMD.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            log.warn((Object)"Could not add messageMetaData!", (Throwable)ex);
        }
        return mmdString;
    }

    public static MessageMetaData readMessageMetaDataFromOsciString(String customHeaderString) {
        MessageMetaData messageMetaData;
        StringReader in = new StringReader(customHeaderString);
        try {
            messageMetaData = (MessageMetaData)jaxbContext.createUnmarshaller().unmarshal(XML_INPUT_FACTORY.createXMLStreamReader(in));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                log.warn((Object)"Could not parse messageMetaData", (Throwable)ex);
                return null;
            }
        }
        ((Reader)in).close();
        return messageMetaData;
    }

    static {
        XML_INPUT_FACTORY = XMLInputFactory.newFactory();
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            XML_INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", false);
        }
        catch (JAXBException e) {
            log.error((Object)"Cannot create JAXB Context for MessageMetaData, handling MessageMetaData will be impossible", (Throwable)e);
        }
    }
}

