/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.cryptohost.model;

import de.governikus.csc.cryptohost.model.ResourceReferenceDTO;
import de.governikus.csl.uom.res.AbstractResourceReference;
import de.governikus.csl.uom.res.PrivateKeyResourceReference;
import java.util.Arrays;

public class SignRequestDTO
extends ResourceReferenceDTO {
    String digestAlgorithmURI;
    byte[] digestValue;
    String signatureAlgorithmURI;

    public SignRequestDTO() {
    }

    public SignRequestDTO(String id, AbstractResourceReference resourceReference, String signatureAlgorithmURI, String digestAlgorithmURI, byte[] digestValue) {
        super(id, resourceReference);
        this.setSignatureAlgorithmURI(signatureAlgorithmURI);
        this.setDigestAlgorithmURI(digestAlgorithmURI);
        this.setDigestValue(digestValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        SignRequestDTO other = (SignRequestDTO)obj;
        if (this.digestAlgorithmURI == null ? other.digestAlgorithmURI != null : !this.digestAlgorithmURI.equals(other.digestAlgorithmURI)) {
            return false;
        }
        if (!Arrays.equals(this.digestValue, other.digestValue)) {
            return false;
        }
        return !(this.signatureAlgorithmURI == null ? other.signatureAlgorithmURI != null : !this.signatureAlgorithmURI.equals(other.signatureAlgorithmURI));
    }

    public String getDigestAlgorithmURI() {
        return this.digestAlgorithmURI;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }

    public PrivateKeyResourceReference getResourceReference() {
        return (PrivateKeyResourceReference)super.getResourceReference();
    }

    public String getSignatureAlgorithmURI() {
        return this.signatureAlgorithmURI;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.digestAlgorithmURI == null ? 0 : this.digestAlgorithmURI.hashCode());
        result = 31 * result + Arrays.hashCode(this.digestValue);
        result = 31 * result + (this.signatureAlgorithmURI == null ? 0 : this.signatureAlgorithmURI.hashCode());
        return result;
    }

    public void setDigestAlgorithmURI(String digestAlgorithmURI) {
        this.digestAlgorithmURI = digestAlgorithmURI;
    }

    public void setDigestValue(byte[] dataToBeSign) {
        this.digestValue = dataToBeSign;
    }

    public void setSignatureAlgorithmURI(String signatureAlgorithmURI) {
        this.signatureAlgorithmURI = signatureAlgorithmURI;
    }
}

