/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.cryptohost.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.governikus.csl.uom.res.PrivateKeyResourceReference;
import de.governikus.csl.uom.res.ResourceReference;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceReferenceStdSerializer
extends StdSerializer<ResourceReference> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceReferenceStdSerializer.class);
    private static final long serialVersionUID = 1L;

    public ResourceReferenceStdSerializer() {
        this(null);
    }

    public ResourceReferenceStdSerializer(Class<ResourceReference> t) {
        super(t);
    }

    public void serialize(ResourceReference value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        LOG.debug("############################################################# serialize --- provider : {}", (Object)provider);
        PrivateKeyResourceReference privateKeyResourceReference = (PrivateKeyResourceReference)value;
        jgen.writeStartObject();
        jgen.writeStringField("name", privateKeyResourceReference.getName());
        jgen.writeStringField("id", privateKeyResourceReference.getId());
        jgen.writeObjectField("type", (Object)privateKeyResourceReference.getType());
        jgen.writeObjectField("areaType", (Object)privateKeyResourceReference.getAreaType());
        jgen.writeObjectField("componentType", (Object)privateKeyResourceReference.getComponentType());
        jgen.writeObjectField("algorithm", (Object)privateKeyResourceReference.getAlgorithm());
        jgen.writeObjectField("format", (Object)privateKeyResourceReference.getFormat());
        jgen.writeObjectField("state", (Object)privateKeyResourceReference.getState());
        jgen.writeObjectField("certificateChain", (Object)privateKeyResourceReference.getCertificateChain());
        jgen.writeObjectField("supportedAlgorithms", (Object)privateKeyResourceReference.getKeyFunctionSupportedAlgorithms());
        jgen.writeEndObject();
    }

    public void add(ArrayNode nodes, ResourceReference value) {
    }
}

