/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.util;

import de.governikus.csl.uom.sign.props.AnySignedProperty;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.signature.ObjectContainer;
import org.etsi.uri._01903.v1_3.AnyType;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._01903.v1_3.ObjectIdentifierType;
import org.etsi.uri._01903.v1_3.QualifyingPropertiesType;
import org.etsi.uri._01903.v1_4.ValidationDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig.DigestMethodType;
import org.w3._2000._09.xmldsig.ObjectFactory;
import org.w3._2000._09.xmldsig.ObjectType;
import org.w3._2000._09.xmldsig.SignatureType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLToolkit {
    public static final String XPATH_DOC_ROOT = "/*";
    public static final String XPATH_PARENT = "/parent::*";
    public static final String XPATH_FIRST_CHILD = "/child::*[position()=1]";
    public static final String XPATH_INSERT_BEFORE_LAST_SELECTED_CHILD_SUFFIX = "/parent::*";
    private static final String MIMETYPE_APPLICATION_XML = "application/xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLToolkit.class);
    public static final String XPATH_EXPRESSION_XMLDSIG_SIGNATURE_NODES = "//ds:Signature";
    public static final String XPATH_EXPRESSION_XADES_QUALIFYING_RPOPERTIES = "//xades:QualifyingProperties";
    public static final String XADES_NAMESPACE_1_3_2 = "http://uri.etsi.org/01903/v1.3.2#";
    public static final String XADES_NAMESPACE_1_4_1 = "http://uri.etsi.org/01903/v1.4.1#";
    public static final String XADES_NAMESPACE_1_4_2 = "http://uri.etsi.org/01903/v1.4.2#";
    public static final NamespaceContext XMLDSIG_CONTEXT = new NamespaceContextImpl();
    public static final NamespaceContext XADES132_CONTEXT = new NamespaceContextImpl("http://uri.etsi.org/01903/v1.3.2#", "xades");
    public static final NamespaceContext XADES141_CONTEXT = new NamespaceContextImpl("http://uri.etsi.org/01903/v1.4.1#", "xadesv141");
    public static final NamespaceContext XADES142_CONTEXT = new NamespaceContextImpl("http://uri.etsi.org/01903/v1.4.2#", "xadesv142");
    private static final String XSD_TYPE = "Type";
    private static final String XSD_LIST_TYPE = "ListType";
    private static final String SEPARATOR_XML_ID = "-";

    public static byte[] read(InputStream is) throws IOException {
        byte[] buffer = new byte[4096];
        int r = 0;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            while ((r = is.read(buffer)) > 0) {
                baos.write(buffer, 0, r);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private XMLToolkit() {
    }

    public static List<String> getIds(Document w3Document) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nodes = XMLToolkit.getNodes(w3Document, "//@Id", null);
        for (int i = 0; i < nodes.getLength(); ++i) {
            result.add(nodes.item(i).getNodeValue());
        }
        return result;
    }

    public static NodeList getNodes(Document d, String xpathString, NamespaceContext nc) {
        return XMLToolkit.getNodes(d.getDocumentElement(), xpathString, nc);
    }

    public static NodeList getNodes(Node n, String xpathString, NamespaceContext nc) {
        try {
            XPathFactory xf = XPathFactory.newInstance();
            XPath xp = xf.newXPath();
            if (nc != null) {
                xp.setNamespaceContext(nc);
            }
            NodeList sigNodes = (NodeList)xp.compile(xpathString).evaluate(n, XPathConstants.NODESET);
            return sigNodes;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static ObjectIdentifierType createObjectIdentifier(AnySignedProperty<String> identifier, String localNodeName) throws JAXBException, ParserConfigurationException, Exception {
        Node node = identifier.getAnyNode();
        if (XADES_NAMESPACE_1_3_2.equals(node.getNamespaceURI()) && "ObjectIdentifier".equals(node.getLocalName())) {
            return XMLToolkit.nodeToJAXB(ObjectIdentifierType.class, node, new String[0]);
        }
        if (XADES_NAMESPACE_1_3_2.equals(node.getNamespaceURI()) && localNodeName.equals(node.getLocalName())) {
            node.getOwnerDocument().renameNode(node, XADES_NAMESPACE_1_3_2, "ObjectIdentifier");
            return XMLToolkit.nodeToJAXB(ObjectIdentifierType.class, node, new String[0]);
        }
        return null;
    }

    public static DigestAlgAndValueType createDigestAlgAndValueType(String digestAlgorithmURI, byte[] digestValue) {
        org.etsi.uri._01903.v1_3.ObjectFactory xadesV13ObjectFactory = new org.etsi.uri._01903.v1_3.ObjectFactory();
        ObjectFactory xmldsigObjectFactory = new ObjectFactory();
        DigestAlgAndValueType digestAlgAndValueType = xadesV13ObjectFactory.createDigestAlgAndValueType();
        DigestMethodType digestMethod = xmldsigObjectFactory.createDigestMethodType();
        digestMethod.setAlgorithm(digestAlgorithmURI);
        digestAlgAndValueType.setDigestMethod(digestMethod);
        digestAlgAndValueType.setDigestValue(digestValue);
        return digestAlgAndValueType;
    }

    public static AnyType toXAdESAnyType(Node nodeValue) {
        org.etsi.uri._01903.v1_3.ObjectFactory xadesObjectFactory = new org.etsi.uri._01903.v1_3.ObjectFactory();
        AnyType any = xadesObjectFactory.createAnyType();
        any.getContent().add(nodeValue);
        return any;
    }

    public static <J> JAXBElement<J> jaxbToElement(J jaxb) {
        if (jaxb == null) {
            return null;
        }
        Class<?> jaxbClass = jaxb.getClass();
        NamespacePrefixName npn = XMLToolkit.getNamespacePrefixName(jaxbClass);
        QName qName = new QName(npn.namespaceURI, npn.name, npn.prefix);
        return new JAXBElement(qName, jaxbClass, jaxb);
    }

    public static ChangeableNamespaceContext createNamespaceContext(Class<?> ... classes) {
        return XMLToolkit.createNamespaceContext(null, classes);
    }

    public static ChangeableNamespaceContext createNamespaceContext(Document document, Class<?> ... classes) {
        Set<NamespacePrefixName> namespacePrefixNames = XMLToolkit.getNamespacePrefixNames(classes);
        Set<NamespacePrefix> documentNamespacePrefixes = XMLToolkit.getNamespacePrefixes(document);
        return new ChangeableNamespaceContext().addNamespacePrefixNames(namespacePrefixNames).addNamespacePrefixes(documentNamespacePrefixes);
    }

    public static Set<NamespacePrefix> getNamespacePrefixes(Document document) {
        if (document == null || document.getDocumentElement() == null) {
            return null;
        }
        Set<NamespacePrefix> result = XMLToolkit.getNamespacePrefixes(document.getDocumentElement());
        if (document.getPrefix() != null && !document.getPrefix().isEmpty()) {
            result.add(new NamespacePrefix(document.getPrefix(), document.getNamespaceURI()));
        }
        return result;
    }

    public static Set<NamespacePrefix> getNamespacePrefixes(Element element) {
        return XMLToolkit.getNamespacePrefixes((Node)element);
    }

    public static Set<NamespacePrefix> getNamespacePrefixes(Node node) {
        HashSet<NamespacePrefix> result = new HashSet<NamespacePrefix>();
        XMLToolkit.collectNamespacePrefixes(result, node);
        return result;
    }

    private static void collectNamespacePrefixes(Set<NamespacePrefix> result, Node node) {
        NodeList children;
        NamespacePrefix npn = new NamespacePrefix(node.getPrefix(), node.getNamespaceURI());
        if (npn.prefix != null && !npn.prefix.isEmpty()) {
            result.add(npn);
        }
        if ((children = node.getChildNodes()) == null) {
            return;
        }
        int n = children.getLength();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            XMLToolkit.collectNamespacePrefixes(result, children.item(i));
        }
    }

    public static NamespaceContext createNamespaceContextDSigXAdES13XAdES14(Document document) {
        return XMLToolkit.createNamespaceContext(document, QualifyingPropertiesType.class, SignatureType.class, ValidationDataType.class);
    }

    public static Set<NamespacePrefixName> getNamespacePrefixNames(Class<?> ... classes) {
        HashSet<NamespacePrefixName> result = new HashSet<NamespacePrefixName>();
        for (Class<?> clazz : classes) {
            result.add(XMLToolkit.getNamespacePrefixName(clazz));
        }
        return result;
    }

    public static NamespacePrefixName getNamespacePrefixName(Class<?> jaxbClass) {
        NamespacePrefixName result = new NamespacePrefixName();
        XmlType xmlType = jaxbClass.getAnnotation(XmlType.class);
        result.name = xmlType.name();
        if (result.name.endsWith(XSD_LIST_TYPE)) {
            result.name = result.name.substring(0, result.name.length() - XSD_LIST_TYPE.length());
        } else if (result.name.endsWith(XSD_TYPE)) {
            result.name = result.name.substring(0, result.name.length() - XSD_TYPE.length());
        }
        result.namespaceURI = "";
        result.prefix = "";
        try {
            XmlSchema s;
            Class<?> c = Class.forName(jaxbClass.getPackage().getName() + ".package-info");
            if (c != null && (s = c.getAnnotation(XmlSchema.class)) != null) {
                result.namespaceURI = s.namespace();
                XmlNs[] xmlns = s.xmlns();
                if (xmlns != null && xmlns.length > 0) {
                    result.prefix = xmlns[0].prefix();
                }
            }
        }
        catch (Exception e) {
            result.prefix = "";
            result.namespaceURI = xmlType.namespace();
        }
        return result;
    }

    public static <J> J elementToJAXB(Class<J> jaxbClass, javax.lang.model.element.Element element, String ... contexts) throws JAXBException {
        return XMLToolkit.nodeToJAXB(jaxbClass, (Node)((Object)element), contexts);
    }

    public static <J> J documentToJAXB(Class<J> jaxbClass, Document document, String ... contexts) throws JAXBException {
        return XMLToolkit.nodeToJAXB(jaxbClass, document, contexts);
    }

    public static <J> J nodeToJAXB(Class<J> jaxbClass, Node node, String ... contexts) throws JAXBException {
        String contextString = XMLToolkit.createJAXBContextString(jaxbClass, contexts);
        JAXBContext jc = JAXBContext.newInstance((String)contextString);
        Unmarshaller jaxbUnmarshaller = jc.createUnmarshaller();
        Object unmarshalled = jaxbUnmarshaller.unmarshal((Source)new DOMSource(node));
        if (jaxbClass.isInstance(unmarshalled)) {
            return jaxbClass.cast(unmarshalled);
        }
        if (unmarshalled instanceof JAXBElement && jaxbClass.isInstance(unmarshalled = ((JAXBElement)JAXBElement.class.cast(unmarshalled)).getValue())) {
            return jaxbClass.cast(unmarshalled);
        }
        return null;
    }

    public static <J> Document jaxbToDocument(J jaxb, String ... contexts) throws JAXBException, PropertyException {
        JAXBElement<J> jaxbObject = XMLToolkit.jaxbToElement(jaxb);
        if (jaxbObject == null) {
            return null;
        }
        String contextString = XMLToolkit.createJAXBContextString(jaxb.getClass(), contexts);
        JAXBContext jc = JAXBContext.newInstance((String)contextString);
        Marshaller jaxbMarshaller = jc.createMarshaller();
        DOMResult domResult = new DOMResult();
        jaxbMarshaller.marshal(jaxbObject, (Result)domResult);
        Document doc = (Document)domResult.getNode();
        return doc;
    }

    public static void dumpNode(Node node) throws TransformerFactoryConfigurationError {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            TransformerFactory tFactory = TransformerFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((TransformerFactory)tFactory);
            tFactory.newTransformer().transform(new DOMSource(node), new StreamResult(baos));
            String s = new String(baos.toByteArray(), "UTF-8");
            LOGGER.debug("Dumped Node. Byte Array: " + s);
        }
        catch (Exception e) {
            LOGGER.warn("Error while dumping node.", (Throwable)e);
        }
    }

    private static String createJAXBContextString(Class<?> jaxbClass, String ... contexts) {
        String packageName = jaxbClass.getPackage().getName();
        ArrayList<String> listClassesToBound = new ArrayList<String>(Arrays.asList(contexts));
        if (!listClassesToBound.contains(packageName)) {
            listClassesToBound.add(0, packageName);
        }
        String contextString = ((Object)listClassesToBound).toString().replaceAll(Pattern.quote(", "), ":").replaceAll(Pattern.quote("["), "").replaceAll(Pattern.quote("]"), "");
        return contextString;
    }

    public static String createId(String idPrefix, List<String> usedIDs) {
        String id = null;
        id = idPrefix + SEPARATOR_XML_ID + UUID.randomUUID().toString();
        while (usedIDs.contains(id)) {
        }
        return id;
    }

    public static ObjectContainer createObjectContainer(Document doc, String idPrefix, Node content, List<String> usedIDs) {
        ObjectContainer object = new ObjectContainer(content.getOwnerDocument());
        object.setEncoding(MIMETYPE_APPLICATION_XML);
        if (idPrefix != null && !idPrefix.isEmpty()) {
            String baseURI = XMLToolkit.createId(idPrefix, usedIDs);
            object.setId(baseURI);
        }
        object.appendChild(content);
        return object;
    }

    public static ObjectType createObject(String idPrefix, String encoding, Object content, List<String> usedIDs) {
        ObjectFactory objectFactory = new ObjectFactory();
        ObjectType object = objectFactory.createObjectType();
        if (encoding != null) {
            object.setEncoding(encoding);
        }
        if (idPrefix != null && !idPrefix.isEmpty()) {
            String baseURI = XMLToolkit.createId(idPrefix, usedIDs);
            object.setId(baseURI);
        }
        object.getContent().add(content);
        return object;
    }

    public static Document createEmptyDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.newDocument();
    }

    public static Document createEmptyDocumentRoot() throws ParserConfigurationException {
        return XMLToolkit.createEmptyDocument("root");
    }

    public static Document createEmptyDocument(String name) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        doc.appendChild(doc.createElement(name));
        return doc;
    }

    public static Document createDocument(byte[] bytes) {
        return XMLToolkit.createDocument(new ByteArrayInputStream(bytes));
    }

    public static Document createDocument(InputStream stream) {
        Document document;
        block8: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream is = stream;
            try {
                document = db.parse(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            is.close();
        }
        return document;
    }

    public static XPathExpression createXPathEpression(String xpath, NamespaceContext namespaceContext) throws XPathExpressionException {
        XPath xPath = XMLToolkit.createXPath(namespaceContext);
        return xPath.compile(xpath);
    }

    public static XPath createXPath(NamespaceContext namespaceContext) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        if (namespaceContext != null) {
            xPath.setNamespaceContext(namespaceContext);
        }
        return xPath;
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(Calendar calendar) throws DatatypeConfigurationException {
        return XMLToolkit.toXMLGregorianCalendar(calendar.getTime());
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(Date time) throws DatatypeConfigurationException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(time);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
    }

    public static class ChangeableNamespaceContext
    implements NamespaceContext {
        private Map<String, String> mapPrefixNamespaceURI = new HashMap<String, String>();
        private Map<String, List<String>> mapNamespaceURIPrefix = new HashMap<String, List<String>>();

        @Override
        public String getNamespaceURI(String prefix) {
            return this.mapPrefixNamespaceURI.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.mapNamespaceURIPrefix.get(namespaceURI).get(0);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return this.mapNamespaceURIPrefix.get(namespaceURI).iterator();
        }

        public ChangeableNamespaceContext addNamespacePrefixNames(NamespacePrefixName namespacePrefixName) {
            if (namespacePrefixName == null) {
                return this;
            }
            return this.addNamespacePrefixNames(Collections.singleton(namespacePrefixName));
        }

        public ChangeableNamespaceContext addNamespacePrefixNames(Set<NamespacePrefixName> namespacePrefixNames) {
            if (namespacePrefixNames == null || namespacePrefixNames.isEmpty()) {
                return this;
            }
            for (NamespacePrefixName namespacePrefixName : namespacePrefixNames) {
                this.mapPrefixNamespaceURI.put(namespacePrefixName.prefix, namespacePrefixName.namespaceURI);
                this.mapNamespaceURIPrefix.put(namespacePrefixName.namespaceURI, new ArrayList<String>(Collections.singletonList(namespacePrefixName.prefix)));
            }
            return this;
        }

        public ChangeableNamespaceContext addNamespacePrefixes(String prefix, String namespaceURI) {
            return this.addNamespacePrefixes(new NamespacePrefix(prefix, namespaceURI));
        }

        public ChangeableNamespaceContext addNamespacePrefixes(NamespacePrefix namespacePrefix) {
            if (namespacePrefix == null) {
                return this;
            }
            return this.addNamespacePrefixes(Collections.singleton(namespacePrefix));
        }

        public ChangeableNamespaceContext addNamespacePrefixes(Set<NamespacePrefix> namespacePrefixes) {
            if (namespacePrefixes == null || namespacePrefixes.isEmpty()) {
                return this;
            }
            for (NamespacePrefix namespacePrefixName : namespacePrefixes) {
                List<String> prefixes;
                if (!this.mapPrefixNamespaceURI.containsKey(namespacePrefixName.prefix)) {
                    this.mapPrefixNamespaceURI.put(namespacePrefixName.prefix, namespacePrefixName.namespaceURI);
                }
                if ((prefixes = this.mapNamespaceURIPrefix.get(namespacePrefixName.namespaceURI)) == null) {
                    this.mapNamespaceURIPrefix.put(namespacePrefixName.namespaceURI, new ArrayList<String>(Collections.singletonList(namespacePrefixName.prefix)));
                    continue;
                }
                prefixes.add(namespacePrefixName.prefix);
            }
            return this;
        }
    }

    public static class NamespacePrefixName
    extends NamespacePrefix {
        private String name;

        public NamespacePrefixName() {
            this(null, null, null);
        }

        public NamespacePrefixName(String name, String prefix, String namespaceURI) {
            super(prefix, namespaceURI);
            this.name = name;
        }

        @Override
        public String toString() {
            return "NamespacePrefixName [prefix=" + this.prefix + ", namespaceURI=" + this.namespaceURI + ", name=" + this.name + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + super.hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NamespacePrefixName other = (NamespacePrefixName)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.namespaceURI == null ? other.namespaceURI != null : !this.namespaceURI.equals(other.namespaceURI)) {
                return false;
            }
            return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
        }
    }

    public static class NamespacePrefix {
        protected String namespaceURI;
        protected String prefix;

        public NamespacePrefix() {
            this(null, null);
        }

        public NamespacePrefix(String prefix, String namespaceURI) {
            this.prefix = prefix;
            this.namespaceURI = namespaceURI;
        }

        public String toString() {
            return "NamespacePrefix [prefix=" + this.prefix + ", namespaceURI=" + this.namespaceURI + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NamespacePrefix other = (NamespacePrefix)obj;
            if (this.namespaceURI == null ? other.namespaceURI != null : !this.namespaceURI.equals(other.namespaceURI)) {
                return false;
            }
            return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public void setNamespaceURI(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    public static final class NamespaceContextImpl
    implements NamespaceContext {
        public static final String DEFAULT_NAMESPACE_PREFIX_XMLDSIG = "ds";
        public static final String DEFAULT_NAMESPACE_PREFIX_XADES = "xades";
        public static final String DEFAULT_NAMESPACE_PREFIX_XADES141 = "xadesv141";
        public static final String DEFAULT_NAMESPACE_PREFIX_XADES142 = "xadesv142";
        private final String namespaceURI;
        private final String prefix;

        public NamespaceContextImpl(String namespaceURI, String prefix) {
            this.namespaceURI = Objects.requireNonNull(namespaceURI, "URI of namespace is required, null is invalid");
            this.prefix = Objects.requireNonNull(prefix, "prefix is required, null is invalid");
        }

        private NamespaceContextImpl() {
            this("http://www.w3.org/2000/09/xmldsig#", DEFAULT_NAMESPACE_PREFIX_XMLDSIG);
        }

        public NamespaceContext createXMLDSigNamespaceContext() {
            return new NamespaceContextImpl();
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return Arrays.asList(this.prefix).iterator();
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.prefix;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.namespaceURI;
        }
    }
}

