/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.util;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.ReferenceResolver;
import de.governikus.csl.uom.SignedDataResponse;
import de.governikus.csl.uom.client.CSLClientApi;
import de.governikus.csl.uom.core.SignatureRequest;
import de.governikus.csl.uom.core.impl.DataToBeSignedImpl;
import de.governikus.csl.uom.impl.DocumentImpl;
import de.governikus.csl.uom.impl.FileReferenceResolver;
import de.governikus.csl.uom.impl.UnparsedDocument;
import de.governikus.csl.uom.res.PrivateKeyResourceReference;
import de.governikus.csl.uom.res.PrivateKeyResourceReferenceParameter;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import de.governikus.csl.uom.server.CSLServerApi;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.sign.SignedProperty;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.ades.AdESSignCreationPolicy;
import de.governikus.csl.uom.sign.impl.SignOptionsBuilder;
import de.governikus.csl.uom.sign.impl.SignerInfoBuilder;
import de.governikus.csl.uom.sign.props.CertID;
import de.governikus.csl.uom.sign.props.SigningCertificate;
import de.governikus.csl.uom.util.CSLDocumentDataHandler;
import de.governikus.csl.uom.util.Environment;
import de.governikus.csl.uom.util.SimpleURLDataHandler;
import de.governikus.csl.xml.sign.doc.XMLDocument;
import de.governikus.csl.xml.sign.doc.impl.XMLDocumentImpl;
import de.governikus.csl.xml.sign.impl.XMLSignEnvelopedOptionsImpl;
import de.governikus.csl.xml.sign.impl.XMLSignEnvelopingOptionsImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;

public class XMLSignUtil {
    public static final String RESOURCE_FILE_PROTOCOL = "file:/";
    public static final SignPolicy DEFAULT_XADES_SIGN_POLICY = AdESSignCreationPolicy.AdES_B_B;
    private static final String EXTENSION_XML = ".xml";

    private XMLSignUtil() {
    }

    public static Document makeDocument(String resource, boolean asXMLDocument, ReferenceResolver defaultReferenceResolver, Environment env) throws IOException {
        if (resource.startsWith(RESOURCE_FILE_PROTOCOL)) {
            File fileToSign = null;
            try {
                fileToSign = new File(new URI(resource));
            }
            catch (URISyntaxException e) {
                throw new IOException("URI syntax error: " + e.getMessage(), e);
            }
            DataHandler fileDataHandler = new DataHandler((DataSource)new FileDataSource(fileToSign));
            FileReferenceResolver referenceResolver = new FileReferenceResolver(fileToSign.getParentFile());
            Object d = null;
            if (asXMLDocument && fileToSign.getName().endsWith(EXTENSION_XML)) {
                DocumentImpl dx1 = new DocumentImpl("ObjectToSign-" + UUID.randomUUID().toString(), fileToSign.getName(), fileDataHandler, "application/octet-string", (ReferenceResolver)referenceResolver);
                d = new XMLDocumentImpl(dx1.getId(), dx1.getName(), (CSLDocumentDataHandler<org.w3c.dom.Document>)CSLDocumentDataHandler.createXMLDocumentDataHandler((Document)dx1, (Environment)env));
            } else {
                d = new DocumentImpl("ObjectToSign-" + UUID.randomUUID().toString(), fileToSign.getName(), fileDataHandler, "application/xml", (ReferenceResolver)referenceResolver);
            }
            return d;
        }
        Object d = null;
        if (asXMLDocument && resource.endsWith(EXTENSION_XML)) {
            DocumentImpl dx1 = new DocumentImpl("ObjectToSign-" + UUID.randomUUID().toString(), "../../" + resource, (DataHandler)new SimpleURLDataHandler(resource, "application/octet-string"), "application/octet-string", defaultReferenceResolver);
            d = new XMLDocumentImpl(dx1.getId(), dx1.getName(), (CSLDocumentDataHandler<org.w3c.dom.Document>)CSLDocumentDataHandler.createXMLDocumentDataHandler((Document)dx1, (Environment)env));
        } else {
            d = new DocumentImpl("ObjectToSign-" + UUID.randomUUID().toString(), "../../" + resource, (DataHandler)new SimpleURLDataHandler(resource, "application/xml"), "application/xml");
        }
        return d;
    }

    public static PrivateKeyResourceImpl cast(PrivateKeyResourceReference privateKeyResource) {
        if (privateKeyResource instanceof PrivateKeyResourceImpl) {
            return (PrivateKeyResourceImpl)privateKeyResource;
        }
        return null;
    }

    public static SignedDataResponse signXML_detached(String xmlName, String xmlResourceToSign, SignPolicy signPolicy, String algoIdSignature, String algoIdDigest, boolean asXMLDocument, SignPropertyEncoding signPropertyEncoding, boolean addSigningCertificate, String algoIdCertDigest, CSLClientApi cslClientApi, PrivateKeyResourceImpl signerKeyResource, ReferenceResolver defaultReferenceResolver, Environment env, Document ... documents) throws Exception {
        SignerInfoBuilder sib = new SignerInfoBuilder().setKey((PrivateKeyResourceReferenceParameter)signerKeyResource).setDigestAlgorithmURI(algoIdDigest).setSignatureAlgorithmURI(algoIdSignature);
        if (addSigningCertificate) {
            sib.addSignedProperty((SignedProperty)new SigningCertificate(Arrays.asList(new CertID(algoIdCertDigest, (X509Certificate)signerKeyResource.getCertificate().certificate())), true, new ConstraintSignPolicy.EncodingConstraint[]{signPropertyEncoding.getEncoding()}));
        }
        SignerInfo info = sib.build();
        LinkedHashSet<Class<UnparsedDocument>> inputDocumentClasses = new LinkedHashSet<Class<UnparsedDocument>>();
        inputDocumentClasses.add(UnparsedDocument.class);
        SignOptions options = new SignOptionsBuilder().setSignerInfos(Collections.singleton(info)).setSignatureType(SignatureType.DETACHED).setInputDocumentFormatClasses(inputDocumentClasses).setPluginID(Plugin.PluginID.SIGN_XML.getID()).setPolicy(signPolicy).build();
        List docList = null;
        if (documents != null && documents.length > 0) {
            docList = DataToBeSignedImpl.getList((Document[])documents);
        } else {
            Document d = XMLSignUtil.makeDocument(xmlResourceToSign, asXMLDocument, defaultReferenceResolver, env);
            docList = DataToBeSignedImpl.getList((Document[])new Document[]{d});
        }
        SignatureRequest signRequest = new SignatureRequest(options, docList);
        return cslClientApi.sign((SignRequest)signRequest, null);
    }

    public static SignedDataResponse signXML_enveloped(String xmlName, String xmlResourceToSign, SignPolicy signPolicy, String algoIdSignature, String algoIdDigest, boolean asXMLDocument, String signatureTargetNodeLocation, SignPropertyEncoding signPropertyEncoding, boolean addSigningCertificate, String algoIdCertDigest, CSLClientApi cslClientApi, PrivateKeyResourceImpl signerKeyResource, ReferenceResolver defaultReferenceResolver, Environment env, Document ... documents) throws Exception {
        LinkedHashSet<Class> inputDocumentClasses;
        SignerInfoBuilder sib = new SignerInfoBuilder();
        sib.setDigestAlgorithmURI(algoIdDigest).setSignatureAlgorithmURI(algoIdSignature).setKey((PrivateKeyResourceReferenceParameter)signerKeyResource);
        if (addSigningCertificate) {
            sib.getSignedProperties().add((Object)new SigningCertificate(Arrays.asList(new CertID(algoIdCertDigest, (X509Certificate)signerKeyResource.getCertificate().certificate())), true, new ConstraintSignPolicy.EncodingConstraint[]{signPropertyEncoding.getEncoding()}));
        }
        SignOptionsBuilder sob = new SignOptionsBuilder();
        sob.setPluginID(Plugin.PluginID.SIGN_XML.getID()).setPolicy(signPolicy).addSignerInfo(sib.build());
        Object options = null;
        sob.setSignatureType(SignatureType.ENVELOPED);
        if (signatureTargetNodeLocation == null || signatureTargetNodeLocation.isEmpty()) {
            inputDocumentClasses = new LinkedHashSet<Class>();
            inputDocumentClasses.add(UnparsedDocument.class);
            sob.setInputDocumentFormatClasses(inputDocumentClasses);
            options = sob.build();
        } else {
            inputDocumentClasses = new LinkedHashSet();
            inputDocumentClasses.add(XMLDocument.class);
            sob.setInputDocumentFormatClasses(inputDocumentClasses);
            options = new XMLSignEnvelopedOptionsImpl(sob.build(), signatureTargetNodeLocation);
        }
        List docList = null;
        if (documents != null && documents.length > 0) {
            docList = DataToBeSignedImpl.getList((Document[])documents);
        } else {
            Document d = XMLSignUtil.makeDocument(xmlResourceToSign, asXMLDocument, defaultReferenceResolver, env);
            docList = DataToBeSignedImpl.getList((Document[])new Document[]{d});
        }
        SignatureRequest signRequest = new SignatureRequest(options, docList);
        return cslClientApi.sign((SignRequest)signRequest, null);
    }

    public static SignedDataResponse signXML_enveloping(String xmlName, String xmlResourceToSign, SignPolicy signPolicy, String algoIdSignature, String algoIdDigest, boolean asXMLDocument, Boolean xmlDocumentsToBeInserted, SignPropertyEncoding signPropertyEncoding, boolean addSigningCertificate, String algoIdCertDigest, CSLClientApi cslClientApi, PrivateKeyResourceImpl signerKeyResource, ReferenceResolver defaultReferenceResolver, Environment env, Document ... documents) throws Exception {
        LinkedHashSet<Class> inputDocumentClasses;
        SignerInfoBuilder sib = new SignerInfoBuilder().setKey((PrivateKeyResourceReferenceParameter)signerKeyResource).setDigestAlgorithmURI(algoIdDigest).setSignatureAlgorithmURI(algoIdSignature);
        if (addSigningCertificate) {
            sib.addSignedProperty((SignedProperty)new SigningCertificate(Arrays.asList(new CertID(algoIdCertDigest, (X509Certificate)signerKeyResource.getCertificate().certificate())), true, new ConstraintSignPolicy.EncodingConstraint[]{signPropertyEncoding.getEncoding()}));
        }
        SignerInfo info = sib.build();
        SignOptionsBuilder sob = new SignOptionsBuilder().setSignerInfos(Collections.singleton(info)).setPluginID(Plugin.PluginID.SIGN_XML.getID()).setPolicy(signPolicy);
        Object options = null;
        sob.setSignatureType(SignatureType.ENVELOPING);
        if (xmlDocumentsToBeInserted == null) {
            inputDocumentClasses = new LinkedHashSet<Class>();
            inputDocumentClasses.add(UnparsedDocument.class);
            sob.setInputDocumentFormatClasses(inputDocumentClasses);
            options = sob.build();
        } else {
            inputDocumentClasses = new LinkedHashSet();
            inputDocumentClasses.add(XMLDocument.class);
            sob.setInputDocumentFormatClasses(inputDocumentClasses);
            options = new XMLSignEnvelopingOptionsImpl(sob.build(), xmlDocumentsToBeInserted);
        }
        List docList = null;
        if (documents != null && documents.length > 0) {
            docList = DataToBeSignedImpl.getList((Document[])documents);
        } else {
            Document d = XMLSignUtil.makeDocument(xmlResourceToSign, asXMLDocument, defaultReferenceResolver, env);
            docList = DataToBeSignedImpl.getList((Document[])new Document[]{d});
        }
        SignatureRequest signRequest = new SignatureRequest(options, docList);
        return cslClientApi.sign((SignRequest)signRequest, null);
    }

    public static SignedDataResponse signXML_enveloped(String xmlName, String xmlResourceToSign, SignPolicy signPolicy, String algoIdSignature, String algoIdDigest, boolean asXMLDocument, String signatureTargetNodeLocation, SignPropertyEncoding signPropertyEncoding, boolean addSigningCertificate, String algoIdCertDigest, CSLServerApi cslServerApi, PrivateKeyResourceReference signerKeyResourceReference, ReferenceResolver defaultReferenceResolver, Environment env, Document ... documents) throws Exception {
        SignerInfoBuilder sib = new SignerInfoBuilder();
        sib.setDigestAlgorithmURI(algoIdDigest).setSignatureAlgorithmURI(algoIdSignature).setKey((PrivateKeyResourceReferenceParameter)signerKeyResourceReference);
        if (addSigningCertificate) {
            sib.getSignedProperties().add((Object)new SigningCertificate(null, true, new ConstraintSignPolicy.EncodingConstraint[]{signPropertyEncoding.getEncoding()}));
        }
        SignOptionsBuilder sob = new SignOptionsBuilder();
        sob.setPluginID(Plugin.PluginID.SIGN_XML.getID()).setPolicy(signPolicy).setSignatureType(SignatureType.ENVELOPED).setSignerInfos(Collections.singleton(sib.build()));
        Object options = null;
        LinkedHashSet<Class<UnparsedDocument>> inputDocumentClasses = new LinkedHashSet<Class<UnparsedDocument>>();
        inputDocumentClasses.add(UnparsedDocument.class);
        sob.setInputDocumentFormatClasses(inputDocumentClasses).setSignatureType(SignatureType.ENVELOPED);
        options = signatureTargetNodeLocation == null || signatureTargetNodeLocation.isEmpty() ? sob.build() : new XMLSignEnvelopedOptionsImpl(sob.build(), signatureTargetNodeLocation);
        List docList = null;
        if (documents != null && documents.length > 0) {
            docList = DataToBeSignedImpl.getList((Document[])documents);
        } else {
            Document d = XMLSignUtil.makeDocument(xmlResourceToSign, asXMLDocument, defaultReferenceResolver, env);
            docList = DataToBeSignedImpl.getList((Document[])new Document[]{d});
        }
        SignatureRequest signRequest = new SignatureRequest(options, docList);
        return cslServerApi.sign((SignRequest)signRequest, null);
    }

    public static SignedDataResponse signXML_enveloping(String xmlName, String xmlResourceToSign, SignPolicy signPolicy, String algoIdSignature, String algoIdDigest, boolean asXMLDocument, Boolean xmlDocumentsToBeInserted, SignPropertyEncoding signPropertyEncoding, boolean addSigningCertificate, String algoIdCertDigest, CSLServerApi cslServerApi, PrivateKeyResourceReference signerKeyResourceReference, ReferenceResolver defaultReferenceResolver, Environment env, Document ... documents) throws Exception {
        SignerInfoBuilder sib = new SignerInfoBuilder();
        sib.setDigestAlgorithmURI(algoIdDigest).setSignatureAlgorithmURI(algoIdSignature).setKey((PrivateKeyResourceReferenceParameter)signerKeyResourceReference);
        if (addSigningCertificate) {
            sib.getSignedProperties().add((Object)new SigningCertificate(null, true, new ConstraintSignPolicy.EncodingConstraint[]{signPropertyEncoding.getEncoding()}));
        }
        SignOptionsBuilder sob = new SignOptionsBuilder();
        sob.setPluginID(Plugin.PluginID.SIGN_XML.getID()).setPolicy(signPolicy).setSignatureType(SignatureType.ENVELOPING).setSignerInfos(Collections.singleton(sib.build()));
        XMLSignEnvelopingOptionsImpl options = null;
        if (xmlDocumentsToBeInserted == null || !xmlDocumentsToBeInserted.booleanValue()) {
            LinkedHashSet<Class<UnparsedDocument>> inputDocumentClasses = new LinkedHashSet<Class<UnparsedDocument>>();
            inputDocumentClasses.add(UnparsedDocument.class);
            sob.setSignatureType(SignatureType.ENVELOPING);
            sob.setInputDocumentFormatClasses(inputDocumentClasses);
            options = sob.build();
        } else {
            sob.setInputDocumentFormatClasses(XMLSignEnvelopingOptionsImpl.INPUT_DOCUMENT_CLASSES);
            options = new XMLSignEnvelopingOptionsImpl(sob.build(), xmlDocumentsToBeInserted);
        }
        List docList = null;
        if (documents != null && documents.length > 0) {
            docList = DataToBeSignedImpl.getList((Document[])documents);
        } else {
            Document d = XMLSignUtil.makeDocument(xmlResourceToSign, asXMLDocument, defaultReferenceResolver, env);
            docList = DataToBeSignedImpl.getList((Document[])new Document[]{d});
        }
        SignatureRequest signRequest = new SignatureRequest((SignOptions)options, docList);
        return cslServerApi.sign((SignRequest)signRequest, null);
    }

    public static SignedDataResponse signXML_detached(String xmlName, String xmlResourceToSign, SignPolicy signPolicy, String algoIdSignature, String algoIdDigest, boolean asXMLDocument, SignPropertyEncoding signPropertyEncoding, boolean addSigningCertificate, String algoIdCertDigest, CSLServerApi cslServerApi, PrivateKeyResourceReference signerKeyResourceReference, ReferenceResolver defaultReferenceResolver, Environment env, Document ... documents) throws Exception {
        SignerInfoBuilder sib = new SignerInfoBuilder();
        sib.setDigestAlgorithmURI(algoIdDigest).setSignatureAlgorithmURI(algoIdSignature).setKey((PrivateKeyResourceReferenceParameter)signerKeyResourceReference);
        if (addSigningCertificate) {
            sib.getSignedProperties().add((Object)new SigningCertificate(null, true, new ConstraintSignPolicy.EncodingConstraint[]{signPropertyEncoding.getEncoding()}));
        }
        LinkedHashSet<Class<UnparsedDocument>> inputDocumentClasses = new LinkedHashSet<Class<UnparsedDocument>>();
        inputDocumentClasses.add(UnparsedDocument.class);
        SignOptionsBuilder sob = new SignOptionsBuilder();
        sob.setPluginID(Plugin.PluginID.SIGN_XML.getID()).setSignatureType(SignatureType.DETACHED).setPolicy(signPolicy).setInputDocumentFormatClasses(inputDocumentClasses).addSignerInfo(sib.build());
        SignOptions options = sob.build();
        List docList = null;
        if (documents != null && documents.length > 0) {
            docList = DataToBeSignedImpl.getList((Document[])documents);
        } else {
            Document d = XMLSignUtil.makeDocument(xmlResourceToSign, asXMLDocument, defaultReferenceResolver, env);
            docList = DataToBeSignedImpl.getList((Document[])new Document[]{d});
        }
        SignatureRequest signRequest = new SignatureRequest(options, docList);
        return cslServerApi.sign((SignRequest)signRequest, null);
    }

    public static enum SignPropertyEncoding {
        ETSI_BES(ConstraintSignPolicy.EncodingConstraint.ETSI_TS),
        ETSI_EN(ConstraintSignPolicy.EncodingConstraint.ETSI_EN);

        public static final ConstraintSignPolicy.EncodingConstraint VALUE_ETSI_BES;
        public static final ConstraintSignPolicy.EncodingConstraint VALUE_ETSI_EN;
        private final ConstraintSignPolicy.EncodingConstraint encoding;

        private SignPropertyEncoding(ConstraintSignPolicy.EncodingConstraint encoding) {
            this.encoding = encoding;
        }

        public ConstraintSignPolicy.EncodingConstraint getEncoding() {
            return this.encoding;
        }

        public String toString() {
            return super.toString() + " (" + this.getEncoding() + ")";
        }

        public static SignPropertyEncoding valueOf(ConstraintSignPolicy.EncodingConstraint encoding) {
            for (SignPropertyEncoding signPropertyEncoding : SignPropertyEncoding.values()) {
                if (signPropertyEncoding.getEncoding() != encoding) continue;
                return signPropertyEncoding;
            }
            return null;
        }

        static {
            VALUE_ETSI_BES = ConstraintSignPolicy.EncodingConstraint.ETSI_TS;
            VALUE_ETSI_EN = ConstraintSignPolicy.EncodingConstraint.ETSI_EN;
        }
    }
}

