/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.uom.sign.props.SignatureTimestamp;
import org.etsi.uri._01903.v1_3.RevocationValuesType;
import org.etsi.uri._01903.v1_3.XAdESTimeStampType;
import org.etsi.uri._01903.v1_4.ValidationDataType;

public class XAdESSignatureTimeStamp
extends SignatureTimestamp {
    private final ValidationDataType validationData;
    private final XAdESTimeStampType xadesTimestamp;

    public XAdESSignatureTimeStamp(SignatureTimestamp signatureTimeStamp) throws IllegalArgumentException {
        this(signatureTimeStamp, false, false, true);
    }

    public XAdESSignatureTimeStamp(SignatureTimestamp signatureTimeStamp, boolean validationDataUsed, boolean ocspResponsesUsed, boolean crlsUsed) {
        super(signatureTimeStamp.getDigestAlgorithmURI(), signatureTimeStamp.getTimestamps(), signatureTimeStamp.isValidationDataUsed(), signatureTimeStamp.areOCSPResponsesUsed(), signatureTimeStamp.areCRLsUsed(), signatureTimeStamp.useDefaultEncodings(), signatureTimeStamp.getEncodings());
        this.xadesTimestamp = null;
        this.validationData = null;
    }

    public XAdESSignatureTimeStamp(SignatureTimestamp signatureTimeStamp, XAdESTimeStampType xadesTimestamp, ValidationDataType validationData) {
        super(signatureTimeStamp.getDigestAlgorithmURI(), signatureTimeStamp.getTimestamps(), validationData != null, XAdESSignatureTimeStamp.checkOCSP(validationData), XAdESSignatureTimeStamp.checkCRL(validationData), signatureTimeStamp.useDefaultEncodings(), signatureTimeStamp.getEncodings());
        this.xadesTimestamp = xadesTimestamp;
        this.validationData = validationData;
    }

    private static boolean checkOCSP(ValidationDataType validationData) {
        RevocationValuesType rvt;
        RevocationValuesType revocationValuesType = rvt = validationData != null && validationData.getRevocationValues() != null ? validationData.getRevocationValues() : null;
        return rvt != null && rvt.getOCSPValues() != null ? !rvt.getOCSPValues().getEncapsulatedOCSPValue().isEmpty() : false;
    }

    private static boolean checkCRL(ValidationDataType validationData) {
        RevocationValuesType rvt;
        RevocationValuesType revocationValuesType = rvt = validationData != null && validationData.getRevocationValues() != null ? validationData.getRevocationValues() : null;
        return rvt != null && rvt.getCRLValues() != null ? !rvt.getCRLValues().getEncapsulatedCRLValue().isEmpty() : false;
    }

    public ValidationDataType getValidationData() {
        return this.validationData;
    }

    public XAdESTimeStampType getXadesTimestamp() {
        return this.xadesTimestamp;
    }
}

