/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.uom.sign.props.ContentTimestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.etsi.uri._01903.v1_3.IncludeType;
import org.etsi.uri._01903.v1_3.RevocationValuesType;
import org.etsi.uri._01903.v1_3.XAdESTimeStampType;
import org.etsi.uri._01903.v1_4.ValidationDataType;

public class XAdESContentTimeStamp
extends ContentTimestamp {
    private final List<String> includedURIs;
    private final ValidationDataType validationData;
    private final XAdESTimeStampType xadesTimestamp;

    public XAdESContentTimeStamp(ContentTimestamp contentTimeStamp) {
        this(contentTimeStamp, null, null);
    }

    public XAdESContentTimeStamp(ContentTimestamp contentTimeStamp, XAdESTimeStampType xadesTimestamp, ValidationDataType validationData) {
        super(contentTimeStamp.getDigestAlgorithmURI(), contentTimeStamp.getTimestamps(), validationData != null, XAdESContentTimeStamp.checkOCSP(validationData), XAdESContentTimeStamp.checkCRL(validationData), contentTimeStamp.useDefaultEncodings(), contentTimeStamp.getEncodings());
        this.xadesTimestamp = xadesTimestamp;
        this.validationData = validationData;
        List<String> tmp = null;
        if (xadesTimestamp != null && xadesTimestamp.getInclude() != null) {
            tmp = new ArrayList();
            for (IncludeType include : xadesTimestamp.getInclude()) {
                tmp.add(include.getURI());
            }
            tmp = Collections.unmodifiableList(tmp);
        }
        this.includedURIs = tmp;
    }

    private static boolean checkOCSP(ValidationDataType validationData) {
        RevocationValuesType rvt;
        RevocationValuesType revocationValuesType = rvt = validationData != null && validationData.getRevocationValues() != null ? validationData.getRevocationValues() : null;
        return rvt != null && rvt.getOCSPValues() != null ? !rvt.getOCSPValues().getEncapsulatedOCSPValue().isEmpty() : false;
    }

    private static boolean checkCRL(ValidationDataType validationData) {
        RevocationValuesType rvt;
        RevocationValuesType revocationValuesType = rvt = validationData != null && validationData.getRevocationValues() != null ? validationData.getRevocationValues() : null;
        return rvt != null && rvt.getCRLValues() != null ? !rvt.getCRLValues().getEncapsulatedCRLValue().isEmpty() : false;
    }

    public XAdESContentTimeStamp(ContentTimestamp contentTimeStamp, List<String> includedURIs) {
        super(contentTimeStamp.getDigestAlgorithmURI(), contentTimeStamp.getTimestamps(), contentTimeStamp.isValidationDataUsed(), contentTimeStamp.areOCSPResponsesUsed(), contentTimeStamp.areCRLsUsed(), contentTimeStamp.useDefaultEncodings(), contentTimeStamp.getEncodings());
        this.includedURIs = Collections.unmodifiableList(includedURIs == null ? new ArrayList() : new ArrayList<String>(includedURIs));
        this.xadesTimestamp = null;
        this.validationData = null;
    }

    public XAdESContentTimeStamp(ContentTimestamp contentTimeStamp, List<String> includedURIs, boolean validationDataUsed, boolean ocspResponsesUsed, boolean crlsUsed) {
        super(contentTimeStamp.getDigestAlgorithmURI(), contentTimeStamp.getTimestamps(), validationDataUsed, ocspResponsesUsed, crlsUsed, contentTimeStamp.useDefaultEncodings(), contentTimeStamp.getEncodings());
        this.includedURIs = Collections.unmodifiableList(includedURIs == null ? new ArrayList() : new ArrayList<String>(includedURIs));
        this.xadesTimestamp = null;
        this.validationData = null;
    }

    public ValidationDataType getValidationData() {
        return this.validationData;
    }

    public XAdESTimeStampType getXadesTimestamp() {
        return this.xadesTimestamp;
    }

    public List<String> getIncludedURIs() {
        return this.includedURIs;
    }
}

