/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.CertID;
import de.governikus.csl.uom.sign.props.SigningCertificate;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import de.governikus.csl.xml.sign.util.XMLToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.etsi.uri._01903.v1_3.CertIDListV2Type;
import org.etsi.uri._01903.v1_3.CertIDTypeV2;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._01903.v1_3.ObjectFactory;

public class SigningCertificateConverterV2
extends AbstractXMLSignPropertiesConverter<SigningCertificate, CertIDListV2Type> {
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_SIGNING_CERTIFICATE = ConstraintSignPolicy.EncodingConstraint.ETSI_EN;
    ObjectFactory xadesV13ObjectFactory = new ObjectFactory();
    org.etsi.uri._01903.v1_4.ObjectFactory xadesV14ObjectFactory = new org.etsi.uri._01903.v1_4.ObjectFactory();

    public SigningCertificateConverterV2() {
        super(SigningCertificate.class, CertIDListV2Type.class, true, VERSION_SIGNING_CERTIFICATE);
    }

    public <T extends CertIDListV2Type> SigningCertificate decode(T certIDList) throws IOException {
        if (certIDList == null) {
            return null;
        }
        List certIDs = certIDList.getCert();
        if (certIDs == null || certIDs.isEmpty()) {
            return null;
        }
        ArrayList<CertID> decCertIDs = new ArrayList<CertID>();
        for (CertIDTypeV2 certID : certIDs) {
            decCertIDs.add(this.createCertID(certID));
        }
        return new SigningCertificate(decCertIDs, false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_SIGNING_CERTIFICATE});
    }

    private CertID createCertID(CertIDTypeV2 certID) throws IOException {
        IssuerSerial issuerSerial = IssuerSerial.getInstance((Object)certID.getIssuerSerialV2());
        return new CertID(certID.getCertDigest().getDigestMethod().getAlgorithm(), certID.getCertDigest().getDigestValue(), new X500Principal(issuerSerial.getIssuer().getEncoded()), issuerSerial.getSerial().getValue());
    }

    public CertIDListV2Type encode(SigningCertificate signingCertificate, XMLSigningContext cache) throws IOException {
        CertIDListV2Type certIDList = this.xadesV13ObjectFactory.createCertIDListV2Type();
        if (signingCertificate == null) {
            return certIDList;
        }
        List certIDs = signingCertificate.getCertIDs();
        if (certIDs == null || certIDs.isEmpty()) {
            return certIDList;
        }
        for (CertID certID : certIDs) {
            certIDList.getCert().add(this.createCertID(certID));
        }
        return certIDList;
    }

    public CertIDTypeV2 createCertID(CertID certID) throws IOException {
        CertIDTypeV2 certIDtype = this.xadesV13ObjectFactory.createCertIDTypeV2();
        DigestAlgAndValueType digestAlgAndValueType = XMLToolkit.createDigestAlgAndValueType(certID.getDigestAlgorithmURI(), certID.getDigest());
        certIDtype.setCertDigest(digestAlgAndValueType);
        return certIDtype;
    }
}

