/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.CertID;
import de.governikus.csl.uom.sign.props.SigningCertificate;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import de.governikus.csl.xml.sign.util.XMLToolkit;
import java.util.ArrayList;
import java.util.List;
import org.etsi.uri._01903.v1_3.CertIDListType;
import org.etsi.uri._01903.v1_3.CertIDType;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.w3._2000._09.xmldsig.ObjectFactory;
import org.w3._2000._09.xmldsig.X509IssuerSerialType;

public class SigningCertificateConverter
extends AbstractXMLSignPropertiesConverter<SigningCertificate, CertIDListType> {
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_SIGNING_CERTIFICATE = ConstraintSignPolicy.EncodingConstraint.ETSI_TS;
    org.etsi.uri._01903.v1_3.ObjectFactory xadesObjectFactory = new org.etsi.uri._01903.v1_3.ObjectFactory();

    public SigningCertificateConverter() {
        super(SigningCertificate.class, CertIDListType.class, false, VERSION_SIGNING_CERTIFICATE);
    }

    public <T extends CertIDListType> SigningCertificate decode(T certIDList) {
        if (certIDList == null) {
            return null;
        }
        List certIDs = certIDList.getCert();
        if (certIDs == null || certIDs.isEmpty()) {
            return null;
        }
        ArrayList<CertID> decCertIDs = new ArrayList<CertID>();
        for (CertIDType certID : certIDs) {
            decCertIDs.add(this.createCertID(certID));
        }
        return new SigningCertificate(decCertIDs, false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_SIGNING_CERTIFICATE});
    }

    private CertID createCertID(CertIDType certID) {
        return new CertID(certID.getCertDigest().getDigestMethod().getAlgorithm(), certID.getCertDigest().getDigestValue(), certID.getIssuerSerial().getX509IssuerName(), certID.getIssuerSerial().getX509SerialNumber());
    }

    public CertIDListType encode(SigningCertificate signingCertificate, XMLSigningContext cache) {
        CertIDListType certIDList = this.xadesObjectFactory.createCertIDListType();
        if (signingCertificate == null) {
            return certIDList;
        }
        List certIDs = signingCertificate.getCertIDs();
        if (certIDs == null || certIDs.isEmpty()) {
            return certIDList;
        }
        for (CertID certID : certIDs) {
            certIDList.getCert().add(this.createCertID(certID));
        }
        return certIDList;
    }

    public CertIDType createCertID(CertID certID) {
        ObjectFactory xmldsigObjectFactory = new ObjectFactory();
        CertIDType certIDtype = this.xadesObjectFactory.createCertIDType();
        DigestAlgAndValueType digestAlgAndValueType = XMLToolkit.createDigestAlgAndValueType(certID.getDigestAlgorithmURI(), certID.getDigest());
        certIDtype.setCertDigest(digestAlgAndValueType);
        X509IssuerSerialType x509IssuerSerialType = xmldsigObjectFactory.createX509IssuerSerialType();
        if (certID.getIssuerName() != null) {
            x509IssuerSerialType.setX509IssuerName(certID.getIssuerName());
        } else {
            x509IssuerSerialType.setX509IssuerName(certID.getIssuer().getName("RFC2253"));
        }
        x509IssuerSerialType.setX509SerialNumber(certID.getSerialNumber());
        certIDtype.setIssuerSerial(x509IssuerSerialType);
        return certIDtype;
    }
}

