/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.CertifiedRole;
import de.governikus.csl.uom.sign.props.ClaimedRole;
import de.governikus.csl.uom.sign.props.SignerRole;
import de.governikus.csl.uom.sign.props.XAdESEncoding;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.etsi.uri._01903.v1_3.AnyType;
import org.etsi.uri._01903.v1_3.CertifiedRoleTypeV2;
import org.etsi.uri._01903.v1_3.CertifiedRolesListTypeV2;
import org.etsi.uri._01903.v1_3.ClaimedRolesListType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.ObjectFactory;
import org.etsi.uri._01903.v1_3.SignerRoleV2Type;
import org.w3c.dom.Node;

public class SignerRoleConverterV2
extends AbstractXMLSignPropertiesConverter<SignerRole, SignerRoleV2Type> {
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_SIGNER_ROLE = ConstraintSignPolicy.EncodingConstraint.ETSI_EN;
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_CLAIMED_ROLE = ConstraintSignPolicy.EncodingConstraint.ETSI_TS;
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_CERTIFIED_ROLE = VERSION_SIGNER_ROLE;
    ObjectFactory xadesObjectFactory = new ObjectFactory();

    public SignerRoleConverterV2() {
        super(SignerRole.class, SignerRoleV2Type.class, true, VERSION_SIGNER_ROLE);
    }

    public <T extends SignerRoleV2Type> SignerRole decode(T signerRole) {
        List encodedCertifiedRoles;
        ArrayList<ClaimedRole> claimedRoles = new ArrayList<ClaimedRole>();
        ArrayList<CertifiedRole> certifiedRoles = new ArrayList<CertifiedRole>();
        List encodedClaimedRoles = signerRole.getClaimedRoles().getClaimedRole();
        if (encodedClaimedRoles != null && !encodedClaimedRoles.isEmpty()) {
            for (AnyType encodedClaimedRole : encodedClaimedRoles) {
                List content = encodedClaimedRole.getContent();
                if (content instanceof Node) {
                    claimedRoles.add(new ClaimedRole((Node)((Object)content), false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_CLAIMED_ROLE}));
                    continue;
                }
                if (!(content instanceof String)) continue;
                claimedRoles.add(new ClaimedRole((String)((Object)content), false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_CLAIMED_ROLE}));
            }
        }
        if ((encodedCertifiedRoles = signerRole.getCertifiedRolesV2().getCertifiedRole()) != null && !encodedCertifiedRoles.isEmpty()) {
            for (CertifiedRoleTypeV2 encodedCertifiedRole : encodedCertifiedRoles) {
                EncapsulatedPKIDataType pkiData = encodedCertifiedRole.getX509AttributeCertificate();
                if (pkiData == null) {
                    AnyType anyType = encodedCertifiedRole.getOtherAttributeCertificate();
                    continue;
                }
                certifiedRoles.add(new CertifiedRole(null, XAdESEncoding.BER.getEncodingURI(), pkiData.getValue(), false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_CERTIFIED_ROLE}));
            }
        }
        return new SignerRole(false, Collections.singletonList(VERSION_SIGNER_ROLE), claimedRoles, certifiedRoles);
    }

    public SignerRoleV2Type encode(SignerRole signerRole, XMLSigningContext cache) {
        List certifiedRoles;
        SignerRoleV2Type signerRoleType = this.xadesObjectFactory.createSignerRoleV2Type();
        if (signerRole == null) {
            return signerRoleType;
        }
        List claimedRoles = signerRole.getClaimedRoles();
        if (claimedRoles != null && !claimedRoles.isEmpty()) {
            ClaimedRolesListType claimedRolesList = this.xadesObjectFactory.createClaimedRolesListType();
            for (ClaimedRole claimedRole : claimedRoles) {
                Object content = null;
                content = claimedRole.getRoleNode() != null ? claimedRole.getRoleNode() : claimedRole.getRole();
                AnyType anyType = this.xadesObjectFactory.createAnyType();
                anyType.getContent().add(content);
                claimedRolesList.getClaimedRole().add(anyType);
            }
            signerRoleType.setClaimedRoles(claimedRolesList);
        }
        if ((certifiedRoles = signerRole.getCertifiedRoles()) != null && !certifiedRoles.isEmpty()) {
            CertifiedRolesListTypeV2 certifiedRolesList = this.xadesObjectFactory.createCertifiedRolesListTypeV2();
            for (CertifiedRole certifiedRole : certifiedRoles) {
                EncapsulatedPKIDataType pkiData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                pkiData.setId(certifiedRole.getId());
                pkiData.setEncoding(certifiedRole.getEncoding());
                pkiData.setValue(certifiedRole.getData());
                this.xadesObjectFactory.createX509AttributeCertificate(pkiData);
                CertifiedRoleTypeV2 certifiedRoleV2 = this.xadesObjectFactory.createCertifiedRoleTypeV2();
                certifiedRoleV2.setX509AttributeCertificate(pkiData);
                certifiedRolesList.getCertifiedRole().add(certifiedRoleV2);
            }
            signerRoleType.setCertifiedRolesV2(certifiedRolesList);
        }
        return signerRoleType;
    }
}

