/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.CertifiedRole;
import de.governikus.csl.uom.sign.props.ClaimedRole;
import de.governikus.csl.uom.sign.props.SignerRole;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.etsi.uri._01903.v1_3.AnyType;
import org.etsi.uri._01903.v1_3.CertifiedRolesListType;
import org.etsi.uri._01903.v1_3.ClaimedRolesListType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.ObjectFactory;
import org.etsi.uri._01903.v1_3.SignerRoleType;
import org.w3c.dom.Node;

public class SignerRoleConverter
extends AbstractXMLSignPropertiesConverter<SignerRole, SignerRoleType> {
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_SIGNER_ROLE;
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_CLAIMED_ROLE;
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_CERTIFIED_ROLE;
    ObjectFactory xadesObjectFactory = new ObjectFactory();

    public SignerRoleConverter() {
        super(SignerRole.class, SignerRoleType.class, false, VERSION_SIGNER_ROLE);
    }

    public <T extends SignerRoleType> SignerRole decode(T signerRole) {
        List encodedCertifiedRoles;
        ArrayList<ClaimedRole> claimedRoles = new ArrayList<ClaimedRole>();
        ArrayList<CertifiedRole> certifiedRoles = new ArrayList<CertifiedRole>();
        List encodedClaimedRoles = signerRole.getClaimedRoles().getClaimedRole();
        if (encodedClaimedRoles != null && !encodedClaimedRoles.isEmpty()) {
            for (AnyType encodedClaimedRole : encodedClaimedRoles) {
                List content = encodedClaimedRole.getContent();
                if (content instanceof Node) {
                    claimedRoles.add(new ClaimedRole((Node)((Object)content), false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_CLAIMED_ROLE}));
                    continue;
                }
                if (!(content instanceof String)) continue;
                claimedRoles.add(new ClaimedRole((String)((Object)content), false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_CLAIMED_ROLE}));
            }
        }
        if ((encodedCertifiedRoles = signerRole.getCertifiedRoles().getCertifiedRole()) != null && !encodedCertifiedRoles.isEmpty()) {
            for (EncapsulatedPKIDataType encodedCertifiedRole : encodedCertifiedRoles) {
                certifiedRoles.add(new CertifiedRole(encodedCertifiedRole.getId(), encodedCertifiedRole.getEncoding(), encodedCertifiedRole.getValue(), false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_CERTIFIED_ROLE}));
            }
        }
        return new SignerRole(false, Collections.singletonList(VERSION_SIGNER_ROLE), claimedRoles, certifiedRoles);
    }

    public SignerRoleType encode(SignerRole signerRole, XMLSigningContext cache) {
        List certifiedRoles;
        SignerRoleType signerRoleType = this.xadesObjectFactory.createSignerRoleType();
        if (signerRole == null) {
            return signerRoleType;
        }
        List claimedRoles = signerRole.getClaimedRoles();
        if (claimedRoles != null && !claimedRoles.isEmpty()) {
            ClaimedRolesListType claimedRolesList = this.xadesObjectFactory.createClaimedRolesListType();
            for (ClaimedRole claimedRole : claimedRoles) {
                Object content = null;
                content = claimedRole.getRoleNode() != null ? claimedRole.getRoleNode() : claimedRole.getRole();
                AnyType anyType = this.xadesObjectFactory.createAnyType();
                anyType.getContent().add(content);
                claimedRolesList.getClaimedRole().add(anyType);
            }
            signerRoleType.setClaimedRoles(claimedRolesList);
        }
        if ((certifiedRoles = signerRole.getCertifiedRoles()) != null && !certifiedRoles.isEmpty()) {
            CertifiedRolesListType certifiedRolesList = this.xadesObjectFactory.createCertifiedRolesListType();
            for (CertifiedRole certifiedRole : certifiedRoles) {
                EncapsulatedPKIDataType pkiData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                pkiData.setId(certifiedRole.getId());
                pkiData.setEncoding(certifiedRole.getEncoding());
                pkiData.setValue(certifiedRole.getData());
                certifiedRolesList.getCertifiedRole().add(pkiData);
            }
            signerRoleType.setCertifiedRoles(certifiedRolesList);
        }
        return signerRoleType;
    }

    static {
        VERSION_CLAIMED_ROLE = VERSION_SIGNER_ROLE = ConstraintSignPolicy.EncodingConstraint.ETSI_TS;
        VERSION_CERTIFIED_ROLE = VERSION_SIGNER_ROLE;
    }
}

