/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.sign.props.SelfProcessingSignPropertiesEncoder;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.res.CertificateValidationServiceResource;
import de.governikus.csl.uom.res.TimestampServiceResource;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.props.SignatureTimestamp;
import de.governikus.csl.uom.sign.props.XAdESEncoding;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import de.governikus.csl.xml.sign.props.XAdESSignatureTimeStamp;
import de.governikus.csl.xml.sign.util.XMLToolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.xml.security.c14n.Canonicalizer;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TimeStampToken;
import org.etsi.uri._01903.v1_3.CRLValuesType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.OCSPValuesType;
import org.etsi.uri._01903.v1_3.XAdESTimeStampType;
import org.etsi.uri._01903.v1_4.ObjectFactory;
import org.etsi.uri._01903.v1_4.ValidationDataType;
import org.w3._2000._09.xmldsig.CanonicalizationMethodType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignatureTimestampCreator
extends AbstractXMLSignPropertiesConverter<SignatureTimestamp, XAdESTimeStampType>
implements SelfProcessingSignPropertiesEncoder {
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_SIGNATURE_TIMESTAMP = ConstraintSignPolicy.EncodingConstraint.DEFAULT;
    private final XAdESTimeStampType processed;
    private final org.etsi.uri._01903.v1_3.ObjectFactory xadesObjectFactory = new org.etsi.uri._01903.v1_3.ObjectFactory();
    private final ObjectFactory xadesv141ObjectFactory = new ObjectFactory();

    public SignatureTimestampCreator() {
        super(SignatureTimestamp.class, XAdESTimeStampType.class, true, VERSION_SIGNATURE_TIMESTAMP);
        this.processed = this.xadesObjectFactory.createXAdESTimeStampType();
    }

    public <T extends XAdESTimeStampType> SignatureTimestamp decode(T timestamp) throws IOException {
        ArrayList<TimeStampToken> timestampTokens = new ArrayList<TimeStampToken>();
        for (Object object : timestamp.getEncapsulatedTimeStampOrXMLTimeStamp()) {
            if (!(object instanceof EncapsulatedPKIDataType)) continue;
            try {
                timestampTokens.add(new TimeStampToken(new CMSSignedData((InputStream)new ByteArrayInputStream(((EncapsulatedPKIDataType)object).getValue()))));
            }
            catch (Exception e) {
                throw new IOException("failed creating timestamp token from EncapsulatedPKIDataType value: " + e.getMessage(), e);
            }
        }
        return new SignatureTimestamp(XMLOIDJCEAlgorithmMapper.getMapper().mapOIDAlgorithmXML(((TimeStampToken)timestampTokens.get(0)).getTimeStampInfo().getMessageImprintAlgOID().getId()), timestampTokens, true, VERSION_SIGNATURE_TIMESTAMP);
    }

    public XAdESTimeStampType encode(SignatureTimestamp signatureTimestamp, XMLSigningContext context) throws IOException {
        Collection certificates;
        TimestampServiceResource tspServiceResource = null;
        if (signatureTimestamp.getTimestampService() != null) {
            tspServiceResource = (TimestampServiceResource)signatureTimestamp.getTimestampService();
        } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultTimestampService() != null) {
            tspServiceResource = (TimestampServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultTimestampService();
        } else {
            throw new IOException("failed to create Timestamp, TSP resource not available or missing");
        }
        NodeList signatureValueNodes = XMLToolkit.getNodes(context.sig.getElement(), "./ds:SignatureValue", XMLToolkit.XMLDSIG_CONTEXT);
        if (signatureValueNodes == null || signatureValueNodes.getLength() == 0) {
            throw new RuntimeException("SignatureValue to counter sign not found");
        }
        if (signatureValueNodes.getLength() > 1) {
            throw new RuntimeException("multiple matching SignatureValue to counter sign found");
        }
        Element signatureValueElement = (Element)signatureValueNodes.item(0);
        String signatureValueId = signatureValueElement.getAttribute("Id");
        if (signatureValueId == null || signatureValueId.isEmpty()) {
            signatureValueId = XMLToolkit.createId("SignatureValue", context.usedIDs);
            signatureValueElement.setAttribute("Id", signatureValueId);
        }
        XAdESTimeStampType xadesTimeStamp = this.xadesObjectFactory.createXAdESTimeStampType();
        if (signatureTimestamp == null) {
            return xadesTimeStamp;
        }
        XAdESSignatureTimeStamp xadesSignatureTimeStamp = signatureTimestamp instanceof XAdESSignatureTimeStamp ? (XAdESSignatureTimeStamp)signatureTimestamp : new XAdESSignatureTimeStamp(signatureTimestamp);
        org.w3._2000._09.xmldsig.ObjectFactory dsigObjectFactory = new org.w3._2000._09.xmldsig.ObjectFactory();
        String canonicalizationMethodURI = context.sig.getSignedInfo().getCanonicalizationMethodURI();
        CanonicalizationMethodType canonicalizationMethod = dsigObjectFactory.createCanonicalizationMethodType();
        canonicalizationMethod.setAlgorithm(canonicalizationMethodURI);
        xadesTimeStamp.setCanonicalizationMethod(canonicalizationMethod);
        byte[] digestValue = null;
        try {
            MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(signatureTimestamp.getDigestAlgorithmURI()));
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Canonicalizer.getInstance((String)canonicalizationMethodURI).canonicalizeSubtree((Node)signatureValueElement, (OutputStream)baos);
                digestValue = md.digest(baos.toByteArray());
            }
        }
        catch (Exception e) {
            throw new IOException("calculating digest failed: " + e.getMessage(), e);
        }
        TimeStampToken timeStamp = tspServiceResource.getTimeStamp(signatureTimestamp.getDigestAlgorithmURI(), digestValue);
        EncapsulatedPKIDataType encapsulatedPKIData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
        encapsulatedPKIData.setEncoding(XAdESEncoding.DER.getEncodingURI());
        encapsulatedPKIData.setValue(timeStamp.getEncoded());
        xadesTimeStamp.getEncapsulatedTimeStampOrXMLTimeStamp().add(encapsulatedPKIData);
        if (context.unsignedProperties.getUnsignedSignatureProperties() == null) {
            context.unsignedProperties.setUnsignedSignatureProperties(this.xadesObjectFactory.createUnsignedSignaturePropertiesType());
        }
        JAXBElement signatureTimeStamp = this.xadesObjectFactory.createSignatureTimeStamp(xadesTimeStamp);
        ((XAdESTimeStampType)signatureTimeStamp.getValue()).setId(XMLToolkit.createId("SignatureTimeStamp", context.usedIDs));
        context.unsignedProperties.getUnsignedSignatureProperties().getCounterSignatureOrSignatureTimeStampOrCompleteCertificateRefs().add(signatureTimeStamp);
        context.signatureTimeStampToken = timeStamp;
        if (xadesSignatureTimeStamp.isValidationDataUsed() && (certificates = timeStamp.getCertificates().getMatches(null)) != null && !certificates.isEmpty()) {
            X509CRL[] crls;
            EncapsulatedPKIDataType ocspEncapsulatedPKIData;
            OCSPResp[] ocspResps;
            ValidationDataType validationData = this.xadesv141ObjectFactory.createValidationDataType();
            validationData.setCertificateValues(this.xadesObjectFactory.createCertificateValuesType());
            ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
            for (Object certificate : certificates) {
                try {
                    byte[] certBytes = null;
                    if (!(certificate instanceof X509CertificateHolder)) continue;
                    X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)certificate;
                    x509Certificates.add(new JcaX509CertificateConverter().getCertificate(x509CertificateHolder));
                    certBytes = x509CertificateHolder.getEncoded();
                    EncapsulatedPKIDataType encapsulatedPKIDataType = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                    encapsulatedPKIDataType.setEncoding(XAdESEncoding.CER.getEncodingURI());
                    encapsulatedPKIDataType.setValue(certBytes);
                    validationData.getCertificateValues().getEncapsulatedX509CertificateOrOtherCertificate().add(encapsulatedPKIDataType);
                }
                catch (Exception e) {
                    throw new IOException("creating certificates for ValidationData failed: " + e.getMessage(), e);
                }
            }
            CertificateValidationServiceResource cvs = null;
            if (xadesSignatureTimeStamp.areOCSPResponsesUsed() || xadesSignatureTimeStamp.areCRLsUsed()) {
                validationData.setRevocationValues(this.xadesObjectFactory.createRevocationValuesType());
                if (xadesSignatureTimeStamp.getCertificateValidationService() != null) {
                    cvs = (CertificateValidationServiceResource)xadesSignatureTimeStamp.getCertificateValidationService();
                } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultCertificateValidationService() != null) {
                    cvs = (CertificateValidationServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultCertificateValidationService();
                } else {
                    throw new IOException("CVS resource not available or missing");
                }
            }
            if (xadesSignatureTimeStamp.areOCSPResponsesUsed() && (ocspResps = cvs.getOcspResponses(null, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (Certificate[])x509Certificates.toArray(new X509Certificate[x509Certificates.size()]))) != null && ocspResps.length != 0) {
                validationData.getRevocationValues().setOCSPValues(this.xadesObjectFactory.createOCSPValuesType());
                OCSPValuesType ocspValues = validationData.getRevocationValues().getOCSPValues();
                for (OCSPResp oCSPResp : ocspResps) {
                    ocspEncapsulatedPKIData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                    ocspEncapsulatedPKIData.setEncoding(XAdESEncoding.DER.getEncodingURI());
                    ocspEncapsulatedPKIData.setValue(oCSPResp.getEncoded());
                    ocspValues.getEncapsulatedOCSPValue().add(ocspEncapsulatedPKIData);
                }
            }
            if (xadesSignatureTimeStamp.areCRLsUsed() && (crls = cvs.getCRLs(null, (Certificate[])x509Certificates.toArray(new X509Certificate[x509Certificates.size()]))) != null && crls.length != 0) {
                validationData.getRevocationValues().setCRLValues(this.xadesObjectFactory.createCRLValuesType());
                CRLValuesType crlValues = validationData.getRevocationValues().getCRLValues();
                for (X509CRL x509CRL : crls) {
                    try {
                        ocspEncapsulatedPKIData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                        ocspEncapsulatedPKIData.setEncoding(XAdESEncoding.DER.getEncodingURI());
                        ocspEncapsulatedPKIData.setValue(x509CRL.getEncoded());
                        crlValues.getEncapsulatedCRLValue().add(ocspEncapsulatedPKIData);
                    }
                    catch (Exception e) {
                        throw new IOException("creating CRLs for ValidationData failed: " + e.getMessage(), e);
                    }
                }
            }
            JAXBElement revocationValues = this.xadesObjectFactory.createRevocationValues(validationData.getRevocationValues());
            context.unsignedProperties.getUnsignedSignatureProperties().getCounterSignatureOrSignatureTimeStampOrCompleteCertificateRefs().add(revocationValues);
        }
        return this.processed;
    }

    public Object getProcessedReturnNullInstance() {
        return this.processed;
    }
}

