/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.AnySignedProperty;
import de.governikus.csl.uom.sign.props.SigPolicyHash;
import de.governikus.csl.uom.sign.props.SignaturePolicyId;
import de.governikus.csl.uom.sign.props.SignaturePolicyIdentifier;
import de.governikus.csl.uom.sign.props.SignaturePolicyQualifier;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import de.governikus.csl.xml.sign.util.XMLToolkit;
import java.io.IOException;
import java.util.List;
import org.etsi.uri._01903.v1_3.AnyType;
import org.etsi.uri._01903.v1_3.SigPolicyQualifiersListType;
import org.etsi.uri._01903.v1_3.SignaturePolicyIdType;
import org.etsi.uri._01903.v1_3.SignaturePolicyIdentifierType;
import org.w3._2000._09.xmldsig.ObjectFactory;
import org.w3._2000._09.xmldsig.TransformType;
import org.w3._2000._09.xmldsig.TransformsType;
import org.w3c.dom.Node;

public class SignaturePolicyIdentifierConverter
extends AbstractXMLSignPropertiesConverter<SignaturePolicyIdentifier, SignaturePolicyIdentifierType> {
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_COMMITMENT = ConstraintSignPolicy.EncodingConstraint.DEFAULT;
    private org.etsi.uri._01903.v1_3.ObjectFactory xadesObjectFactory = new org.etsi.uri._01903.v1_3.ObjectFactory();
    private ObjectFactory dsigObjectFactory = new ObjectFactory();

    public SignaturePolicyIdentifierConverter() {
        super(SignaturePolicyIdentifier.class, SignaturePolicyIdentifierType.class, true, VERSION_COMMITMENT);
    }

    public <T extends SignaturePolicyIdentifierType> SignaturePolicyIdentifier decode(T commitmentType) {
        if (commitmentType == null) {
            return null;
        }
        return null;
    }

    public SignaturePolicyIdentifierType encode(SignaturePolicyIdentifier signaturePolicyIdentifier, XMLSigningContext cache) throws IOException {
        if (signaturePolicyIdentifier == null) {
            return null;
        }
        SignaturePolicyIdentifierType result = this.xadesObjectFactory.createSignaturePolicyIdentifierType();
        try {
            SignaturePolicyId id = signaturePolicyIdentifier.getId();
            List qualifiers = id.getQualifiers();
            SignaturePolicyIdType signaturePolicyId = this.xadesObjectFactory.createSignaturePolicyIdType();
            signaturePolicyId.setSigPolicyId(XMLToolkit.createObjectIdentifier((AnySignedProperty<String>)id.getPolicyId(), "SigPolicyId"));
            result.setSignaturePolicyId(signaturePolicyId);
            TransformsType transforms = this.dsigObjectFactory.createTransformsType();
            TransformType transform = this.dsigObjectFactory.createTransformType();
            transform.setAlgorithm(id.getTransformURI());
            transforms.getTransform().add(transform);
            SigPolicyHash sigPolicyHash = id.getSigPolicyHash();
            signaturePolicyId.setSigPolicyHash(XMLToolkit.createDigestAlgAndValueType(sigPolicyHash.getDigestAlgorithmURI(), sigPolicyHash.getDigestValue()));
            if (qualifiers != null && !qualifiers.isEmpty()) {
                signaturePolicyId.setSigPolicyQualifiers(this.xadesObjectFactory.createSigPolicyQualifiersListType());
                SigPolicyQualifiersListType sigPolicyQualifiers = signaturePolicyId.getSigPolicyQualifiers();
                for (SignaturePolicyQualifier qualifier : qualifiers) {
                    AnyType anyType = this.xadesObjectFactory.createAnyType();
                    Node anyNode = qualifier.getAnyNode();
                    if (anyNode == null) {
                        anyType.getContent().add(this.xadesObjectFactory.createSPURI((String)qualifier.getAny()));
                    } else {
                        anyType.getContent().add(anyNode);
                    }
                    sigPolicyQualifiers.getSigPolicyQualifier().add(anyType);
                }
            }
        }
        catch (Throwable e) {
            throw new IOException("failed to create SignaturePolicyIdentifierType: " + e.getMessage(), e);
        }
        return result;
    }
}

