/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.sign.props.SelfProcessingSignPropertiesEncoder;
import de.governikus.csl.uom.res.CertificateValidationServiceResource;
import de.governikus.csl.uom.res.TrustedAnchorServiceResource;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.props.RevocationValues;
import de.governikus.csl.uom.sign.props.XAdESEncoding;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.etsi.uri._01903.v1_3.CRLValuesType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.OCSPValuesType;
import org.etsi.uri._01903.v1_3.RevocationValuesType;
import org.etsi.uri._01903.v1_4.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationValuesAdder
extends AbstractXMLSignPropertiesConverter<RevocationValues, RevocationValuesType>
implements SelfProcessingSignPropertiesEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevocationValuesAdder.class);
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_REVOCATION_VALUES = ConstraintSignPolicy.EncodingConstraint.DEFAULT;
    private final RevocationValuesType processed;
    private final org.etsi.uri._01903.v1_3.ObjectFactory xadesObjectFactory = new org.etsi.uri._01903.v1_3.ObjectFactory();
    private final ObjectFactory xadesv141ObjectFactory = new ObjectFactory();

    public RevocationValuesAdder() {
        super(RevocationValues.class, RevocationValuesType.class, true, VERSION_REVOCATION_VALUES);
        this.processed = this.xadesObjectFactory.createRevocationValuesType();
    }

    public <T extends RevocationValuesType> RevocationValues decode(T revocationValues) throws IOException {
        ArrayList<OCSPResp> ocspResps = new ArrayList<OCSPResp>();
        ArrayList<CRL> cRLs = new ArrayList<CRL>();
        if (revocationValues.getCRLValues() != null) {
            CertificateFactory cf = null;
            try {
                cf = CryptoProviderUtil.getCertificateFactoryInstance((String)"X.509");
            }
            catch (Exception e) {
                throw new IOException("failed to create CertificateFactory instance");
            }
            for (EncapsulatedPKIDataType encapsulatedPKIdata : revocationValues.getCRLValues().getEncapsulatedCRLValue()) {
                try {
                    cRLs.add(cf.generateCRL(new ByteArrayInputStream(encapsulatedPKIdata.getValue())));
                }
                catch (Exception e) {
                    throw new IOException("failed creating CRL from EncapsulatedPKIDataType value: " + e.getMessage(), e);
                }
            }
        }
        if (revocationValues.getOCSPValues() != null) {
            for (EncapsulatedPKIDataType encapsulatedPKIdata : revocationValues.getOCSPValues().getEncapsulatedOCSPValue()) {
                try {
                    ocspResps.add(new OCSPResp(encapsulatedPKIdata.getValue()));
                }
                catch (Exception e) {
                    throw new IOException("failed creating OCSP responses from EncapsulatedPKIDataType value: " + e.getMessage(), e);
                }
            }
        }
        return new RevocationValues(ocspResps, cRLs, true, VERSION_REVOCATION_VALUES);
    }

    public RevocationValuesType encode(RevocationValues revocationValues, XMLSigningContext context) throws IOException {
        TrustedAnchorServiceResource trustedAnchorService = null;
        if (revocationValues.getTrustedAnchorService() != null) {
            trustedAnchorService = (TrustedAnchorServiceResource)revocationValues.getTrustedAnchorService();
        } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultTrustedAnchorService() != null) {
            trustedAnchorService = (TrustedAnchorServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultTrustedAnchorService();
        } else {
            throw new IOException("Trusted anchor resource not available or missing");
        }
        CertificateValidationServiceResource certificateValidationService = null;
        if (revocationValues.getCertificateValidationService() != null) {
            certificateValidationService = (CertificateValidationServiceResource)revocationValues.getCertificateValidationService();
        } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultCertificateValidationService() != null) {
            certificateValidationService = (CertificateValidationServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultCertificateValidationService();
        } else {
            throw new IOException("CVS resource not available or missing");
        }
        context.xmlRevocationValues = this.xadesObjectFactory.createRevocationValuesType();
        Certificate[] signerCertificates = trustedAnchorService.getCertificateChain((Certificate)context.signerCert);
        if (signerCertificates != null && signerCertificates.length > 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("signerCertificates: " + signerCertificates.length);
            }
            this.addRevocationValues(revocationValues, certificateValidationService, context.xmlRevocationValues, Arrays.asList(signerCertificates));
        }
        if (context.signatureTimeStampToken != null) {
            Collection certificates = context.signatureTimeStampToken.getCertificates().getMatches(null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("timestamp Certificates: " + certificates.size());
            }
            this.addRevocationValues(revocationValues, certificateValidationService, context.xmlRevocationValues, certificates);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("complete revocation values: " + (context.xmlRevocationValues.getOCSPValues() == null ? 0 : context.xmlRevocationValues.getOCSPValues().getEncapsulatedOCSPValue().size()) + (context.xmlRevocationValues.getCRLValues() == null ? 0 : context.xmlRevocationValues.getCRLValues().getEncapsulatedCRLValue().size()));
        }
        if ((context.xmlRevocationValues.getOCSPValues() == null || context.xmlRevocationValues.getOCSPValues().getEncapsulatedOCSPValue().isEmpty()) && (context.xmlRevocationValues.getCRLValues() == null || context.xmlRevocationValues.getCRLValues().getEncapsulatedCRLValue().isEmpty())) {
            return this.processed;
        }
        if (context.qualifyingProperties.getUnsignedProperties() == null) {
            context.qualifyingProperties.setUnsignedProperties(this.xadesObjectFactory.createUnsignedPropertiesType());
        }
        if (context.qualifyingProperties.getUnsignedProperties().getUnsignedSignatureProperties() == null) {
            context.qualifyingProperties.getUnsignedProperties().setUnsignedSignatureProperties(this.xadesObjectFactory.createUnsignedSignaturePropertiesType());
        }
        context.qualifyingProperties.getUnsignedProperties().getUnsignedSignatureProperties().getCounterSignatureOrSignatureTimeStampOrCompleteCertificateRefs().add(this.xadesObjectFactory.createRevocationValues(context.xmlRevocationValues));
        return this.processed;
    }

    private void addRevocationValues(RevocationValues revocationValues, CertificateValidationServiceResource certificateValidationService, RevocationValuesType xmlRevocationValues, Collection<?> certificates) throws IOException {
        if (certificates != null && !certificates.isEmpty()) {
            X509CRL[] crls;
            EncapsulatedPKIDataType ocspEncapsulatedPKIData;
            OCSPResp[] ocspResps;
            ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
            for (Object certificate : certificates) {
                try {
                    if (certificate instanceof X509CertificateHolder) {
                        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)certificate;
                        x509Certificates.add(new JcaX509CertificateConverter().getCertificate(x509CertificateHolder));
                        continue;
                    }
                    if (!(certificate instanceof X509Certificate)) continue;
                    x509Certificates.add((X509Certificate)certificate);
                }
                catch (Exception exception) {
                    throw new IOException("creating certificates for ValidationData failed: " + exception.getMessage(), exception);
                }
            }
            if (revocationValues.areOCSPResponsesUsed() && (ocspResps = certificateValidationService.getOcspResponses(null, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (Certificate[])x509Certificates.toArray(new X509Certificate[x509Certificates.size()]))) != null && ocspResps.length != 0) {
                if (xmlRevocationValues.getOCSPValues() == null) {
                    xmlRevocationValues.setOCSPValues(this.xadesObjectFactory.createOCSPValuesType());
                }
                OCSPValuesType ocspValues = xmlRevocationValues.getOCSPValues();
                for (OCSPResp oCSPResp : ocspResps) {
                    ocspEncapsulatedPKIData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                    ocspEncapsulatedPKIData.setEncoding(XAdESEncoding.DER.getEncodingURI());
                    ocspEncapsulatedPKIData.setValue(oCSPResp.getEncoded());
                    ocspValues.getEncapsulatedOCSPValue().add(ocspEncapsulatedPKIData);
                }
            }
            if (revocationValues.areCRLsUsed() && (crls = certificateValidationService.getCRLs(null, (Certificate[])x509Certificates.toArray(new X509Certificate[x509Certificates.size()]))) != null && crls.length != 0) {
                if (xmlRevocationValues.getCRLValues() == null) {
                    xmlRevocationValues.setCRLValues(this.xadesObjectFactory.createCRLValuesType());
                }
                CRLValuesType crlValues = xmlRevocationValues.getCRLValues();
                for (X509CRL x509CRL : crls) {
                    try {
                        ocspEncapsulatedPKIData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                        ocspEncapsulatedPKIData.setEncoding(XAdESEncoding.DER.getEncodingURI());
                        ocspEncapsulatedPKIData.setValue(x509CRL.getEncoded());
                        crlValues.getEncapsulatedCRLValue().add(ocspEncapsulatedPKIData);
                    }
                    catch (Exception e) {
                        throw new IOException("creating CRLs for ValidationData failed: " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    public Object getProcessedReturnNullInstance() {
        return this.processed;
    }
}

