/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.ProductionPlace;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import org.etsi.uri._01903.v1_3.ObjectFactory;
import org.etsi.uri._01903.v1_3.SignatureProductionPlaceV2Type;

public class ProductionPlaceConverterV2
extends AbstractXMLSignPropertiesConverter<ProductionPlace, SignatureProductionPlaceV2Type> {
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_PRODUCTION_PLACE = ConstraintSignPolicy.EncodingConstraint.ETSI_EN;
    ObjectFactory xadesObjectFactory = new ObjectFactory();

    public ProductionPlaceConverterV2() {
        super(ProductionPlace.class, SignatureProductionPlaceV2Type.class, true, VERSION_PRODUCTION_PLACE);
    }

    public <T extends SignatureProductionPlaceV2Type> ProductionPlace decode(T signatureProductionPlace) {
        String city = null;
        String countryName = null;
        String postalCode = null;
        String stateOrProvince = null;
        String streetAddress = null;
        if (signatureProductionPlace != null) {
            city = signatureProductionPlace.getCity();
            countryName = signatureProductionPlace.getCountryName();
            postalCode = signatureProductionPlace.getPostalCode();
            stateOrProvince = signatureProductionPlace.getStateOrProvince();
            streetAddress = signatureProductionPlace.getStreetAddress();
        }
        return new ProductionPlace(city, countryName, postalCode, stateOrProvince, streetAddress, false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_PRODUCTION_PLACE});
    }

    public SignatureProductionPlaceV2Type encode(ProductionPlace productionPlace, XMLSigningContext cache) {
        SignatureProductionPlaceV2Type signatureProductionPlace = this.xadesObjectFactory.createSignatureProductionPlaceV2Type();
        if (productionPlace == null) {
            return signatureProductionPlace;
        }
        signatureProductionPlace.setCity(productionPlace.getCity());
        signatureProductionPlace.setCountryName(productionPlace.getCountryName());
        signatureProductionPlace.setPostalCode(productionPlace.getPostalCode());
        signatureProductionPlace.setStateOrProvince(productionPlace.getStateOrProvince());
        signatureProductionPlace.setStreetAddress(productionPlace.getStreetAddress());
        return signatureProductionPlace;
    }
}

