/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.ProductionPlace;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import org.etsi.uri._01903.v1_3.ObjectFactory;
import org.etsi.uri._01903.v1_3.SignatureProductionPlaceType;

public class ProductionPlaceConverter
extends AbstractXMLSignPropertiesConverter<ProductionPlace, SignatureProductionPlaceType> {
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_PRODUCTION_PLACE = ConstraintSignPolicy.EncodingConstraint.ETSI_TS;
    ObjectFactory xadesObjectFactory = new ObjectFactory();

    public ProductionPlaceConverter() {
        super(ProductionPlace.class, SignatureProductionPlaceType.class, false, VERSION_PRODUCTION_PLACE);
    }

    public <T extends SignatureProductionPlaceType> ProductionPlace decode(T signatureProductionPlace) {
        String city = null;
        String countryName = null;
        String postalCode = null;
        String stateOrProvince = null;
        if (signatureProductionPlace != null) {
            city = signatureProductionPlace.getCity();
            countryName = signatureProductionPlace.getCountryName();
            postalCode = signatureProductionPlace.getPostalCode();
            stateOrProvince = signatureProductionPlace.getStateOrProvince();
        }
        return new ProductionPlace(city, countryName, postalCode, stateOrProvince, null, true, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_PRODUCTION_PLACE});
    }

    public SignatureProductionPlaceType encode(ProductionPlace productionPlace, XMLSigningContext cache) {
        SignatureProductionPlaceType signatureProductionPlace = this.xadesObjectFactory.createSignatureProductionPlaceType();
        if (productionPlace == null) {
            return signatureProductionPlace;
        }
        signatureProductionPlace.setCity(productionPlace.getCity());
        signatureProductionPlace.setCountryName(productionPlace.getCountryName());
        signatureProductionPlace.setPostalCode(productionPlace.getPostalCode());
        signatureProductionPlace.setStateOrProvince(productionPlace.getStateOrProvince());
        return signatureProductionPlace;
    }
}

