/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.sign.props.SelfProcessingSignPropertiesEncoder;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.res.CertificateValidationServiceResource;
import de.governikus.csl.uom.res.TimestampServiceResource;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.props.ContentTimestamp;
import de.governikus.csl.uom.sign.props.XAdESEncoding;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.impl.ToSignDocument;
import de.governikus.csl.xml.sign.impl.XMLSignPluginImpl;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import de.governikus.csl.xml.sign.props.XAdESContentTimeStamp;
import de.governikus.csl.xml.sign.util.XMLToolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.xml.security.signature.Reference;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TimeStampToken;
import org.etsi.uri._01903.v1_3.CRLValuesType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.IncludeType;
import org.etsi.uri._01903.v1_3.OCSPValuesType;
import org.etsi.uri._01903.v1_3.XAdESTimeStampType;
import org.etsi.uri._01903.v1_4.ObjectFactory;
import org.etsi.uri._01903.v1_4.ValidationDataType;

public class ContentTimestampCreator
extends AbstractXMLSignPropertiesConverter<ContentTimestamp, XAdESTimeStampType>
implements SelfProcessingSignPropertiesEncoder {
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_CONTENT_TIMESTAMP = ConstraintSignPolicy.EncodingConstraint.DEFAULT;
    private final XAdESTimeStampType processed;
    private final org.etsi.uri._01903.v1_3.ObjectFactory xadesObjectFactory = new org.etsi.uri._01903.v1_3.ObjectFactory();
    private final ObjectFactory xadesv141ObjectFactory = new ObjectFactory();

    public ContentTimestampCreator() {
        super(ContentTimestamp.class, XAdESTimeStampType.class, true, VERSION_CONTENT_TIMESTAMP);
        this.processed = this.xadesObjectFactory.createXAdESTimeStampType();
    }

    public <T extends XAdESTimeStampType> ContentTimestamp decode(T timestamp) throws IOException {
        ArrayList<TimeStampToken> timestampTokens = new ArrayList<TimeStampToken>();
        for (Object object : timestamp.getEncapsulatedTimeStampOrXMLTimeStamp()) {
            if (!(object instanceof EncapsulatedPKIDataType)) continue;
            try {
                timestampTokens.add(new TimeStampToken(new CMSSignedData((InputStream)new ByteArrayInputStream(((EncapsulatedPKIDataType)object).getValue()))));
            }
            catch (Exception e) {
                throw new IOException("failed creating timestamp token from EncapsulatedPKIDataType value: " + e.getMessage(), e);
            }
        }
        return new ContentTimestamp(XMLOIDJCEAlgorithmMapper.getMapper().mapOIDAlgorithmXML(((TimeStampToken)timestampTokens.get(0)).getTimeStampInfo().getMessageImprintAlgOID().getId()), timestampTokens, true, VERSION_CONTENT_TIMESTAMP);
    }

    public XAdESTimeStampType encode(ContentTimestamp contentTimestamp, XMLSigningContext context) throws IOException {
        Collection certificates;
        TimestampServiceResource tspServiceResource = null;
        if (contentTimestamp.getTimestampService() != null) {
            tspServiceResource = (TimestampServiceResource)contentTimestamp.getTimestampService();
        } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultTimestampService() != null) {
            tspServiceResource = (TimestampServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultTimestampService();
        } else {
            throw new IOException("failed to create Timestamp, TSP resource not available or missing");
        }
        XAdESTimeStampType xadesTimeStamp = this.xadesObjectFactory.createXAdESTimeStampType();
        if (contentTimestamp == null) {
            return xadesTimeStamp;
        }
        XAdESContentTimeStamp xadesContentTimeStamp = contentTimestamp instanceof XAdESContentTimeStamp ? (XAdESContentTimeStamp)contentTimestamp : new XAdESContentTimeStamp(contentTimestamp);
        List<String> includedURIs = xadesContentTimeStamp.getIncludedURIs();
        boolean allDataObjectTimeStamp = includedURIs == null || includedURIs.isEmpty();
        byte[] digestValue = null;
        try {
            MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(contentTimestamp.getDigestAlgorithmURI()));
            for (int i = 0; i < context.sig.getSignedInfo().getLength(); ++i) {
                Reference reference = context.sig.getSignedInfo().item(i);
                if (XMLSignPluginImpl.XADES_REFERENCE_TYPES_SIGNED_PROPERTIES.contains(reference.getURI())) continue;
                String documentURI = null;
                for (ToSignDocument d : context.mapUriUOMDocuments.values()) {
                    if (!d.refIdObjectToSign.equals(reference.getId())) continue;
                    documentURI = d.document.getName();
                    break;
                }
                if (i != 0 && !allDataObjectTimeStamp && !includedURIs.contains(documentURI)) continue;
                md.update(reference.getReferencedBytes());
                if (allDataObjectTimeStamp) continue;
                IncludeType include = this.xadesObjectFactory.createIncludeType();
                include.setURI("#" + reference.getId());
                xadesTimeStamp.getInclude().add(include);
            }
            digestValue = md.digest();
        }
        catch (Exception e) {
            throw new IOException("calculating digest failed: " + e.getMessage(), e);
        }
        TimeStampToken timeStamp = tspServiceResource.getTimeStamp(contentTimestamp.getDigestAlgorithmURI(), digestValue);
        String timestampId = XMLToolkit.createId("contentTimeStamp", context.usedIDs);
        EncapsulatedPKIDataType encapsulatedPKIData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
        encapsulatedPKIData.setEncoding(XAdESEncoding.DER.getEncodingURI());
        encapsulatedPKIData.setValue(timeStamp.getEncoded());
        encapsulatedPKIData.setId(timestampId);
        xadesTimeStamp.getEncapsulatedTimeStampOrXMLTimeStamp().add(encapsulatedPKIData);
        if (allDataObjectTimeStamp) {
            context.signedProperties.getSignedDataObjectProperties().getAllDataObjectsTimeStamp().add(xadesTimeStamp);
        } else {
            context.signedProperties.getSignedDataObjectProperties().getIndividualDataObjectsTimeStamp().add(xadesTimeStamp);
        }
        if (xadesContentTimeStamp.isValidationDataUsed() && (certificates = timeStamp.getCertificates().getMatches(null)) != null && !certificates.isEmpty()) {
            X509CRL[] crls;
            OCSPResp[] ocspResps;
            ValidationDataType validationData = this.xadesv141ObjectFactory.createValidationDataType();
            validationData.setCertificateValues(this.xadesObjectFactory.createCertificateValuesType());
            ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
            for (Object certificate : certificates) {
                try {
                    byte[] certBytes = null;
                    if (!(certificate instanceof X509CertificateHolder)) continue;
                    X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)certificate;
                    x509Certificates.add(new JcaX509CertificateConverter().getCertificate(x509CertificateHolder));
                    certBytes = x509CertificateHolder.getEncoded();
                    EncapsulatedPKIDataType encapsulatedPKIDataType = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                    encapsulatedPKIDataType.setEncoding(XAdESEncoding.CER.getEncodingURI());
                    encapsulatedPKIDataType.setValue(certBytes);
                    validationData.getCertificateValues().getEncapsulatedX509CertificateOrOtherCertificate().add(encapsulatedPKIDataType);
                }
                catch (Exception e) {
                    throw new IOException("creating certificates for ValidationData failed: " + e.getMessage(), e);
                }
            }
            CertificateValidationServiceResource cvs = null;
            if (xadesContentTimeStamp.areOCSPResponsesUsed() || xadesContentTimeStamp.areCRLsUsed()) {
                validationData.setRevocationValues(this.xadesObjectFactory.createRevocationValuesType());
                if (contentTimestamp.getCertificateValidationService() != null) {
                    cvs = (CertificateValidationServiceResource)contentTimestamp.getCertificateValidationService();
                } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultCertificateValidationService() != null) {
                    cvs = (CertificateValidationServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultCertificateValidationService();
                } else {
                    throw new IOException("CVS resource not available or missing");
                }
            }
            if (xadesContentTimeStamp.areOCSPResponsesUsed() && (ocspResps = cvs.getOcspResponses(null, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (Certificate[])x509Certificates.toArray(new X509Certificate[x509Certificates.size()]))) != null && ocspResps.length != 0) {
                validationData.getRevocationValues().setOCSPValues(this.xadesObjectFactory.createOCSPValuesType());
                OCSPValuesType ocspValues = validationData.getRevocationValues().getOCSPValues();
                for (OCSPResp oCSPResp : ocspResps) {
                    EncapsulatedPKIDataType ocspEncapsulatedPKIData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                    ocspEncapsulatedPKIData.setEncoding(XAdESEncoding.DER.getEncodingURI());
                    ocspEncapsulatedPKIData.setValue(oCSPResp.getEncoded());
                    ocspValues.getEncapsulatedOCSPValue().add(ocspEncapsulatedPKIData);
                }
            }
            if (xadesContentTimeStamp.areCRLsUsed() && (crls = cvs.getCRLs(null, (Certificate[])x509Certificates.toArray(new X509Certificate[x509Certificates.size()]))) != null && crls.length != 0) {
                validationData.getRevocationValues().setCRLValues(this.xadesObjectFactory.createCRLValuesType());
                CRLValuesType crlValues = validationData.getRevocationValues().getCRLValues();
                for (X509CRL x509CRL : crls) {
                    try {
                        EncapsulatedPKIDataType crlEncapsulatedPKIData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                        crlEncapsulatedPKIData.setEncoding(XAdESEncoding.DER.getEncodingURI());
                        crlEncapsulatedPKIData.setValue(x509CRL.getEncoded());
                        crlValues.getEncapsulatedCRLValue().add(crlEncapsulatedPKIData);
                    }
                    catch (Exception e) {
                        throw new IOException("creating CRLs for ValidationData failed: " + e.getMessage(), e);
                    }
                }
            }
            try {
                if (context.unsignedProperties == null) {
                    context.unsignedProperties = this.xadesObjectFactory.createUnsignedPropertiesType();
                    context.qualifyingProperties.setUnsignedProperties(context.unsignedProperties);
                }
                if (context.unsignedProperties.getUnsignedSignatureProperties() == null) {
                    context.unsignedProperties.setUnsignedSignatureProperties(this.xadesObjectFactory.createUnsignedSignaturePropertiesType());
                }
                validationData.setId(XMLToolkit.createId("validationData", context.usedIDs));
                validationData.setURI("#" + timestampId);
                JAXBElement timeStampValidationData = this.xadesv141ObjectFactory.createTimeStampValidationData(validationData);
                context.unsignedProperties.getUnsignedSignatureProperties().getCounterSignatureOrSignatureTimeStampOrCompleteCertificateRefs().add(timeStampValidationData);
            }
            catch (Exception e) {
                throw new IOException("failed to create ValidationData node: " + e.getMessage(), e);
            }
        }
        return this.processed;
    }

    public Object getProcessedReturnNullInstance() {
        return this.processed;
    }
}

