/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.AnySignedProperty;
import de.governikus.csl.uom.sign.props.CommitmentQualifier;
import de.governikus.csl.uom.sign.props.CommitmentTypeIndication;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import de.governikus.csl.xml.sign.util.XMLToolkit;
import java.io.IOException;
import java.util.List;
import org.etsi.uri._01903.v1_3.AnyType;
import org.etsi.uri._01903.v1_3.CommitmentTypeIndicationType;
import org.etsi.uri._01903.v1_3.ObjectFactory;
import org.w3c.dom.Node;

public class CommitmentIndicationConverter
extends AbstractXMLSignPropertiesConverter<CommitmentTypeIndication, CommitmentTypeIndicationType> {
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_COMMITMENT = ConstraintSignPolicy.EncodingConstraint.DEFAULT;
    ObjectFactory xadesObjectFactory = new ObjectFactory();

    public CommitmentIndicationConverter() {
        super(CommitmentTypeIndication.class, CommitmentTypeIndicationType.class, true, VERSION_COMMITMENT);
    }

    public <T extends CommitmentTypeIndicationType> CommitmentTypeIndication decode(T commitmentType) {
        if (commitmentType == null) {
            return null;
        }
        return null;
    }

    public CommitmentTypeIndicationType encode(CommitmentTypeIndication commitmentTypeIndication, XMLSigningContext cache) throws IOException {
        if (commitmentTypeIndication == null) {
            return null;
        }
        CommitmentTypeIndicationType result = this.xadesObjectFactory.createCommitmentTypeIndicationType();
        try {
            result.setCommitmentTypeId(XMLToolkit.createObjectIdentifier((AnySignedProperty<String>)commitmentTypeIndication.getTypeId(), "CommitmentTypeId"));
        }
        catch (Throwable e) {
            throw new IOException("failed to create ObjectIdentifierType: " + e.getMessage(), e);
        }
        for (String reference : cache.docReferencesSet) {
            if (!(reference instanceof String)) continue;
            result.getObjectReference().add("#" + reference);
        }
        List qualifiers = commitmentTypeIndication.getQualifiers();
        if (qualifiers == null || qualifiers.isEmpty()) {
            throw new IllegalArgumentException("qualfiers missing");
        }
        result.setCommitmentTypeQualifiers(this.xadesObjectFactory.createCommitmentTypeQualifiersListType());
        for (CommitmentQualifier qualifier : qualifiers) {
            AnyType anyType = this.xadesObjectFactory.createAnyType();
            Node anyNode = qualifier.getAnyNode();
            anyType.getContent().add(anyNode == null ? qualifier.getAny() : anyNode);
            result.getCommitmentTypeQualifiers().getCommitmentTypeQualifier().add(anyType);
        }
        return result;
    }
}

