/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.props;

import de.governikus.csl.sign.props.SelfProcessingSignPropertiesEncoder;
import de.governikus.csl.uom.res.TrustedAnchorServiceResource;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.props.CertificateValues;
import de.governikus.csl.uom.sign.props.XAdESEncoding;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.props.AbstractXMLSignPropertiesConverter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cert.X509CertificateHolder;
import org.etsi.uri._01903.v1_3.CertificateValuesType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValuesAdder
extends AbstractXMLSignPropertiesConverter<CertificateValues, CertificateValuesType>
implements SelfProcessingSignPropertiesEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateValuesAdder.class);
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_CERTIFICATE_VALUES = ConstraintSignPolicy.EncodingConstraint.DEFAULT;
    private final CertificateValuesType processed;
    private final ObjectFactory xadesObjectFactory = new ObjectFactory();

    public CertificateValuesAdder() {
        super(CertificateValues.class, CertificateValuesType.class, true, VERSION_CERTIFICATE_VALUES);
        this.processed = this.xadesObjectFactory.createCertificateValuesType();
    }

    public <T extends CertificateValuesType> CertificateValues decode(T certificateValues) throws IOException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        CertificateFactory cf = null;
        try {
            cf = CryptoProviderUtil.getCertificateFactoryInstance((String)"X.509");
        }
        catch (Exception e) {
            throw new IOException("failed to create CertificateFactory instance");
        }
        for (Object object : certificateValues.getEncapsulatedX509CertificateOrOtherCertificate()) {
            if (!(object instanceof EncapsulatedPKIDataType)) continue;
            try {
                certificates.add(cf.generateCertificate(new ByteArrayInputStream(((EncapsulatedPKIDataType)object).getValue())));
            }
            catch (Exception e) {
                throw new IOException("failed creating certificate EncapsulatedPKIDataType value: " + e.getMessage(), e);
            }
        }
        return new CertificateValues(certificates, true, VERSION_CERTIFICATE_VALUES);
    }

    public CertificateValuesType encode(CertificateValues certificateValues, XMLSigningContext context) throws IOException {
        TrustedAnchorServiceResource trustedAnchorService = null;
        if (certificateValues.getTrustedAnchorService() != null) {
            trustedAnchorService = (TrustedAnchorServiceResource)certificateValues.getTrustedAnchorService();
        } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultTrustedAnchorService() != null) {
            trustedAnchorService = (TrustedAnchorServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultTrustedAnchorService();
        } else {
            throw new IOException("Trusted anchor resource not available or missing");
        }
        context.xmlCertificateValues = this.xadesObjectFactory.createCertificateValuesType();
        Certificate[] signerCertificates = trustedAnchorService.getCertificateChain((Certificate)context.signerCert);
        if (signerCertificates != null && signerCertificates.length > 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("signerCertificates: " + signerCertificates.length);
            }
            this.addCertificates(context.xmlCertificateValues, Arrays.asList(signerCertificates));
        }
        if (context.signatureTimeStampToken != null) {
            Collection certificates = context.signatureTimeStampToken.getCertificates().getMatches(null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("timestamp Certificates: " + certificates.size());
            }
            if (certificates != null && !certificates.isEmpty()) {
                this.addCertificates(context.xmlCertificateValues, certificates);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("complete Certificates: " + context.xmlCertificateValues.getEncapsulatedX509CertificateOrOtherCertificate().size());
        }
        if (context.xmlCertificateValues.getEncapsulatedX509CertificateOrOtherCertificate().isEmpty()) {
            context.xmlCertificateValues = null;
            return this.processed;
        }
        if (context.qualifyingProperties.getUnsignedProperties() == null) {
            context.qualifyingProperties.setUnsignedProperties(this.xadesObjectFactory.createUnsignedPropertiesType());
        }
        if (context.qualifyingProperties.getUnsignedProperties().getUnsignedSignatureProperties() == null) {
            context.qualifyingProperties.getUnsignedProperties().setUnsignedSignatureProperties(this.xadesObjectFactory.createUnsignedSignaturePropertiesType());
        }
        context.qualifyingProperties.getUnsignedProperties().getUnsignedSignatureProperties().getCounterSignatureOrSignatureTimeStampOrCompleteCertificateRefs().add(this.xadesObjectFactory.createCertificateValues(context.xmlCertificateValues));
        return this.processed;
    }

    private void addCertificates(CertificateValuesType xmlCertificateValues, Collection<?> certificates) throws IOException {
        for (Object certificate : certificates) {
            try {
                byte[] certBytes = null;
                if (certificate instanceof X509CertificateHolder) {
                    certBytes = ((X509CertificateHolder)certificate).getEncoded();
                } else {
                    if (!(certificate instanceof Certificate)) continue;
                    certBytes = ((Certificate)certificate).getEncoded();
                }
                EncapsulatedPKIDataType certEncapsulatedPKIData = this.xadesObjectFactory.createEncapsulatedPKIDataType();
                certEncapsulatedPKIData.setEncoding(XAdESEncoding.CER.getEncodingURI());
                certEncapsulatedPKIData.setValue(certBytes);
                xmlCertificateValues.getEncapsulatedX509CertificateOrOtherCertificate().add(certEncapsulatedPKIData);
            }
            catch (Exception e) {
                throw new IOException("creating certificates for ValidationData failed: " + e.getMessage(), e);
            }
        }
    }

    public Object getProcessedReturnNullInstance() {
        return this.processed;
    }
}

