/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.impl;

import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.sign.impl.AbstractSignPlugin;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.DataToBeSigned;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Options;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedDataResponse;
import de.governikus.csl.uom.core.SignedDataResponseImpl;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPlugin;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignProperty;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.sign.SignedProperties;
import de.governikus.csl.uom.sign.SignedProperty;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.SigningContext;
import de.governikus.csl.uom.sign.UnsignedProperties;
import de.governikus.csl.uom.sign.UnsignedProperty;
import de.governikus.csl.uom.sign.ades.AdESSignCreationPolicy;
import de.governikus.csl.uom.sign.impl.CounterSignerInfo;
import de.governikus.csl.uom.sign.impl.PreRequestCheckerRegistry;
import de.governikus.csl.uom.sign.props.CertID;
import de.governikus.csl.uom.sign.props.NoSigningTime;
import de.governikus.csl.uom.sign.props.PropertiesUtil;
import de.governikus.csl.uom.sign.props.SigningCertificate;
import de.governikus.csl.uom.sign.props.SigningTime;
import de.governikus.csl.uom.sign.props.XMLDataObjectPropertiesMarker;
import de.governikus.csl.uom.util.CSLDocumentDataHandler;
import de.governikus.csl.uom.util.Environment;
import de.governikus.csl.xml.sign.XMLSignEnvelopingParameters;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.doc.XMLDocument;
import de.governikus.csl.xml.sign.doc.impl.XMLDocumentImpl;
import de.governikus.csl.xml.sign.doc.impl.XMLSimpleParser;
import de.governikus.csl.xml.sign.impl.ToSignDocument;
import de.governikus.csl.xml.sign.impl.XMLResourceResolver;
import de.governikus.csl.xml.sign.impl.XMLSignEnvelopedOptionsImpl;
import de.governikus.csl.xml.sign.props.XMLProperty;
import de.governikus.csl.xml.sign.props.XMLSignPropertiesConverterManager;
import de.governikus.csl.xml.sign.props.XMLSignedProperty;
import de.governikus.csl.xml.sign.props.XMLUnsignedProperty;
import de.governikus.csl.xml.sign.util.XMLToolkit;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.etsi.uri._01903.v1_3.AnyType;
import org.etsi.uri._01903.v1_3.CounterSignatureType;
import org.etsi.uri._01903.v1_3.DataObjectFormatType;
import org.etsi.uri._01903.v1_3.ObjectFactory;
import org.etsi.uri._01903.v1_3.QualifyingPropertiesType;
import org.etsi.uri._01903.v1_3.SignedDataObjectPropertiesType;
import org.etsi.uri._01903.v1_3.SignedPropertiesType;
import org.etsi.uri._01903.v1_3.SignedSignaturePropertiesType;
import org.etsi.uri._01903.v1_3.UnsignedDataObjectPropertiesType;
import org.etsi.uri._01903.v1_3.UnsignedSignaturePropertiesType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig.ObjectType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@PluginType(id=Plugin.PluginID.SIGN_XML, type=SignPlugin.class)
public class XMLSignPluginImpl
extends AbstractSignPlugin {
    public static final String DEFAULT_NAMESPACE_PREFIX_DIGITAL_SIGNATURE = "ds";
    public static final String NODE_NAME_SIGNED_INFO = "SignedInfo";
    public static final String XML_LOCAL_IDREF_PREFIX = "#";
    public static final String NODE_NAME_KEY_INFO = "KeyInfo";
    public static final String NODE_NAME_SIGNATURE = "Signature";
    public static final List<String> XADES_REFERENCE_TYPES_SIGNED_PROPERTIES = Collections.unmodifiableList(Arrays.asList("http://uri.etsi.org/01903#SignedProperties", "http://uri.etsi.org/01903/v1.4.2#SignedProperties", "http://uri.etsi.org/01903/v1.4.1#SignedProperties", "http://uri.etsi.org/01903/v1.3.2#SignedProperties", "http://uri.etsi.org/01903/v1.2.2#SignedProperties", "http://uri.etsi.org/01903/v1.1.1#SignedProperties"));
    public static final List<String> XADES_REFERENCE_TYPES_COUNTER_SIGNATURES = Collections.unmodifiableList(Arrays.asList("http://uri.etsi.org/01903#CountersignedSignature", "http://uri.etsi.org/01903/v1.4.2#CountersignedSignature", "http://uri.etsi.org/01903/v1.4.1#CountersignedSignature", "http://uri.etsi.org/01903/v1.3.2#CountersignedSignature", "http://uri.etsi.org/01903/v1.2.2#CountersignedSignature", "http://uri.etsi.org/01903/v1.1.1#CountersignedSignature"));
    public static final List<Class<? extends Document>> DOCUMENT_OUTPUT_CLASSES = Collections.unmodifiableList(Arrays.asList(XMLDocument.class));
    private XMLSignPropertiesConverterManager adesPropsConverter = XMLSignPropertiesConverterManager.getManager();
    private static final Logger LOG = LoggerFactory.getLogger(XMLSignPluginImpl.class);
    private static final String EXTENSION_XML = ".xml";

    public XMLSignPluginImpl() throws CSLSignatureException {
        super(DOCUMENT_OUTPUT_CLASSES);
        Init.init();
        if (!"CPP".equals(JCEMapper.getProviderId())) {
            JCEMapper.setProviderId((String)"CPP");
        }
        try {
            ElementProxy.registerDefaultPrefixes();
        }
        catch (XMLSecurityException xMLSecurityException) {
            // empty catch block
        }
        try {
            ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)DEFAULT_NAMESPACE_PREFIX_DIGITAL_SIGNATURE);
        }
        catch (XMLSecurityException xMLSecurityException) {
            // empty catch block
        }
    }

    public SignedDataResponse sign(SignRequest signRequest, Environment env) throws CoreException {
        LOG.debug("entering XML/XAdES sign ...");
        boolean allCounterSignerInfo = false;
        AdESSignCreationPolicy adesPolicy = null;
        SignOptions options = null;
        SignPolicy policy = null;
        try {
            LOG.debug("XML/XAdES sign preparing ...");
            XMLSignPluginImpl.checkSignRequest((SignRequest)signRequest);
            JCEMapper.setProviderId((String)"CPP");
            options = (SignOptions)signRequest.getOptions();
            policy = (SignPolicy)options.getPolicy();
            adesPolicy = AdESSignCreationPolicy.getPolicy((SignPolicy)policy);
            allCounterSignerInfo = XMLSignPluginImpl.allCounterSignerInfo((SignOptions)options);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw XMLSignPluginImpl.handleUnknownExceptions((CSLSignatureException.Failure)CSLSignatureException.Failure.SIGNING_PREPARE, (String)"XML/XAdES", (Exception)e);
        }
        try {
            if (allCounterSignerInfo) {
                LOG.debug("XML/XAdES counter signature requested");
                SignedDataResponse e = this.signCounter(signRequest, env);
                return e;
            }
            if (adesPolicy != null || policy != null) {
                LOG.debug("XML/XAdES standard signature requested");
                SignedDataResponse e = this.signAdES(adesPolicy, signRequest, env);
                return e;
            }
            try {
                LOG.debug("XML/XAdES sign prepared");
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "policy is required, null not supported");
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw XMLSignPluginImpl.handleUnknownExceptions((CSLSignatureException.Failure)CSLSignatureException.Failure.SIGNING_UNKNOWN, (String)"XML/XAdES", (Exception)e);
            }
        }
        finally {
            LOG.debug("leaving XML/XAdES sign");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignedDataResponse signCounter(SignRequest signRequest, Environment env) throws CoreException {
        XMLSigningContext context = null;
        Node signedInfoNode = null;
        String refSignatureValueId = null;
        DataObjectFormatType signatureValueDataObjectFormat = null;
        ObjectFactory xadesObjectFactory = null;
        LOG.debug("prepare XAdES counter signing ...");
        try {
            xadesObjectFactory = new ObjectFactory();
            context = this.createContext(signRequest);
            LOG.debug("digest algorithm: {}", (Object)context.algoIdDigest);
            context.mapUriUOMDocuments = ToSignDocument.convertDocs(context, context.usedIDs);
            context.firstToSignDocument = context.mapUriUOMDocuments.values().iterator().next();
            context.mapUriUOMDocuments.clear();
            this.scSetupFirstDocumentToSign(context);
            context.usedIDs.addAll(XMLToolkit.getIds(context.firstToSignDocument.w3Document));
            signedInfoNode = this.getSCSignedInfoNode(context);
            Element signatureValueElement = this.scGetSignatureValueNode(signedInfoNode);
            String signatureValueId = signatureValueElement.getAttribute("Id");
            if (signatureValueId == null || signatureValueId.isEmpty()) {
                signatureValueId = XMLToolkit.createId("SignatureValue", context.usedIDs);
                signatureValueElement.setAttribute("Id", signatureValueId);
            }
            context.baseURI = context.firstToSignDocument.objectType == null ? context.firstToSignDocument.uri : context.firstToSignDocument.objectType.getId();
            context.objectToSign = context.firstToSignDocument.w3Document;
            String canonicalizationURI = "http://www.w3.org/2001/10/xml-exc-c14n#";
            context.sig = new XMLSignature(context.objectToSign, context.baseURI, context.algoIdSignature, canonicalizationURI);
            context.sig.setId(XMLToolkit.createId(NODE_NAME_SIGNATURE, context.usedIDs));
            context.sig.getSignedInfo().setId(XMLToolkit.createId(NODE_NAME_SIGNED_INFO, context.usedIDs));
            context.sig.addKeyInfo(context.signerCert);
            KeyInfo keyInfo = context.sig.getKeyInfo();
            keyInfo.setId(XMLToolkit.createId(NODE_NAME_KEY_INFO, context.usedIDs));
            context.refKeyInfoId = XMLToolkit.createId("refKeyInfo", context.usedIDs);
            context.mapUriFileURLs = new HashMap();
            context.mapUriDocuments = new HashMap();
            context.mapUriDocuments.put(XML_LOCAL_IDREF_PREFIX + keyInfo.getId(), keyInfo.getElement());
            context.mapUriDocuments.put(XML_LOCAL_IDREF_PREFIX + signatureValueId, signatureValueElement);
            context.sig.addResourceResolver((ResourceResolverSpi)new XMLResourceResolver(context));
            Transforms transforms = new Transforms(context.objectToSign);
            transforms.addTransform(canonicalizationURI);
            transforms = new Transforms(context.objectToSign);
            transforms.addTransform(canonicalizationURI);
            context.sig.addDocument(XML_LOCAL_IDREF_PREFIX + keyInfo.getId(), transforms, context.algoIdDigest, context.refKeyInfoId, null);
            transforms = new Transforms(context.objectToSign);
            transforms.addTransform(canonicalizationURI);
            refSignatureValueId = XMLToolkit.createId("refSignatureValue", context.usedIDs);
            context.sig.addDocument(XML_LOCAL_IDREF_PREFIX + signatureValueId, transforms, context.algoIdDigest, refSignatureValueId, XADES_REFERENCE_TYPES_COUNTER_SIGNATURES.get(0));
            signatureValueDataObjectFormat = xadesObjectFactory.createDataObjectFormatType();
            signatureValueDataObjectFormat.setObjectReference(XML_LOCAL_IDREF_PREFIX + refSignatureValueId);
            signatureValueDataObjectFormat.setMimeType("application/xml");
            this.applySignedProperties(context, signatureValueDataObjectFormat);
            context.mapUriDocuments.put(XML_LOCAL_IDREF_PREFIX + context.signedProperties.getId(), context.signedPropertiesNode);
            context.sig.addDocument(XML_LOCAL_IDREF_PREFIX + context.signedProperties.getId(), transforms, context.algoIdDigest, null, XADES_REFERENCE_TYPES_SIGNED_PROPERTIES.get(0));
        }
        catch (CoreException e) {
            throw e;
        }
        catch (TransformationException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign at Santuario transformation: " + e.getMessage(), (Throwable)e);
        }
        catch (XMLSignatureException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign at Santuario signature: " + e.getMessage(), (Throwable)e);
        }
        catch (XMLSecurityException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign at Santuario security: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw XMLSignPluginImpl.handleUnknownExceptions((CSLSignatureException.Failure)CSLSignatureException.Failure.SIGNING_PREPARE, (String)"XML/XAdES counter", (Exception)e);
        }
        finally {
            LOG.debug("XML/XAdES counter sign prepared");
        }
        try {
            LOG.debug("XML/XAdES counter sign processing ...");
            LOG.debug("Start signing");
            context.sig.sign((Key)context.privateKeyResource);
            LOG.debug("Finished signing");
            this.applyUnsignedProperties(context, signatureValueDataObjectFormat);
            LOG.debug("create import SignatureCounter node");
            NamespaceContext contextDSigXAdES13XAdES14 = XMLToolkit.createNamespaceContextDSigXAdES13XAdES14(signedInfoNode.getOwnerDocument());
            NodeList signedPropertiesNodes = this.scGetSignedPropertiesNode(signedInfoNode, contextDSigXAdES13XAdES14);
            Node qualifyingPropertiesNode = signedPropertiesNodes.item(0).getParentNode();
            QualifyingPropertiesType qualifyingProperties = this.scCreateQualifyingProperties(xadesObjectFactory, qualifyingPropertiesNode);
            this.createCounterSignatureNode(qualifyingProperties);
            Node changedQualifyingPropertiesNode = this.scUpdateQualifyingPropertiesNode(qualifyingPropertiesNode, qualifyingProperties);
            this.scPrepareQualifyingProperties(context);
            this.scAddSignatureCounterNode(context, contextDSigXAdES13XAdES14, changedQualifyingPropertiesNode);
            LOG.debug("SignatureCounter node imported");
            LOG.debug("preparing response");
            ArrayList<SimpleSignedData> signedDatas = null;
            try {
                signedDatas = new ArrayList<SimpleSignedData>();
                signedDatas.add(new SimpleSignedData(((DataToBeSigned)signRequest.getDataToBeSigned().get(0)).getDocuments(), (Document)new XMLDocumentImpl("signed-" + context.firstToSignDocument.document.getId() + "-signed", "signed-" + context.firstToSignDocument.document.getContentType(), (CSLDocumentDataHandler<org.w3c.dom.Document>)CSLDocumentDataHandler.createXMLDOMDocumentDataHandler((org.w3c.dom.Document)changedQualifyingPropertiesNode.getOwnerDocument(), (Environment)env))));
            }
            finally {
                LOG.debug("response prepared");
            }
            SignedDataResponseImpl signedDataResponseImpl = new SignedDataResponseImpl(signedDatas);
            return signedDataResponseImpl;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (JAXBException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign at jaxb: " + e.getMessage(), (Throwable)e);
        }
        catch (XMLSignatureException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign at Santuario: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign with io exception: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw XMLSignPluginImpl.handleUnknownExceptions((CSLSignatureException.Failure)CSLSignatureException.Failure.SIGNING_FAILED, (String)"XML/XAdES counter", (Exception)e);
        }
        finally {
            LOG.debug("XML/XAdES counter sign finished");
        }
    }

    private void scSetupFirstDocumentToSign(XMLSigningContext context) throws CSLSignatureException {
        if (!(context.firstToSignDocument.document instanceof XMLDocument)) {
            context.firstToSignDocument.document = new XMLSimpleParser().parseDocument((Options<?>)context.getSignOptions(), context.firstToSignDocument.document);
        }
        if (!(context.firstToSignDocument.document instanceof XMLDocument)) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "can not counter sign unsigned document");
        }
        context.firstToSignDocument.w3Document = (org.w3c.dom.Document)((XMLDocument)context.firstToSignDocument.document).getParsed();
    }

    private Element scGetSignatureValueNode(Node signedInfoNode) throws CSLSignatureException {
        NodeList signatureValueNodes = XMLToolkit.getNodes(signedInfoNode.getParentNode(), "./ds:SignatureValue", XMLToolkit.XMLDSIG_CONTEXT);
        if (signatureValueNodes == null || signatureValueNodes.getLength() == 0) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "SignatureValue to counter sign not found");
        }
        if (signatureValueNodes.getLength() > 1) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "multiple matching SignatureValue to counter sign found");
        }
        return (Element)signatureValueNodes.item(0);
    }

    private Node getSCSignedInfoNode(XMLSigningContext context) throws CSLSignatureException {
        NodeList signedInfoNodes = XMLToolkit.getNodes(context.firstToSignDocument.w3Document, ((CounterSignerInfo)context.signerInfo).getSignatureSelector().toString(), XMLToolkit.XMLDSIG_CONTEXT);
        if (signedInfoNodes == null || signedInfoNodes.getLength() == 0) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "SignedInfo to counter sign not found");
        }
        if (signedInfoNodes.getLength() > 1) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "multiple matching SignedInfo to counter sign found");
        }
        Node signedInfoNode = signedInfoNodes.item(0);
        return signedInfoNode;
    }

    private QualifyingPropertiesType scCreateQualifyingProperties(ObjectFactory xadesObjectFactory, Node qualifyingPropertiesNode) throws JAXBException {
        QualifyingPropertiesType qualifyingProperties = XMLToolkit.nodeToJAXB(QualifyingPropertiesType.class, qualifyingPropertiesNode, org.etsi.uri._01903.v1_4.ObjectFactory.class.getPackage().getName());
        if (qualifyingProperties.getUnsignedProperties() == null) {
            qualifyingProperties.setUnsignedProperties(xadesObjectFactory.createUnsignedPropertiesType());
        }
        if (qualifyingProperties.getUnsignedProperties().getUnsignedSignatureProperties() == null) {
            qualifyingProperties.getUnsignedProperties().setUnsignedSignatureProperties(xadesObjectFactory.createUnsignedSignaturePropertiesType());
        }
        return qualifyingProperties;
    }

    private NodeList scGetSignedPropertiesNode(Node signedInfoNode, NamespaceContext contextDSigXAdES13XAdES14) throws CSLSignatureException {
        NodeList signedPropertiesNodes = XMLToolkit.getNodes(signedInfoNode, "//parent::*//xades:SignedProperties[current()/ds:Reference/@URI=concat('#',@Id)]", contextDSigXAdES13XAdES14);
        if (signedPropertiesNodes == null || signedPropertiesNodes.getLength() == 0) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "SignedProperties not found for SignedInfo to counter sign");
        }
        if (signedPropertiesNodes.getLength() > 1) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "multiple SignedProperties found for SignedInfo to counter sign");
        }
        return signedPropertiesNodes;
    }

    private void createCounterSignatureNode(QualifyingPropertiesType qualifyingProperties) throws JAXBException, PropertyException {
        CounterSignatureType counterSignature = new ObjectFactory().createCounterSignatureType();
        Element counterSignatureNode = XMLToolkit.jaxbToDocument(counterSignature, org.w3._2000._09.xmldsig.ObjectFactory.class.getPackage().getName(), ObjectFactory.class.getPackage().getName()).getDocumentElement();
        qualifyingProperties.getUnsignedProperties().getUnsignedSignatureProperties().getCounterSignatureOrSignatureTimeStampOrCompleteCertificateRefs().add(counterSignatureNode);
    }

    private void scAddSignatureCounterNode(XMLSigningContext context, NamespaceContext contextDSigXAdES13XAdES14, Node changedQualifyingPropertiesNode) {
        Node appendCounterSignatureNode = XMLToolkit.getNodes(changedQualifyingPropertiesNode, "//xades:CounterSignature", contextDSigXAdES13XAdES14).item(0);
        appendCounterSignatureNode.appendChild(changedQualifyingPropertiesNode.getOwnerDocument().importNode(context.sig.getElement(), true));
    }

    private void scPrepareQualifyingProperties(XMLSigningContext context) throws CSLSignatureException {
        try {
            ObjectType qualifyingPropertiesObject = XMLToolkit.createObject(null, null, XMLToolkit.jaxbToElement(context.qualifyingProperties), context.usedIDs);
            context.docQualifiedProps = XMLToolkit.jaxbToDocument(qualifyingPropertiesObject, org.etsi.uri._01903.v1_4.ObjectFactory.class.getPackage().getName());
            context.sig.getElement().appendChild(context.sig.getElement().getOwnerDocument().importNode(context.docQualifiedProps.getDocumentElement(), true));
        }
        catch (JAXBException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to create QualifyingProperties node at JAXB: " + e.getMessage(), (Throwable)e);
        }
        catch (DOMException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to create QualifyingProperties node at XML: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to create QualifyingProperties node: " + e.getMessage(), (Throwable)e);
        }
    }

    private Node scUpdateQualifyingPropertiesNode(Node qualifyingPropertiesNode, QualifyingPropertiesType qualifyingProperties) throws CSLSignatureException {
        Node changedQualifyingPropertiesNode = null;
        try {
            changedQualifyingPropertiesNode = XMLToolkit.jaxbToDocument(qualifyingProperties, org.etsi.uri._01903.v1_4.ObjectFactory.class.getPackage().getName()).getDocumentElement();
        }
        catch (JAXBException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to create changed CounterSigner QualifyingPropertiesNode at JAXB: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to create changed CounterSigner QualifyingPropertiesNode: " + e.getMessage(), (Throwable)e);
        }
        changedQualifyingPropertiesNode = qualifyingPropertiesNode.getOwnerDocument().importNode(changedQualifyingPropertiesNode, true);
        qualifyingPropertiesNode.getParentNode().replaceChild(changedQualifyingPropertiesNode, qualifyingPropertiesNode);
        return changedQualifyingPropertiesNode;
    }

    private XMLSigningContext createContext(SignRequest signRequest) throws CoreException {
        XMLSigningContext context = new XMLSigningContext(signRequest);
        SignOptions signOptions = context.getSignOptions();
        context.signerInfo = (SignerInfo)signOptions.getSignerInfos().iterator().next();
        PropertiesUtil.sort((SignerInfo)context.signerInfo, (SignPolicy)((SignPolicy)signOptions.getPolicy()));
        context.privateKeyResource = (PrivateKeyResourceImpl)context.signerInfo.getKey();
        context.signerCert = (X509Certificate)context.privateKeyResource.getCertificate().certificate();
        context.signerCertChain = context.privateKeyResource.getCertificateChain().certificates();
        context.algoIdSignature = context.signerInfo.getSignatureAlgorithmURI();
        if (context.algoIdSignature == null || context.algoIdSignature.isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "missing signature algorithm");
        }
        context.algoIdDigest = context.signerInfo.getDigestAlgorithmURI();
        if (context.algoIdDigest == null || context.algoIdDigest.isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "missing digest algorithm");
        }
        context.signatureType = ((SignOptions)signRequest.getOptions()).getSignatureType();
        context.signKeyInfoRequired = !PropertiesUtil.existsSignedProperties(SigningCertificate.class, (SignedProperties)context.signerInfo.getSignedProperties());
        context.xmlDocumentsToBeInserted = SignatureType.ENVELOPING == signOptions.getSignatureType() && signOptions instanceof XMLSignEnvelopingParameters ? ((XMLSignEnvelopingParameters)signOptions).areXMLDocumentsToBeInserted() : false;
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignedDataResponse signAdES(AdESSignCreationPolicy adesPolicy, SignRequest signRequest, Environment env) throws CoreException {
        String type = adesPolicy == null ? "XML" : "XAdES";
        XMLSigningContext context = null;
        DocumentBuilder db = null;
        try {
            int docCount;
            LOG.debug("{} check signature request", (Object)type);
            SignedProperties signedProperties = ((SignerInfo)((SignOptions)signRequest.getOptions()).getSignerInfos().iterator().next()).getSignedProperties();
            if (!PropertiesUtil.existsSignedProperties(SigningTime.class, (SignedProperties)signedProperties) && !PropertiesUtil.existsSignedProperties(NoSigningTime.class, (SignedProperties)signedProperties)) {
                signedProperties.add((Object)new SigningTime(new ConstraintSignPolicy.EncodingConstraint[0]));
            }
            PreRequestCheckerRegistry.getRegistry().check(signRequest);
            LOG.debug("prepare {} signing...", (Object)type);
            context = this.createContext(signRequest);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
            dbf.setNamespaceAware(true);
            context.objectToSign = dbf.newDocumentBuilder().newDocument();
            db = dbf.newDocumentBuilder();
            if (context.signatureType == SignatureType.ENVELOPED && (docCount = ((DataToBeSigned)signRequest.getDataToBeSigned().get(0)).getDocuments().size()) != 1) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "only one document supported for signing XML enveloped, documents: " + docCount);
            }
            context.mapUriUOMDocuments = ToSignDocument.convertDocs(context, context.usedIDs);
            context.firstToSignDocument = context.mapUriUOMDocuments.values().iterator().next();
            context.baseURI = context.signatureType == SignatureType.ENVELOPED ? "" : (context.firstToSignDocument.objectType == null ? context.firstToSignDocument.uri : context.firstToSignDocument.objectType.getId());
            String canonicalizationURI = "http://www.w3.org/2001/10/xml-exc-c14n#";
            context.sig = new XMLSignature(context.objectToSign, context.baseURI, context.algoIdSignature, canonicalizationURI);
            context.sig.setId(XMLToolkit.createId(NODE_NAME_SIGNATURE, context.usedIDs));
            context.sig.getSignedInfo().setId(XMLToolkit.createId(NODE_NAME_SIGNED_INFO, context.usedIDs));
            context.sig.addKeyInfo(context.signerCert);
            X509Data x509Data = context.sig.getKeyInfo().itemX509Data(0);
            XMLX509IssuerSerial xmlX509IssuerSerial = new XMLX509IssuerSerial(context.objectToSign, context.signerCert);
            x509Data.add(xmlX509IssuerSerial);
            x509Data.add(new XMLX509SubjectName(context.objectToSign, context.signerCert));
            Object x509dataSelector = null;
            try {
                XMLX509SKI xmlX509SKI = new XMLX509SKI(context.objectToSign, context.signerCert);
                Iterator<ToSignDocument> skiBase64 = xmlX509SKI.getTextFromTextChild();
                x509Data.add(xmlX509SKI);
                x509dataSelector = "ds:X509SKI='" + (String)((Object)skiBase64) + "'";
            }
            catch (XMLSecurityException e) {
                x509dataSelector = "1";
            }
            KeyInfo keyInfo = context.sig.getKeyInfo();
            keyInfo.setId(XMLToolkit.createId(NODE_NAME_KEY_INFO, context.usedIDs));
            context.refKeyInfoId = XMLToolkit.createId("refKeyInfo", context.usedIDs);
            context.mapUriFileURLs = new HashMap();
            context.mapUriDocuments = new HashMap();
            context.mapUriDocuments.put(XML_LOCAL_IDREF_PREFIX + keyInfo.getId(), keyInfo.getElement());
            LOG.debug("signature type: {}", (Object)context.signatureType);
            switch (context.signatureType) {
                case ENVELOPED: {
                    for (ToSignDocument toSignDocument : context.mapUriUOMDocuments.values()) {
                        context.mapUriDocuments.put("", toSignDocument.w3Document);
                    }
                    break;
                }
                case ENVELOPING: {
                    for (ToSignDocument toSignDocument : context.mapUriUOMDocuments.values()) {
                        context.mapUriDocuments.put(XML_LOCAL_IDREF_PREFIX + toSignDocument.objectType.getId(), toSignDocument.w3Document);
                    }
                    break;
                }
            }
            context.sig.addResourceResolver((ResourceResolverSpi)new XMLResourceResolver(context));
            Transforms transforms = new Transforms(context.objectToSign);
            transforms.addTransform(canonicalizationURI);
            Transforms keyInfoTransforms = new Transforms(context.objectToSign);
            context.sig.getElement().appendChild(keyInfo.getElement());
            keyInfo.getElement().appendChild(keyInfo.itemX509Data(0).getElement());
            if (context.objectToSign.getDocumentElement() == null) {
                context.objectToSign.appendChild(context.sig.getElement());
            } else {
                context.objectToSign.getDocumentElement().appendChild(context.sig.getElement());
            }
            if (context.signKeyInfoRequired) {
                XPath2FilterContainer xpath2C = XPath2FilterContainer.newInstanceIntersect((org.w3c.dom.Document)context.sig.getDocument(), (String)("//ds:KeyInfo[@Id='" + keyInfo.getId() + "']/ds:X509Data[" + (String)x509dataSelector + "]"));
                keyInfoTransforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", xpath2C.getElement());
            }
            keyInfoTransforms.addTransform(canonicalizationURI);
            if (context.signKeyInfoRequired) {
                context.sig.addDocument(XML_LOCAL_IDREF_PREFIX + keyInfo.getId(), keyInfoTransforms, context.algoIdDigest, context.refKeyInfoId, null);
            }
            for (ToSignDocument toSignDocument : context.mapUriUOMDocuments.values()) {
                if (toSignDocument.uri == null) {
                    Transforms ltransforms;
                    if (toSignDocument.objectType == null) {
                        ltransforms = new Transforms(context.objectToSign);
                        ltransforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
                        ltransforms.addTransform(canonicalizationURI);
                        context.sig.addDocument("", ltransforms, context.algoIdDigest, toSignDocument.refIdObjectToSign, "");
                        continue;
                    }
                    ltransforms = transforms;
                    if (toSignDocument.addCanonicalizationTranforms) {
                        ltransforms = new Transforms(context.objectToSign);
                        ltransforms.addTransform(canonicalizationURI);
                    }
                    context.sig.addDocument(XML_LOCAL_IDREF_PREFIX + toSignDocument.objectType.getId(), ltransforms, context.algoIdDigest, toSignDocument.refIdObjectToSign, null);
                    continue;
                }
                context.sig.addDocument(toSignDocument.uri, null, context.algoIdDigest, toSignDocument.refIdObjectToSign, null);
            }
            this.applySignedProperties(context, new DataObjectFormatType[0]);
            context.mapUriDocuments.put(XML_LOCAL_IDREF_PREFIX + context.signedProperties.getId(), context.signedPropertiesNode);
            context.sig.addDocument(XML_LOCAL_IDREF_PREFIX + context.signedProperties.getId(), transforms, context.algoIdDigest, null, XADES_REFERENCE_TYPES_SIGNED_PROPERTIES.get(0));
        }
        catch (CoreException e) {
            throw e;
        }
        catch (TransformationException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with Santuario transform exception: " + e.getMessage(), (Throwable)e);
        }
        catch (XMLSignatureException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with Santuario signature exception: " + e.getMessage(), (Throwable)e);
        }
        catch (XMLSecurityException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with Santuario security exception: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            XMLSignPluginImpl.handleUnknownExceptions((CSLSignatureException.Failure)CSLSignatureException.Failure.SIGNING_PREPARE, (String)type, (Exception)e);
        }
        finally {
            LOG.debug("{} sign prepared", (Object)type);
        }
        try {
            LOG.debug("{} sign processing ...", (Object)type);
            LOG.debug("Start signing");
            context.sig.sign((Key)context.privateKeyResource);
            LOG.debug("Finished signing");
            this.applyUnsignedProperties(context, new DataObjectFormatType[0]);
            this.adesPostSignModifyXMLSteps(context, db);
            LOG.debug("{} signature created", (Object)type);
            LOG.debug("prepare response...");
            ArrayList<SimpleSignedData> signedDatas = null;
            try {
                signedDatas = new ArrayList<SimpleSignedData>();
                signedDatas.add(new SimpleSignedData(((DataToBeSigned)signRequest.getDataToBeSigned().get(0)).getDocuments(), (Document)new XMLDocumentImpl("signed-" + context.firstToSignDocument.document.getId() + "-signed", "signed-" + context.firstToSignDocument.document.getContentType(), (CSLDocumentDataHandler<org.w3c.dom.Document>)CSLDocumentDataHandler.createXMLDOMDocumentDataHandler((org.w3c.dom.Document)context.targetDoc, (Environment)env))));
            }
            finally {
                LOG.debug("response prepared");
            }
            SignedDataResponseImpl signedDataResponseImpl = new SignedDataResponseImpl(signedDatas);
            return signedDataResponseImpl;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (DOMException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to sign with xml dom exception: " + e.getMessage(), (Throwable)e);
        }
        catch (XMLSignatureException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to sign with Santuario signature exception: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign: " + e.getMessage(), (Throwable)e);
        }
        finally {
            LOG.debug("{} sign finished", (Object)type);
        }
    }

    private void adesPostSignModifyXMLSteps(XMLSigningContext context, DocumentBuilder db) throws CSLSignatureException, CoreException, XPathExpressionException {
        try {
            ObjectType qualifyingPropertiesObject = XMLToolkit.createObject(null, null, XMLToolkit.jaxbToElement(context.qualifyingProperties), context.usedIDs);
            context.docQualifiedProps = XMLToolkit.jaxbToDocument(qualifyingPropertiesObject, org.etsi.uri._01903.v1_4.ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to create QualifyingProperties node at jaxb: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to create QualifyingProperties node: " + e.getMessage(), (Throwable)e);
        }
        context.targetDoc = db.newDocument();
        Element sigElement = context.sig.getElement();
        context.sigNode = context.targetDoc.importNode(sigElement, true);
        context.targetDoc.appendChild(context.sigNode);
        context.sigNode.appendChild(context.targetDoc.importNode(context.docQualifiedProps.getDocumentElement(), true));
        switch (context.signatureType) {
            case DETACHED: {
                break;
            }
            case ENVELOPED: {
                ToSignDocument toSignDocument1 = context.mapUriUOMDocuments.values().iterator().next();
                context.signatureTargetNode = toSignDocument1.w3Document.getDocumentElement();
                SignOptions signOptions = context.getSignOptions();
                this.insertSignatureNode(context, signOptions);
                context.targetDoc = toSignDocument1.w3Document;
                break;
            }
            default: {
                for (ToSignDocument toSignDocument : context.mapUriUOMDocuments.values()) {
                    if (toSignDocument.w3Document == null) continue;
                    context.sigNode.appendChild(context.targetDoc.importNode(toSignDocument.w3Document.getDocumentElement(), true));
                }
            }
        }
    }

    private void insertSignatureNode(XMLSigningContext context, SignOptions signOptions) throws CoreException, XPathExpressionException {
        org.w3c.dom.Document document = context.firstToSignDocument.w3Document;
        this.setupSignatureNodeTargetLocation(context, signOptions, document);
        context.sigNode = document.importNode(context.sigNode, true);
        if (context.insert) {
            context.signatureTargetNode.getParentNode().insertBefore(context.sigNode, context.signatureTargetNode);
        } else {
            context.signatureTargetNode.appendChild(context.sigNode);
        }
    }

    private void setupSignatureNodeTargetLocation(XMLSigningContext context, SignOptions signOptions, org.w3c.dom.Document document) throws CoreException, XPathExpressionException {
        context.insert = false;
        if (XMLSignEnvelopedOptionsImpl.class.isInstance(signOptions)) {
            context.signatureNodeTargetLocation = context.rawSignatureNodeTargetLocation = ((XMLSignEnvelopedOptionsImpl)((Object)XMLSignEnvelopedOptionsImpl.class.cast(signOptions))).getSignatureNodeTargetLocation();
            if (context.rawSignatureNodeTargetLocation != null && !context.rawSignatureNodeTargetLocation.isEmpty()) {
                context.insert = context.rawSignatureNodeTargetLocation.endsWith("/parent::*");
                if (context.insert) {
                    context.signatureNodeTargetLocation = context.signatureNodeTargetLocation.substring(0, context.signatureNodeTargetLocation.length() - "/parent::*".length());
                }
                XPathExpression xpath = null;
                try {
                    xpath = XMLToolkit.createXPathEpression(context.signatureNodeTargetLocation, XMLToolkit.createNamespaceContext(document, new Class[0]));
                }
                catch (XPathExpressionException e) {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "building XPathExpression failed: " + context.rawSignatureNodeTargetLocation + "/" + context.signatureNodeTargetLocation + ", insert: " + context.insert + ", " + e.getMessage(), (Throwable)e);
                }
                NodeList nodeList = (NodeList)xpath.evaluate(document, XPathConstants.NODESET);
                if (nodeList == null || nodeList.getLength() == 0) {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "can not locate target to add signature node to: " + context.rawSignatureNodeTargetLocation + "/" + context.signatureNodeTargetLocation + ", insert: " + context.insert);
                }
                context.signatureTargetNode = nodeList.item(0);
                context.insert = context.insert & document.getDocumentElement() != context.signatureTargetNode;
            }
        }
    }

    private void applyUnsignedProperties(XMLSigningContext context, DataObjectFormatType ... dataObjects) throws CoreException {
        if (context.qualifyingProperties == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "no qualifying properties present");
        }
        UnsignedProperties externalUnsignedProperties = context.signerInfo.getUnsignedProperties();
        if (externalUnsignedProperties != null && !externalUnsignedProperties.isEmpty()) {
            ObjectFactory xadesObjectFactory = new ObjectFactory();
            if (context.qualifyingProperties.getUnsignedProperties() == null) {
                context.unsignedProperties = xadesObjectFactory.createUnsignedPropertiesType();
                context.qualifyingProperties.setUnsignedProperties(context.unsignedProperties);
            }
            UnsignedSignaturePropertiesType unsignedSignatureProperties = context.qualifyingProperties.getUnsignedProperties().getUnsignedSignatureProperties();
            UnsignedDataObjectPropertiesType unsignedDataObjectProperties = context.qualifyingProperties.getUnsignedProperties().getUnsignedDataObjectProperties();
            this.processUnsignedProperties(context.signerCert, unsignedSignatureProperties, unsignedDataObjectProperties, externalUnsignedProperties, context);
        }
    }

    private void processUnsignedProperties(X509Certificate signerCert, UnsignedSignaturePropertiesType unsignedSignatureProperties, UnsignedDataObjectPropertiesType unsignedDataObjectProperties, UnsignedProperties externalUnsignedProperties, XMLSigningContext context) throws CoreException {
        try {
            if (externalUnsignedProperties != null && !externalUnsignedProperties.isEmpty()) {
                for (UnsignedProperty unsignedProperty : externalUnsignedProperties) {
                    boolean isDataObjectProperty;
                    Node nodeValue = this.applyValue(context, (SignProperty)unsignedProperty, isDataObjectProperty = unsignedProperty instanceof XMLDataObjectPropertiesMarker, XMLUnsignedProperty.class, unsignedDataObjectProperties, unsignedSignatureProperties);
                    if (nodeValue == null) continue;
                    ObjectFactory xadesObjectFactory = new ObjectFactory();
                    AnyType any = xadesObjectFactory.createAnyType();
                    any.getContent().add(nodeValue);
                    if (isDataObjectProperty) {
                        unsignedDataObjectProperties.getUnsignedDataObjectProperty().add(any);
                        continue;
                    }
                    unsignedSignatureProperties.getCounterSignatureOrSignatureTimeStampOrCompleteCertificateRefs().add(any);
                }
            }
        }
        catch (IOException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to process unsigned properties with io exception: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to process unsigned properties: " + e.getMessage(), (Throwable)e);
        }
    }

    private Node applyValue(XMLSigningContext context, SignProperty xmlProperty, boolean dataObjectProperty, Class<? extends XMLProperty> xmlPropertyClass, Object dataObjectProperties, Object signedUnsignedProperties) throws IOException {
        try {
            Node nodeValue = null;
            Object encodedProperty = null;
            if (!dataObjectProperty && xmlProperty instanceof SigningTime && signedUnsignedProperties instanceof SignedSignaturePropertiesType) {
                try {
                    long time = ((SigningTime)xmlProperty).getAny().getTime().getTime();
                    time -= time % 1000L;
                    ((SignedSignaturePropertiesType)signedUnsignedProperties).setSigningTime(XMLToolkit.toXMLGregorianCalendar(new Date(time)));
                    return null;
                }
                catch (DatatypeConfigurationException e) {
                    throw new IOException("property conversion failed: " + encodedProperty + " / " + xmlProperty.getClass().getName(), e);
                }
            }
            if (xmlProperty instanceof XMLProperty) {
                nodeValue = ((XMLProperty)xmlProperty).getValue();
                encodedProperty = XMLToolkit.toXAdESAnyType(nodeValue);
            } else {
                encodedProperty = this.adesPropsConverter.encode(xmlProperty, (SigningContext)context);
            }
            if (encodedProperty instanceof Node) {
                nodeValue = (Node)encodedProperty;
                encodedProperty = XMLToolkit.toXAdESAnyType(nodeValue);
            } else if (encodedProperty instanceof XMLProperty) {
                nodeValue = ((XMLProperty)encodedProperty).getValue();
                encodedProperty = XMLToolkit.toXAdESAnyType(nodeValue);
            }
            Node lNodeValue = nodeValue;
            boolean matchingMethodUsed = false;
            if (encodedProperty instanceof Node) {
                lNodeValue = (Node)encodedProperty;
                encodedProperty = XMLToolkit.toXAdESAnyType(lNodeValue);
            } else if (xmlPropertyClass.isInstance(encodedProperty)) {
                lNodeValue = xmlPropertyClass.cast(encodedProperty).getValue();
                encodedProperty = XMLToolkit.toXAdESAnyType(lNodeValue);
            }
            if (encodedProperty != null) {
                Object object = dataObjectProperty ? dataObjectProperties : signedUnsignedProperties;
                for (Method method : object.getClass().getDeclaredMethods()) {
                    if (method.getName().startsWith("set") && method.getParameterTypes() != null && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(encodedProperty.getClass())) {
                        method.invoke(object, encodedProperty);
                        matchingMethodUsed = true;
                        break;
                    }
                    if (!method.getName().startsWith("get") || method.getParameterTypes() == null || method.getParameterTypes().length != 0 || !method.getReturnType().equals(List.class) || !method.getGenericReturnType().toString().contains("<" + encodedProperty.getClass().getName() + ">")) continue;
                    ((List)method.invoke(object, new Object[0])).add(encodedProperty);
                    matchingMethodUsed = true;
                    break;
                }
                if (!matchingMethodUsed) {
                    throw new IOException("encoded property not supported: " + encodedProperty + " / " + encodedProperty.getClass().getName());
                }
                lNodeValue = null;
            }
            return lNodeValue;
        }
        catch (IOException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IOException("failed with illegal access exception: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("failed with invocation target exception: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("failed to process unsigned properties with illegal argument exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IOException("failed to process unsigned properties with not expected exception: " + e.getMessage(), e);
        }
    }

    private void applySignedProperties(XMLSigningContext context, DataObjectFormatType ... dataObjects) throws CSLSignatureException {
        try {
            ObjectFactory xadesObjectFactory = new ObjectFactory();
            context.qualifyingProperties = xadesObjectFactory.createQualifyingPropertiesType();
            context.qualifyingProperties.setId(XMLToolkit.createId("QualifyingProperties", context.usedIDs));
            context.qualifyingProperties.setTarget(XML_LOCAL_IDREF_PREFIX + context.sig.getId());
            SignedPropertiesType signedProperties = context.signedProperties = xadesObjectFactory.createSignedPropertiesType();
            signedProperties.setId(XMLToolkit.createId("SignedProperties", context.usedIDs));
            context.qualifyingProperties.setSignedProperties(signedProperties);
            SignedSignaturePropertiesType signedSignatureProperties = xadesObjectFactory.createSignedSignaturePropertiesType();
            signedSignatureProperties.setId(XMLToolkit.createId("SignedSignatureProperties", context.usedIDs));
            this.addSigningTime(signedSignatureProperties);
            SignedProperties externalSignedProperties = context.signerInfo.getSignedProperties();
            SignedDataObjectPropertiesType signedDataObjectProperties = xadesObjectFactory.createSignedDataObjectPropertiesType();
            if (context.signKeyInfoRequired) {
                DataObjectFormatType dataObjectFormatKeyInfo = xadesObjectFactory.createDataObjectFormatType();
                dataObjectFormatKeyInfo.setObjectReference(XML_LOCAL_IDREF_PREFIX + context.refKeyInfoId);
                dataObjectFormatKeyInfo.setMimeType("application/xml");
                signedDataObjectProperties.getDataObjectFormat().add(dataObjectFormatKeyInfo);
            }
            signedProperties.setSignedDataObjectProperties(signedDataObjectProperties);
            context.docReferencesSet = this.toRefSet(context.mapUriUOMDocuments.values());
            this.processSignedProperties(context.signerCert, signedSignatureProperties, signedDataObjectProperties, externalSignedProperties, context);
            signedProperties.setSignedSignatureProperties(signedSignatureProperties);
            for (ToSignDocument toSignDocument : context.mapUriUOMDocuments.values()) {
                signedDataObjectProperties.getDataObjectFormat().add(toSignDocument.dataObjectFormat);
            }
            if (dataObjects != null) {
                for (DataObjectFormatType dataObject : dataObjects) {
                    signedDataObjectProperties.getDataObjectFormat().add(dataObject);
                }
            }
            org.w3c.dom.Document docQualifiedProps = this.addQualifyingPropertesNode(context);
            this.addSignedPropertiesNode(context, docQualifiedProps);
            this.addSignedSignaturePropertiesNode(context, docQualifiedProps);
        }
        catch (CSLSignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign at preparing XAdES related nodes or processing signed properties nodes: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addSigningTime(SignedSignaturePropertiesType signedSignatureProperties) throws CSLSignatureException {
        GregorianCalendar gregory = new GregorianCalendar();
        gregory.setTime(new Date());
        try {
            signedSignatureProperties.setSigningTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(gregory));
        }
        catch (DatatypeConfigurationException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to generate signing date", (Throwable)e);
        }
    }

    private org.w3c.dom.Document addQualifyingPropertesNode(XMLSigningContext context) throws CSLSignatureException {
        ObjectType qualifyingPropertiesObject = XMLToolkit.createObject(null, null, XMLToolkit.jaxbToElement(context.qualifyingProperties), context.usedIDs);
        org.w3c.dom.Document docQualifiedProps = null;
        try {
            docQualifiedProps = XMLToolkit.jaxbToDocument(qualifyingPropertiesObject, org.etsi.uri._01903.v1_4.ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to create QualifyingProperties node at jaxb: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to create QualifyingProperties node: " + e.getMessage(), (Throwable)e);
        }
        return docQualifiedProps;
    }

    private void addSignedPropertiesNode(XMLSigningContext context, org.w3c.dom.Document docQualifiedProps) throws CSLSignatureException {
        try {
            context.signedPropertiesNode = (Node)XPathFactory.newInstance().newXPath().compile("//child::*[local-name()='SignedProperties']").evaluate(docQualifiedProps.getDocumentElement(), XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to find SignedProperties node at xpath: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to context SignedProperties node: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addSignedSignaturePropertiesNode(XMLSigningContext context, org.w3c.dom.Document docQualifiedProps) throws CSLSignatureException {
        try {
            context.signedSignaturePropertiesNode = (Node)XPathFactory.newInstance().newXPath().compile("//child::*[local-name()='SignedSignatureProperties']").evaluate(docQualifiedProps.getDocumentElement(), XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to create SignedSignatureProperties node at xpath: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to context SignedSignatureProperties node: " + e.getMessage(), (Throwable)e);
        }
    }

    private Set<String> toRefSet(Collection<ToSignDocument> values) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ToSignDocument value : values) {
            result.add(value.refIdObjectToSign);
        }
        return result;
    }

    private void processSignedProperties(X509Certificate cert, SignedSignaturePropertiesType signedSignatureProperties, SignedDataObjectPropertiesType signedDataObjectProperties, SignedProperties externalSignedProperties, XMLSigningContext context) throws CSLSignatureException {
        try {
            if (externalSignedProperties != null && !externalSignedProperties.isEmpty()) {
                for (SignedProperty signedProperty : externalSignedProperties) {
                    boolean isDataObjectProperty;
                    Node nodeValue;
                    SigningCertificate sc;
                    if (signedProperty instanceof SigningCertificate && ((sc = (SigningCertificate)signedProperty).getCertIDs() == null || sc.getCertIDs().isEmpty())) {
                        sc.setCertIDs(Arrays.asList(new CertID(context.algoIdDigest, cert)));
                    }
                    if ((nodeValue = this.applyValue(context, (SignProperty)signedProperty, isDataObjectProperty = signedProperty instanceof XMLDataObjectPropertiesMarker, XMLSignedProperty.class, signedDataObjectProperties, signedSignatureProperties)) == null) continue;
                    ObjectFactory xadesObjectFactory = new ObjectFactory();
                    AnyType any = xadesObjectFactory.createAnyType();
                    any.getContent().add(nodeValue);
                    if (isDataObjectProperty) {
                        signedDataObjectProperties.getAny().add(any);
                        continue;
                    }
                    signedSignatureProperties.getAny().add(any);
                }
            }
        }
        catch (IOException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to sign with io exception: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to sign with not expected exception: " + e.getMessage(), (Throwable)e);
        }
    }
}

