/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.impl;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.impl.UnparsedDocument;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.sign.impl.SignOptionsImpl;
import de.governikus.csl.xml.sign.XMLSignEnvelopingParameters;
import de.governikus.csl.xml.sign.doc.XMLDocument;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class XMLSignEnvelopingOptionsImpl
extends SignOptionsImpl
implements XMLSignEnvelopingParameters {
    public static final Class<? extends Document> OUTPUT_DOCUMENT_CLASS = XMLDocument.class;
    public static final Set<Class<? extends Document>> INPUT_DOCUMENT_CLASSES;
    private final boolean xmlDocumentsToBeInserted;

    public XMLSignEnvelopingOptionsImpl(XMLSignEnvelopingOptionsImpl parameters) {
        super(Plugin.PluginID.SIGN_XML, SignatureType.ENVELOPING, INPUT_DOCUMENT_CLASSES);
        this.xmlDocumentsToBeInserted = parameters.areXMLDocumentsToBeInserted();
    }

    public XMLSignEnvelopingOptionsImpl() {
        this(false);
    }

    public XMLSignEnvelopingOptionsImpl(boolean xmlDocumentsToBeInserted) throws IllegalArgumentException {
        super(Plugin.PluginID.SIGN_XML, SignatureType.ENVELOPING, INPUT_DOCUMENT_CLASSES);
        this.xmlDocumentsToBeInserted = xmlDocumentsToBeInserted;
    }

    public XMLSignEnvelopingOptionsImpl(SignOptions signOptions, boolean xmlDocumentsToBeInserted) throws IllegalArgumentException {
        super(signOptions);
        this.pluginId = Plugin.PluginID.SIGN_XML.getID();
        this.signatureType = SignatureType.ENVELOPING;
        this.documentFormatClasses = new LinkedHashSet<Class<? extends Document>>(INPUT_DOCUMENT_CLASSES);
        this.xmlDocumentsToBeInserted = xmlDocumentsToBeInserted;
    }

    @Override
    public boolean areXMLDocumentsToBeInserted() {
        return this.xmlDocumentsToBeInserted;
    }

    static {
        LinkedHashSet<Class> tmp = new LinkedHashSet<Class>();
        tmp.add(UnparsedDocument.class);
        tmp.add(XMLDocument.class);
        INPUT_DOCUMENT_CLASSES = Collections.unmodifiableSet(tmp);
    }
}

