/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.impl;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.ReferenceResolver;
import de.governikus.csl.xml.sign.XMLSigningContext;
import java.io.IOException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;

public class XMLResourceResolver
extends ResourceResolverSpi {
    private XMLSigningContext signingContext;

    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        String uriToResolve = context.uriToResolve;
        if (this.signingContext.mapUriDocuments.containsKey(uriToResolve)) {
            return new XMLSignatureInput(this.signingContext.mapUriDocuments.get(uriToResolve));
        }
        if (this.signingContext.mapUriFileURLs.containsKey(uriToResolve)) {
            try {
                return new XMLSignatureInput(this.signingContext.mapUriFileURLs.get(uriToResolve).openStream());
            }
            catch (IOException iOException) {
            }
        } else if (this.signingContext.mapUriUOMDocuments.containsKey(uriToResolve)) {
            try {
                Document d = this.signingContext.mapUriUOMDocuments.get((Object)uriToResolve).document;
                ReferenceResolver referenceResolver = d.getReferenceResolver();
                if (referenceResolver != null && referenceResolver.canResolve(uriToResolve)) {
                    return new XMLSignatureInput(referenceResolver.getReference(uriToResolve));
                }
                return new XMLSignatureInput(d.getInputStream());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        String uriToResolve = context.uriToResolve;
        return this.signingContext.mapUriDocuments.containsKey(uriToResolve) || this.signingContext.mapUriFileURLs.containsKey(uriToResolve) || this.signingContext.mapUriUOMDocuments.containsKey(uriToResolve);
    }

    public XMLResourceResolver(XMLSigningContext context) {
        this.signingContext = context;
    }
}

