/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.impl;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.DataToBeSigned;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.xml.sign.XMLSigningContext;
import de.governikus.csl.xml.sign.doc.XMLDocument;
import de.governikus.csl.xml.sign.util.XMLToolkit;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.etsi.uri._01903.v1_3.DataObjectFormatType;
import org.etsi.uri._01903.v1_3.ObjectFactory;
import org.w3._2000._09.xmldsig.ObjectType;
import org.w3c.dom.Element;

public class ToSignDocument {
    public String refIdObjectToSign;
    public DataObjectFormatType dataObjectFormat;
    public Document document;
    public ObjectType objectType;
    public org.w3c.dom.Document w3Document;
    public String uri;
    public boolean addCanonicalizationTranforms = false;

    public ToSignDocument(XMLSigningContext context, Document document, List<String> usedIDs) throws CoreException {
        SignOptions signOptions = context.getSignOptions();
        SignatureType signatureType = signOptions.getSignatureType();
        this.refIdObjectToSign = XMLToolkit.createId("refObjectToSign", usedIDs);
        this.document = document;
        String name = document.getName();
        switch (signatureType) {
            case DETACHED: {
                try {
                    this.w3Document = XMLToolkit.createEmptyDocumentRoot();
                    this.uri = name;
                    break;
                }
                catch (ParserConfigurationException e) {
                    throw new CoreException("failed to create empty document: " + e.getMessage(), (Throwable)e);
                }
            }
            case ENVELOPED: {
                org.w3c.dom.Document w3DocToSign = null;
                try {
                    w3DocToSign = XMLToolkit.createDocument(document.getInputStream());
                }
                catch (IOException e) {
                    throw new CoreException("failed to read input document: " + e.getMessage(), (Throwable)e);
                }
                if (w3DocToSign == null) {
                    throw new CoreException("failed to read input document as XML (required for enveloped XML signature)");
                }
                this.w3Document = this.prepareW3Document(signOptions, w3DocToSign, usedIDs);
                break;
            }
            case ENVELOPING: {
                if (context.xmlDocumentsToBeInserted) {
                    Element nodeCandidateToSign = null;
                    if (document instanceof XMLDocument) {
                        nodeCandidateToSign = ((org.w3c.dom.Document)((XMLDocument)document).getParsed()).getDocumentElement();
                    } else {
                        try {
                            nodeCandidateToSign = XMLToolkit.createDocument(document.getInputStream()).getDocumentElement();
                        }
                        catch (IOException e) {
                            throw new CoreException("failed to read input document: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (nodeCandidateToSign != null) {
                        this.objectType = XMLToolkit.createObject("ObjectToSign", null, nodeCandidateToSign, usedIDs);
                        this.addCanonicalizationTranforms = true;
                    }
                }
                if (this.objectType == null) {
                    try {
                        this.objectType = XMLToolkit.createObject("ObjectToSign", "http://www.w3.org/2000/09/xmldsig#base64", DatatypeConverter.printBase64Binary((byte[])XMLToolkit.read(document.getInputStream())), usedIDs);
                    }
                    catch (IOException e) {
                        throw new CoreException("failed to read document: " + e.getMessage(), (Throwable)e);
                    }
                    this.objectType.setMimeType(document.getContentType());
                }
                try {
                    this.w3Document = XMLToolkit.jaxbToDocument(this.objectType, new String[0]);
                    break;
                }
                catch (JAXBException e) {
                    throw new CoreException("document conversion failed: " + e.getMessage(), (Throwable)e);
                }
            }
            default: {
                throw new CoreException("not implemented signature type: " + signatureType);
            }
        }
        ObjectFactory xadesObjectFactory = new ObjectFactory();
        this.dataObjectFormat = xadesObjectFactory.createDataObjectFormatType();
        this.dataObjectFormat.setObjectReference("#" + this.refIdObjectToSign);
        this.dataObjectFormat.setMimeType(document.getContentType());
    }

    private org.w3c.dom.Document prepareW3Document(SignOptions signOptions, org.w3c.dom.Document w3DocToSign, List<String> usedIDs) throws CoreException {
        SignatureType signatureType = signOptions.getSignatureType();
        switch (signatureType) {
            case ENVELOPED: {
                break;
            }
            default: {
                return w3DocToSign;
            }
        }
        this.refIdObjectToSign = XMLToolkit.createId("ObjectToSign", usedIDs);
        this.objectType = null;
        return w3DocToSign;
    }

    public static Map<String, ToSignDocument> convertDocs(XMLSigningContext context, List<String> usedIDs) throws CoreException {
        LinkedHashMap<String, ToSignDocument> mapUriUOMDocuments = new LinkedHashMap<String, ToSignDocument>();
        SignRequest signRequest = context.getSignRequest();
        for (Document cd : ((DataToBeSigned)signRequest.getDataToBeSigned().get(0)).getDocuments()) {
            ToSignDocument tsd = new ToSignDocument(context, cd, usedIDs);
            mapUriUOMDocuments.put(tsd.uri == null ? cd.getId() : tsd.uri, tsd);
        }
        return mapUriUOMDocuments;
    }
}

