/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xml.sign.doc.impl;

import de.governikus.csl.uom.impl.ParsedDocumentImpl;
import de.governikus.csl.uom.util.CSLDocumentDataHandler;
import de.governikus.csl.xml.sign.doc.XMLDocument;
import de.governikus.csl.xml.sign.util.XMLToolkit;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XMLDocumentImpl
extends ParsedDocumentImpl<Document>
implements XMLDocument {
    private NodeList signatureNodes;
    private boolean xadesSigned;

    public XMLDocumentImpl(String id, String name, CSLDocumentDataHandler<Document> xmlDocumentHandler) throws IOException {
        this(id, name, xmlDocumentHandler, null);
    }

    public XMLDocumentImpl(String id, String name, CSLDocumentDataHandler<Document> xmlDocumentHandler, NodeList signatureNodes) throws IOException {
        super(id, name, xmlDocumentHandler, "application/xml");
        this.parsedDocumentType = (Document)xmlDocumentHandler.getContent();
        if (signatureNodes == null) {
            try {
                this.signatureNodes = XMLToolkit.getNodes((Document)this.parsedDocumentType, "//ds:Signature", XMLToolkit.XMLDSIG_CONTEXT);
            }
            catch (Exception e) {
                this.signatureNodes = null;
            }
        } else {
            this.signatureNodes = signatureNodes;
        }
        boolean lXAdESSigned = false;
        if (this.signatureNodes != null && this.signatureNodes.getLength() > 0) {
            try {
                NodeList xadesNodeList = XMLToolkit.getNodes((Document)this.parsedDocumentType, "//xades:QualifyingProperties", XMLToolkit.XADES132_CONTEXT);
                lXAdESSigned = xadesNodeList != null && xadesNodeList.getLength() != 0;
            }
            catch (Exception e) {
                lXAdESSigned = false;
            }
        }
        this.xadesSigned = lXAdESSigned;
    }

    @Override
    public NodeList getSignatureNodes() {
        return this.signatureNodes;
    }

    public void setSignatureNodes(NodeList signatureNodes) {
        this.signatureNodes = signatureNodes;
    }

    @Override
    public boolean isSigned() {
        return this.signatureNodes != null && this.signatureNodes.getLength() != 0;
    }

    @Override
    public boolean isXAdESSigned() {
        return this.xadesSigned;
    }

    public void setXAdESSigned(boolean xadesSigned) {
        this.xadesSigned = xadesSigned;
    }
}

